/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGui;
import com.bekvon.bukkit.CMIGUI.CMIGuiButton;
import com.bekvon.bukkit.CMIGUI.CommandType;
import com.bekvon.bukkit.CMIGUI.GUIButtonCommand;
import com.bekvon.bukkit.CMIGUI.GUIListener;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.residence.Residence;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIManager {
    private static HashMap<UUID, CMIGui> map = new HashMap();
    public static final String CMIGUIIcon = "CMIGUIIcon";
    public static final String LIProtection = "LIProtection";

    static {
        GUIManager.registerListener();
    }

    public static void registerListener() {
        Residence.getInstance().getServer().getPluginManager().registerEvents((Listener)new GUIListener(Residence.getInstance()), (Plugin)Residence.getInstance());
    }

    public void closeAll() {
        for (Map.Entry<UUID, CMIGui> entry : map.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            player.closeInventory();
        }
    }

    public static GUIClickType getClickType(boolean bl, boolean bl2, InventoryAction inventoryAction) {
        if (!bl && !bl2 && (inventoryAction.equals((Object)InventoryAction.NOTHING) || inventoryAction.equals((Object)InventoryAction.CLONE_STACK))) {
            return GUIClickType.MiddleMouse;
        }
        if (bl && !bl2) {
            return GUIClickType.Left;
        }
        if (bl && bl2) {
            return GUIClickType.LeftShift;
        }
        if (!bl && !bl2) {
            return GUIClickType.Right;
        }
        return GUIClickType.RightShift;
    }

    public static boolean processClick(final Player player, List<Integer> list2, final GUIClickType gUIClickType) {
        CMIGui cMIGui = map.get(player.getUniqueId());
        if (cMIGui == null) {
            return false;
        }
        int n = 0;
        for (Integer n2 : list2) {
            final CMIGuiButton cMIGuiButton = cMIGui.getButtons().get(n2);
            if (cMIGuiButton == null) continue;
            ++n;
            boolean bl = true;
            if (bl) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Residence.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        for (GUIButtonCommand gUIButtonCommand : cMIGuiButton.getCommands(gUIClickType)) {
                            GUIManager.performCommand(player, gUIButtonCommand.getCommand(), gUIButtonCommand.getVis());
                        }
                    }
                }, 1L);
            }
            cMIGuiButton.click();
            cMIGuiButton.click(gUIClickType);
            if (cMIGuiButton.isCloseInv()) {
                player.closeInventory();
            }
            if (!cMIGuiButton.getCommands(gUIClickType).isEmpty()) break;
        }
        if (n == 0) {
            cMIGui.outsideClick(gUIClickType);
        }
        return false;
    }

    public static void performCommand(CommandSender commandSender, String string, CommandType commandType) {
        if (commandSender instanceof Player) {
            GUIManager.performCommand((Player)commandSender, string, commandType);
        } else {
            ServerCommandEvent serverCommandEvent = new ServerCommandEvent(commandSender, string.startsWith("/") ? string : "/" + string);
            Bukkit.getServer().getPluginManager().callEvent((Event)serverCommandEvent);
            if (!serverCommandEvent.isCancelled()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)(serverCommandEvent.getCommand().startsWith("/") ? serverCommandEvent.getCommand().substring(1, serverCommandEvent.getCommand().length()) : serverCommandEvent.getCommand()));
            }
            if (!commandType.equals((Object)CommandType.silent)) {
                Bukkit.getLogger().log(Level.INFO, String.valueOf(commandSender.getName()) + " issued " + commandType.name() + " command: /" + string);
            }
        }
    }

    public static void performCommand(Player player, String string, CommandType commandType) {
        if (player == null) {
            Residence.getInstance().consoleMessage("&cCant perform command (" + string + "). Player is NULL");
            return;
        }
        if (string == null) {
            Residence.getInstance().consoleMessage("&cCant perform command (" + string + "). Command is NULL");
            return;
        }
        PlayerCommandPreprocessEvent playerCommandPreprocessEvent = new PlayerCommandPreprocessEvent(player, string.startsWith("/") ? string : "/" + string);
        Bukkit.getServer().getPluginManager().callEvent((Event)playerCommandPreprocessEvent);
        if (!playerCommandPreprocessEvent.isCancelled()) {
            player.performCommand(playerCommandPreprocessEvent.getMessage().startsWith("/") ? playerCommandPreprocessEvent.getMessage().substring(1, playerCommandPreprocessEvent.getMessage().length()) : playerCommandPreprocessEvent.getMessage());
        }
        if (!commandType.equals((Object)CommandType.silent)) {
            Bukkit.getLogger().log(Level.INFO, String.valueOf(player.getName()) + " issued " + commandType.name() + " command: /" + string);
        }
    }

    public static boolean isLockedPart(Player player, List<Integer> list2) {
        CMIGui cMIGui = map.get(player.getUniqueId());
        if (cMIGui == null) {
            return false;
        }
        int n = cMIGui.getInv().getSize();
        int n2 = n + 36 - 9;
        int n3 = n + 36;
        for (Integer n4 : list2) {
            if (n4 > n3 || n3 < 0) continue;
            if (n4 < n && cMIGui.isLocked(InvType.Gui) && cMIGui.isPermLocked(InvType.Gui)) {
                return true;
            }
            if (n4 >= n && n4 < n2 && cMIGui.isLocked(InvType.Main) && cMIGui.isPermLocked(InvType.Main)) {
                return true;
            }
            if (n4 < n2 || n4 >= n3 || (!cMIGui.isLocked(InvType.Quickbar) || !cMIGui.isPermLocked(InvType.Quickbar)) && (!cMIGui.isLocked(InvType.Main) || !cMIGui.isPermLocked(InvType.Main))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canClick(Player player, List<Integer> list2) {
        try {
            Integer n;
            CMIGuiButton cMIGuiButton;
            CMIGui cMIGui = map.get(player.getUniqueId());
            if (cMIGui == null) {
                return true;
            }
            Iterator<Integer> iterator = list2.iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                n = iterator.next();
            } while ((cMIGuiButton = cMIGui.getButtons().get(n)) == null || cMIGuiButton.getFieldType() != GUIFieldType.Locked);
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static CMIGui getGui(Player player) {
        return map.get(player.getUniqueId());
    }

    public static boolean isOpenedGui(Player player) {
        CMIGui cMIGui = map.get(player.getUniqueId());
        if (cMIGui == null) {
            return false;
        }
        return player.getOpenInventory() != null;
    }

    public static boolean removePlayer(Player player) {
        CMIGui cMIGui = map.remove(player.getUniqueId());
        if (cMIGui == null) {
            return false;
        }
        if (player.getOpenInventory() != null && player.getOpenInventory().getTopInventory().equals(cMIGui.getInv())) {
            player.closeInventory();
        }
        cMIGui.processClose();
        cMIGui.onClose();
        return true;
    }

    public static void generateInventory(CMIGui cMIGui) {
        Inventory inventory = null;
        inventory = cMIGui.getInvSize() != null ? Bukkit.createInventory(null, (int)cMIGui.getInvSize().getFields(), (String)cMIGui.getTitle()) : Bukkit.createInventory(null, (InventoryType)cMIGui.getInvType(), (String)cMIGui.getTitle());
        if (inventory == null) {
            return;
        }
        for (Map.Entry<Integer, CMIGuiButton> entry : cMIGui.getButtons().entrySet()) {
            if (entry.getKey() > inventory.getSize()) continue;
            try {
                ItemStack itemStack = entry.getValue().getItem(cMIGui.getPlayer());
                ItemStack itemStack2 = itemStack = itemStack == null ? null : itemStack.clone();
                if (itemStack != null && entry.getValue().isLocked()) {
                    itemStack = CMIReflections.setNbt(itemStack, CMIGUIIcon, LIProtection);
                }
                inventory.setItem(entry.getKey().intValue(), itemStack);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
        }
        cMIGui.setInv(inventory);
    }

    public static void openGui(CMIGui cMIGui) {
        Player player = cMIGui.getPlayer();
        if (player.isSleeping()) {
            return;
        }
        CMIGui cMIGui2 = null;
        if (GUIManager.isOpenedGui(player) && !cMIGui.isSimilar(cMIGui2 = GUIManager.getGui(player))) {
            cMIGui2 = null;
        }
        if (cMIGui2 == null) {
            GUIManager.generateInventory(cMIGui);
            player.closeInventory();
            player.openInventory(cMIGui.getInv());
            cMIGui.onOpen();
            map.put(player.getUniqueId(), cMIGui);
        } else {
            GUIManager.updateContent(cMIGui);
        }
    }

    public static void updateContent(CMIGui cMIGui) {
        Player player = cMIGui.getPlayer();
        if (player.getOpenInventory() == null || player.getOpenInventory().getTopInventory() == null) {
            player.closeInventory();
        }
        CMIReflections.updateInventoryTitle(player, cMIGui.getTitle());
        player.getOpenInventory().getTopInventory().setContents(cMIGui.getInv().getContents());
        cMIGui.setInv(player.getOpenInventory().getTopInventory());
        map.put(player.getUniqueId(), cMIGui);
    }

    public static enum CmiInventoryType {
        regular,
        SavedInv,
        EditableInv,
        RecipeCreator,
        ArmorStandEditor,
        ArmorStandCopy,
        EntityInventoryEditor,
        Recipes,
        SellHand;

    }

    public static enum GUIButtonLocation {
        topLeft(0, 0),
        topRight(0, 1),
        bottomLeft(1, 0),
        bottomRight(1, 1);

        private Integer row;
        private Integer collumn;

        private GUIButtonLocation(Integer n2, Integer n3) {
            this.collumn = n3;
            this.row = n2;
        }

        public Integer getRow() {
            return this.row;
        }

        public Integer getCollumn() {
            return this.collumn;
        }
    }

    public static enum GUIClickType {
        Left,
        LeftShift,
        Right,
        RightShift,
        MiddleMouse;

    }

    public static enum GUIFieldType {
        Free,
        Locked;

    }

    public static enum GUIRows {
        r1(1),
        r2(2),
        r3(3),
        r4(4),
        r5(5),
        r6(6);

        private int rows;

        private GUIRows(int n2) {
            this.rows = n2;
        }

        public Integer getFields() {
            return this.rows * 9;
        }

        public Integer getRows() {
            return this.rows;
        }

        public static GUIRows getByRows(Integer n) {
            if (n > 9) {
                n = n / 9;
            }
            GUIRows[] gUIRowsArray = GUIRows.values();
            int n2 = gUIRowsArray.length;
            int n3 = 0;
            while (n3 < n2) {
                GUIRows gUIRows = gUIRowsArray[n3];
                if (gUIRows.getRows().equals(n)) {
                    return gUIRows;
                }
                ++n3;
            }
            return r6;
        }
    }

    public static enum InvType {
        Gui,
        Main,
        Quickbar;

    }
}

