/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGui;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.residence.Residence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;

public class GUIListener
implements Listener {
    Residence plugin;
    private HashMap<UUID, Long> LastClick = new HashMap();

    public GUIListener(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNormalInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        Player player = (Player)inventoryCloseEvent.getPlayer();
        if (GUIManager.isOpenedGui(player) && GUIManager.removePlayer(player)) {
            player.updateInventory();
            this.clearIconItems(player);
        }
    }

    private void clearIconItems(Player player) {
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack = itemStackArray[n2];
            Object object = CMIReflections.getNbt(itemStack, "CMIGUIIcon");
            if (object != null && object instanceof String && ((String)object).equalsIgnoreCase("LIProtection")) {
                player.getInventory().remove(itemStack);
            }
            ++n2;
        }
    }

    private boolean canClickByTimer(UUID uUID) {
        Long l = this.LastClick.get(uUID);
        if (l == null) {
            this.LastClick.put(uUID, System.currentTimeMillis());
            return true;
        }
        if (l + 51L > System.currentTimeMillis()) {
            this.LastClick.put(uUID, System.currentTimeMillis());
            return false;
        }
        this.LastClick.put(uUID, System.currentTimeMillis());
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.isCancelled() && !inventoryClickEvent.getWhoClicked().getGameMode().toString().equalsIgnoreCase("Spectator")) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!GUIManager.isOpenedGui(player)) {
            return;
        }
        CMIGui cMIGui = GUIManager.getGui(player);
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK || inventoryClickEvent.getHotbarButton() != -1) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
        if (!cMIGui.isAllowShift() && inventoryClickEvent.isShiftClick()) {
            inventoryClickEvent.setCancelled(true);
        }
        if (!(inventoryClickEvent.getAction().equals((Object)InventoryAction.PICKUP_ALL) || inventoryClickEvent.getAction().equals((Object)InventoryAction.PICKUP_ONE) || inventoryClickEvent.getAction().equals((Object)InventoryAction.PICKUP_HALF) || inventoryClickEvent.getAction().equals((Object)InventoryAction.PICKUP_SOME) || inventoryClickEvent.getAction().equals((Object)InventoryAction.PLACE_ALL) || inventoryClickEvent.getAction().equals((Object)InventoryAction.PLACE_ONE) || inventoryClickEvent.getAction().equals((Object)InventoryAction.PLACE_SOME) || cMIGui.isAllowShift() || inventoryClickEvent.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY))) {
            inventoryClickEvent.setCancelled(true);
        }
        if (!cMIGui.isAllowPickUpAll() && !this.canClickByTimer(player.getUniqueId())) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(inventoryClickEvent.getRawSlot());
        if (!GUIManager.canClick(player, arrayList)) {
            inventoryClickEvent.setCancelled(true);
        }
        if (GUIManager.isLockedPart(player, arrayList)) {
            inventoryClickEvent.setCancelled(true);
        }
        InventoryAction inventoryAction = inventoryClickEvent.getAction();
        GUIManager.processClick(player, arrayList, GUIManager.getClickType(inventoryClickEvent.isLeftClick(), inventoryClickEvent.isShiftClick(), inventoryAction));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryMove(InventoryDragEvent inventoryDragEvent) {
        if (inventoryDragEvent.isCancelled() && !inventoryDragEvent.getWhoClicked().getGameMode().toString().equalsIgnoreCase("Spectator")) {
            return;
        }
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        if (!GUIManager.isOpenedGui(player)) {
            return;
        }
        CMIGui cMIGui = GUIManager.getGui(player);
        if (!cMIGui.isAllowPickUpAll() && !this.canClickByTimer(player.getUniqueId())) {
            inventoryDragEvent.setCancelled(true);
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(inventoryDragEvent.getRawSlots());
        if (!GUIManager.canClick(player, arrayList)) {
            inventoryDragEvent.setCancelled(true);
        }
        if (GUIManager.isLockedPart(player, arrayList)) {
            inventoryDragEvent.setCancelled(true);
        }
        GUIManager.processClick(player, arrayList, GUIManager.getClickType(true, false, null));
    }
}

