/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGui;
import com.bekvon.bukkit.CMIGUI.CommandType;
import com.bekvon.bukkit.CMIGUI.GUIButtonCommand;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.CMIItemStack;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.residence.Residence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CMIGuiButton {
    private Integer slot = null;
    private GUIManager.GUIFieldType fieldType = GUIManager.GUIFieldType.Locked;
    private boolean closeInv = false;
    private HashMap<GUIManager.GUIClickType, List<GUIButtonCommand>> commandMap = new HashMap();
    private List<String> permissions = new ArrayList<String>();
    private ItemStack item = null;
    private int schedId = -1;
    private int updateInterval = 20;
    private int ticks = 0;
    private CMIGui sgui;

    public CMIGuiButton clone() {
        CMIGuiButton cMIGuiButton = new CMIGuiButton(this.slot, this.fieldType, this.item);
        cMIGuiButton.setPermissions(new ArrayList<String>(this.permissions));
        cMIGuiButton.setCommandMap(new HashMap<GUIManager.GUIClickType, List<GUIButtonCommand>>(this.commandMap));
        return cMIGuiButton;
    }

    public CMIGuiButton(Integer n, GUIManager.GUIFieldType gUIFieldType, ItemStack itemStack) {
        this.slot = n;
        this.fieldType = gUIFieldType;
        this.item = itemStack == null ? null : itemStack.clone();
    }

    public CMIGuiButton(Integer n) {
        this.slot = n;
    }

    public void hideItemFlags() {
        if (this.item != null) {
            this.item = CMIReflections.HideFlag(this.item, 63);
        }
    }

    public CMIGuiButton(ItemStack itemStack) {
        this.item = itemStack == null ? null : itemStack.clone();
    }

    public CMIGuiButton(CMIMaterial cMIMaterial) {
        this.item = cMIMaterial == null ? null : cMIMaterial.newItemStack();
    }

    public CMIGuiButton(Integer n, CMIItemStack cMIItemStack) {
        this(n, cMIItemStack.getItemStack());
    }

    public CMIGuiButton(Integer n, Material material2) {
        this(n, CMIMaterial.get(material2), null);
    }

    public CMIGuiButton(Integer n, CMIMaterial cMIMaterial) {
        this(n, cMIMaterial, null);
    }

    @Deprecated
    public CMIGuiButton(Integer n, Material material2, int n2) {
        this(n, material2, n2, null);
    }

    public CMIGuiButton(Integer n, Material material2, String string) {
        this(n, CMIMaterial.get(material2), string);
    }

    public CMIGuiButton(Integer n, CMIMaterial cMIMaterial, String string) {
        this.slot = n;
        ItemStack itemStack = this.item = cMIMaterial == null ? null : cMIMaterial.newItemStack();
        if (string != null) {
            ItemMeta itemMeta = this.item.getItemMeta();
            itemMeta.setDisplayName(CMIChatColor.translate(string));
            this.item.setItemMeta(itemMeta);
        }
    }

    @Deprecated
    public CMIGuiButton(Integer n, Material material2, int n2, String string) {
        this.slot = n;
        this.item = new ItemStack(material2, 1, (short)n2);
        if (string != null) {
            ItemMeta itemMeta = this.item.getItemMeta();
            itemMeta.setDisplayName(CMIChatColor.translate(string));
            this.item.setItemMeta(itemMeta);
        }
    }

    public CMIGuiButton(Integer n, ItemStack itemStack) {
        CMIMaterial cMIMaterial;
        this.slot = n;
        ItemStack itemStack2 = this.item = itemStack == null ? null : itemStack.clone();
        if (this.item != null && this.item.getDurability() == Short.MAX_VALUE && (cMIMaterial = CMIMaterial.getRandom(CMIMaterial.get(this.item))) != null && cMIMaterial.getLegacyData() != -1) {
            this.item.setDurability(cMIMaterial.getLegacyData());
        }
    }

    public void setGui(CMIGui cMIGui) {
        this.sgui = cMIGui;
    }

    public void startAutoUpdate(int n) {
        this.updateInterval = n;
        this.tasker();
    }

    @Deprecated
    public void startAutoUpdate(CMIGui cMIGui, int n) {
        this.updateInterval = n;
        this.sgui = cMIGui;
        this.tasker();
    }

    private void tasker() {
        if (this.schedId != -1) {
            Bukkit.getScheduler().cancelTask(this.schedId);
            this.schedId = -1;
        }
        final CMIGuiButton cMIGuiButton = this;
        this.schedId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Residence.getInstance(), new Runnable(){

            @Override
            public void run() {
                CMIGuiButton cMIGuiButton2 = CMIGuiButton.this;
                cMIGuiButton2.ticks = cMIGuiButton2.ticks + 1;
                if (CMIGuiButton.this.sgui != null && GUIManager.getGui(CMIGuiButton.this.sgui.getPlayer()) != CMIGuiButton.this.sgui && CMIGuiButton.this.schedId != -1) {
                    Bukkit.getScheduler().cancelTask(CMIGuiButton.this.schedId);
                    CMIGuiButton.this.schedId = -1;
                    return;
                }
                CMIGuiButton.this.updateLooks();
                CMIGuiButton.this.update(CMIGuiButton.this.sgui);
                if (CMIGuiButton.this.sgui != null) {
                    CMIGuiButton.this.sgui.updateButton(cMIGuiButton);
                }
            }
        }, 20L, (long)this.updateInterval);
    }

    public void updateLooks() {
    }

    public void update() {
        if (this.sgui != null) {
            this.sgui.updateButton(this);
        }
    }

    public void update(CMIGui cMIGui) {
        if (cMIGui != null) {
            cMIGui.updateButton(this);
        }
    }

    public Integer getSlot() {
        return this.slot;
    }

    public CMIGuiButton setSlot(Integer n) {
        this.slot = n;
        return this;
    }

    public GUIManager.GUIFieldType getFieldType() {
        return this.fieldType;
    }

    public CMIGuiButton setFieldType(GUIManager.GUIFieldType gUIFieldType) {
        this.fieldType = gUIFieldType;
        return this;
    }

    public CMIGuiButton lockField() {
        this.fieldType = GUIManager.GUIFieldType.Locked;
        return this;
    }

    public CMIGuiButton unlockField() {
        this.fieldType = GUIManager.GUIFieldType.Free;
        return this;
    }

    public boolean isLocked() {
        return this.fieldType.equals((Object)GUIManager.GUIFieldType.Locked);
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public CMIGuiButton addPermission(String string) {
        this.permissions.add(string);
        return this;
    }

    public void setPermissions(List<String> list2) {
        this.permissions = list2;
    }

    public List<GUIButtonCommand> getCommands(GUIManager.GUIClickType gUIClickType) {
        List<GUIButtonCommand> list2 = this.commandMap.get((Object)gUIClickType);
        if (list2 == null) {
            list2 = new ArrayList<GUIButtonCommand>();
        }
        return list2;
    }

    public CMIGuiButton setName(String string) {
        if (this.item == null) {
            return this;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(CMIChatColor.translate(string));
            this.item.setItemMeta(itemMeta);
        }
        return this;
    }

    public CMIGuiButton addLore(List<String> list2) {
        list2 = this.spreadList(list2);
        for (String string : list2) {
            this.addLore(string);
        }
        return this;
    }

    public List<String> spreadList(List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < list2.size()) {
            if (list2.get(n).contains(" \\n")) {
                arrayList.addAll(Arrays.asList(list2.get(n).split(" \\\\n")));
            } else if (list2.get(n).contains(" \n")) {
                arrayList.addAll(Arrays.asList(list2.get(n).split(" \\n")));
            } else {
                arrayList.add(list2.get(n));
            }
            ++n;
        }
        return arrayList;
    }

    public CMIGuiButton addLore(String string) {
        if (this.item == null) {
            return this;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta != null) {
            ArrayList<String> arrayList = itemMeta.getLore();
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            if (string.contains("\\n")) {
                String[] stringArray;
                String[] stringArray2 = stringArray = string.split("\\\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    arrayList.add(CMIChatColor.translate(string2));
                    ++n2;
                }
            } else if (string.contains("\n")) {
                String[] stringArray;
                String[] stringArray3 = stringArray = string.split("\\n");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String string3 = stringArray3[n3];
                    arrayList.add(CMIChatColor.translate(string3));
                    ++n3;
                }
            } else {
                arrayList.add(CMIChatColor.translate(string));
            }
            itemMeta.setLore(arrayList);
            this.item.setItemMeta(itemMeta);
        }
        return this;
    }

    public CMIGuiButton clearLore() {
        if (this.item == null) {
            return this;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setLore(new ArrayList());
            this.item.setItemMeta(itemMeta);
        }
        return this;
    }

    public CMIGuiButton addItemName(String string) {
        if (this.item == null) {
            return this;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setDisplayName(CMIChatColor.translate(string));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public CMIGuiButton addCommand(String string) {
        return this.addCommand(null, string);
    }

    public CMIGuiButton addCommand(String string, CommandType commandType) {
        return this.addCommand(null, string, commandType);
    }

    public CMIGuiButton addCommand(GUIManager.GUIClickType gUIClickType, String string) {
        return this.addCommand(gUIClickType, string, CommandType.gui);
    }

    public CMIGuiButton addCommand(GUIManager.GUIClickType gUIClickType, String string, CommandType commandType) {
        if (gUIClickType == null) {
            GUIManager.GUIClickType[] gUIClickTypeArray = GUIManager.GUIClickType.values();
            int n = gUIClickTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GUIManager.GUIClickType gUIClickType2 = gUIClickTypeArray[n2];
                List<GUIButtonCommand> list2 = this.commandMap.get((Object)gUIClickType2);
                if (list2 == null) {
                    list2 = new ArrayList<GUIButtonCommand>();
                }
                list2.add(new GUIButtonCommand(string, commandType));
                this.commandMap.put(gUIClickType2, list2);
                ++n2;
            }
        } else {
            List<GUIButtonCommand> list3 = this.commandMap.get((Object)gUIClickType);
            if (list3 == null) {
                list3 = new ArrayList<GUIButtonCommand>();
            }
            list3.add(new GUIButtonCommand(string, commandType));
            this.commandMap.put(gUIClickType, list3);
        }
        return this;
    }

    public void click() {
    }

    public void click(GUIManager.GUIClickType gUIClickType) {
    }

    public CMIGuiButton addCommand(Location location) {
        if (location == null) {
            return this;
        }
        this.addCommand("cmi tppos " + location.getWorld().getName() + " " + location.getX() + " " + location.getY() + " " + location.getBlockZ() + " " + location.getPitch() + " " + location.getYaw());
        return this;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getItem(Player player) {
        if (this.item != null) {
            ItemMeta itemMeta;
            ItemStack itemStack = this.item.clone();
            if (this.isLocked()) {
                itemStack = CMIReflections.setNbt(itemStack, "CMIGUIIcon", "LIProtection");
            }
            ItemMeta itemMeta2 = itemMeta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : null;
            if (itemMeta != null) {
                itemStack.setItemMeta(itemMeta);
            }
            return itemStack;
        }
        return this.item;
    }

    public CMIGuiButton setItem(ItemStack itemStack) {
        this.item = itemStack == null ? null : itemStack.clone();
        return this;
    }

    public void setCommandMap(HashMap<GUIManager.GUIClickType, List<GUIButtonCommand>> hashMap) {
        this.commandMap = hashMap;
    }

    public boolean isCloseInv() {
        return this.closeInv;
    }

    public void setCloseInv(boolean bl) {
        this.closeInv = bl;
    }

    public CMIGui getGui() {
        return this.sgui;
    }

    public int getTicks() {
        return this.ticks;
    }
}

