/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGuiButton;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CMIGui {
    private InventoryType invType;
    private GUIManager.GUIRows gUIRows;
    private Player player;
    private Inventory inv;
    private String title;
    private HashMap<Integer, CMIGuiButton> buttons = new HashMap();
    private LinkedHashSet<CMIGuiButton> noSlotButtons = new LinkedHashSet();
    private HashMap<GUIManager.InvType, GUIManager.GUIFieldType> lock = new HashMap();
    private HashMap<GUIManager.InvType, String> permLock = new HashMap();
    private GUIManager.CmiInventoryType type = GUIManager.CmiInventoryType.regular;
    private Object whatShows;
    private Object tempData;
    private boolean allowShift = false;
    private boolean allowPickUpAll = false;

    public CMIGui(Player player) {
        this.player = player;
    }

    public CMIGui clone() {
        CMIGui cMIGui = new CMIGui(this.player);
        cMIGui.setInvSize(this.gUIRows);
        cMIGui.setButtons(this.buttons);
        cMIGui.setInv(this.inv);
        cMIGui.setInvType(this.invType);
        cMIGui.setTitle(this.title);
        cMIGui.setCmiInventoryType(this.type);
        cMIGui.setWhatShows(this.whatShows);
        return cMIGui;
    }

    public boolean isOpened() {
        return GUIManager.isOpenedGui(this.getPlayer());
    }

    public boolean isSimilar(CMIGui cMIGui) {
        if (this.getInvSize() != cMIGui.getInvSize()) {
            return false;
        }
        return this.getInvType() == cMIGui.getInvType();
    }

    public CMIGui open() {
        GUIManager.openGui(this);
        return this;
    }

    public void outsideClick(GUIManager.GUIClickType gUIClickType) {
    }

    public InventoryType getInvType() {
        if (this.invType == null) {
            this.invType = InventoryType.CHEST;
        }
        return this.invType;
    }

    public void setInvType(InventoryType inventoryType) {
        this.invType = inventoryType;
    }

    public GUIManager.GUIRows getInvSize() {
        if (this.gUIRows == null) {
            this.autoResize();
        }
        return this.gUIRows;
    }

    public void setInvSize(GUIManager.GUIRows gUIRows) {
        this.gUIRows = gUIRows;
    }

    public void setInvSize(int n) {
        this.gUIRows = GUIManager.GUIRows.getByRows(n);
    }

    public void autoResize() {
        this.combineButtons();
        int n = 0;
        for (Map.Entry<Integer, CMIGuiButton> entry : this.buttons.entrySet()) {
            if (entry.getKey() <= n) continue;
            n = entry.getKey();
        }
        this.gUIRows = n < 9 ? GUIManager.GUIRows.r1 : (n < 18 ? GUIManager.GUIRows.r2 : (n < 27 ? GUIManager.GUIRows.r3 : (n < 36 ? GUIManager.GUIRows.r4 : (n < 45 ? GUIManager.GUIRows.r5 : GUIManager.GUIRows.r6))));
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Inventory getInv() {
        if (this.inv == null) {
            GUIManager.generateInventory(this);
        }
        return this.inv;
    }

    public void setInv(Inventory inventory) {
        this.inv = inventory;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = "";
        }
        return CMIChatColor.translate(this.title);
    }

    public void updateTitle(String string) {
        this.setTitle(string);
        CMIReflections.updateInventoryTitle(this.player, this.title);
    }

    public void setTitle(String string) {
        if (string.length() > 32) {
            string = String.valueOf(string.substring(0, 31)) + "~";
        }
        this.title = string;
    }

    public HashMap<Integer, CMIGuiButton> getButtons() {
        this.combineButtons();
        return this.buttons;
    }

    public void clearButtons() {
        for (Map.Entry<Integer, CMIGuiButton> entry : this.getButtons().entrySet()) {
            this.inv.setItem(entry.getKey().intValue(), null);
        }
        if (this.inv != null) {
            this.inv.clear();
        }
        this.buttons.clear();
        this.noSlotButtons.clear();
    }

    public CMIGui replaceButton(CMIGuiButton cMIGuiButton) {
        cMIGuiButton.updateLooks();
        if (cMIGuiButton.getSlot() != null) {
            this.buttons.remove(cMIGuiButton.getSlot());
        }
        if (this.getInv() != null) {
            this.getInv().setItem(cMIGuiButton.getSlot().intValue(), cMIGuiButton.getItem(this.getPlayer()));
        }
        return this.addButton(cMIGuiButton, 54);
    }

    public CMIGui addButton(CMIGuiButton cMIGuiButton) {
        cMIGuiButton.updateLooks();
        return this.addButton(cMIGuiButton, 54);
    }

    public CMIGui addButton(CMIGuiButton cMIGuiButton, int n) {
        cMIGuiButton.setGui(this);
        if (cMIGuiButton.getSlot() != null && this.buttons.get(cMIGuiButton.getSlot()) != null) {
            int n2 = cMIGuiButton.getSlot();
            while (n2 < n) {
                CMIGuiButton cMIGuiButton2 = this.buttons.get(n2);
                if (cMIGuiButton2 == null) {
                    this.buttons.put(n2, cMIGuiButton);
                    break;
                }
                ++n2;
            }
            return this;
        }
        if (cMIGuiButton.getSlot() == null) {
            this.noSlotButtons.add(cMIGuiButton);
            return this;
        }
        this.buttons.put(cMIGuiButton.getSlot(), cMIGuiButton);
        return this;
    }

    private void combineButtons() {
        block0: for (CMIGuiButton cMIGuiButton : this.noSlotButtons) {
            int n = 0;
            while (n < 54) {
                CMIGuiButton cMIGuiButton2 = this.buttons.get(n);
                if (cMIGuiButton2 == null) {
                    this.buttons.put(n, cMIGuiButton);
                    continue block0;
                }
                ++n;
            }
        }
        this.noSlotButtons.clear();
    }

    public void fillEmptyButtons() {
        this.fillEmptyButtons(null);
    }

    public void fillEmptyButtons(ItemStack itemStack) {
        this.combineButtons();
        int n = 0;
        while (n < this.getInvSize().getFields()) {
            if (!this.buttons.containsKey(n)) {
                this.addEmptyButton(itemStack, n);
            }
            ++n;
        }
    }

    public void updateButton(CMIGuiButton cMIGuiButton) {
        if (this.inv == null || cMIGuiButton.getSlot() == null || this.inv.getSize() < cMIGuiButton.getSlot()) {
            return;
        }
        this.inv.setItem(cMIGuiButton.getSlot().intValue(), cMIGuiButton.getItem(this.getPlayer()));
        this.buttons.put(cMIGuiButton.getSlot(), cMIGuiButton);
    }

    public void addEmptyButton(int n) {
        this.addEmptyButton(null, n);
    }

    public void addEmptyButton(ItemStack itemStack, int n) {
        ItemStack itemStack2 = itemStack == null ? CMIMaterial.BLACK_STAINED_GLASS_PANE.newItemStack() : itemStack.clone();
        ItemMeta itemMeta = itemStack2.getItemMeta();
        itemMeta.setDisplayName(" ");
        itemStack2.setItemMeta(itemMeta);
        CMIGuiButton cMIGuiButton = new CMIGuiButton((Integer)n, GUIManager.GUIFieldType.Locked, itemStack2);
        this.addButton(cMIGuiButton);
        this.updateButton(cMIGuiButton);
    }

    public void setButtons(HashMap<Integer, CMIGuiButton> hashMap) {
        this.buttons = hashMap;
    }

    public boolean isLocked(GUIManager.InvType invType) {
        return this.lock.containsKey((Object)invType) ? this.lock.get((Object)invType) == GUIManager.GUIFieldType.Locked : false;
    }

    public void addLock(GUIManager.InvType invType) {
        this.addLock(invType, GUIManager.GUIFieldType.Locked);
    }

    public void addLock(GUIManager.InvType invType, GUIManager.GUIFieldType gUIFieldType) {
        this.lock.put(invType, gUIFieldType);
    }

    public boolean isPermLocked(GUIManager.InvType invType) {
        return this.permLock.containsKey((Object)invType) ? !this.player.hasPermission(this.permLock.get((Object)invType)) : true;
    }

    public void addPermLock(GUIManager.InvType invType, String string) {
        this.permLock.put(invType, string);
    }

    public GUIManager.CmiInventoryType getType() {
        return this.type;
    }

    public void setCmiInventoryType(GUIManager.CmiInventoryType cmiInventoryType) {
        this.type = cmiInventoryType;
    }

    public Object getWhatShows() {
        return this.whatShows;
    }

    public void setWhatShows(Object object) {
        this.whatShows = object;
    }

    public Integer getSlot(GUIManager.GUIButtonLocation gUIButtonLocation) {
        GUIManager.GUIRows gUIRows = this.getInvSize();
        int n = gUIButtonLocation.getCollumn() * 9;
        n = gUIButtonLocation.getCollumn() > 0 ? n - 1 : n;
        Integer n2 = gUIButtonLocation.getRow() * gUIRows.getRows() * 9 - 8 + n;
        n2 = gUIButtonLocation.getRow() > 0 ? n2 : n2 + 9;
        return n2 - 1;
    }

    public void onClose() {
    }

    public void onOpen() {
    }

    public void processClose() {
    }

    public boolean isAllowShift() {
        return this.allowShift;
    }

    public void setAllowShift(boolean bl) {
        this.allowShift = bl;
    }

    public Object getTempData() {
        return this.tempData;
    }

    public void setTempData(Object object) {
        this.tempData = object;
    }

    public boolean isAllowPickUpAll() {
        return this.allowPickUpAll;
    }

    public void setAllowPickUpAll(boolean bl) {
        this.allowPickUpAll = bl;
    }
}

