/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.enchantments;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Translatable;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Enchantment
implements Keyed,
Translatable {
    public static final Enchantment PROTECTION_ENVIRONMENTAL = Enchantment.getEnchantment("protection");
    public static final Enchantment PROTECTION_FIRE = Enchantment.getEnchantment("fire_protection");
    public static final Enchantment PROTECTION_FALL = Enchantment.getEnchantment("feather_falling");
    public static final Enchantment PROTECTION_EXPLOSIONS = Enchantment.getEnchantment("blast_protection");
    public static final Enchantment PROTECTION_PROJECTILE = Enchantment.getEnchantment("projectile_protection");
    public static final Enchantment OXYGEN = Enchantment.getEnchantment("respiration");
    public static final Enchantment WATER_WORKER = Enchantment.getEnchantment("aqua_affinity");
    public static final Enchantment THORNS = Enchantment.getEnchantment("thorns");
    public static final Enchantment DEPTH_STRIDER = Enchantment.getEnchantment("depth_strider");
    public static final Enchantment FROST_WALKER = Enchantment.getEnchantment("frost_walker");
    public static final Enchantment BINDING_CURSE = Enchantment.getEnchantment("binding_curse");
    public static final Enchantment DAMAGE_ALL = Enchantment.getEnchantment("sharpness");
    public static final Enchantment DAMAGE_UNDEAD = Enchantment.getEnchantment("smite");
    public static final Enchantment DAMAGE_ARTHROPODS = Enchantment.getEnchantment("bane_of_arthropods");
    public static final Enchantment KNOCKBACK = Enchantment.getEnchantment("knockback");
    public static final Enchantment FIRE_ASPECT = Enchantment.getEnchantment("fire_aspect");
    public static final Enchantment LOOT_BONUS_MOBS = Enchantment.getEnchantment("looting");
    public static final Enchantment SWEEPING_EDGE = Enchantment.getEnchantment("sweeping");
    public static final Enchantment DIG_SPEED = Enchantment.getEnchantment("efficiency");
    public static final Enchantment SILK_TOUCH = Enchantment.getEnchantment("silk_touch");
    public static final Enchantment DURABILITY = Enchantment.getEnchantment("unbreaking");
    public static final Enchantment LOOT_BONUS_BLOCKS = Enchantment.getEnchantment("fortune");
    public static final Enchantment ARROW_DAMAGE = Enchantment.getEnchantment("power");
    public static final Enchantment ARROW_KNOCKBACK = Enchantment.getEnchantment("punch");
    public static final Enchantment ARROW_FIRE = Enchantment.getEnchantment("flame");
    public static final Enchantment ARROW_INFINITE = Enchantment.getEnchantment("infinity");
    public static final Enchantment LUCK = Enchantment.getEnchantment("luck_of_the_sea");
    public static final Enchantment LURE = Enchantment.getEnchantment("lure");
    public static final Enchantment LOYALTY = Enchantment.getEnchantment("loyalty");
    public static final Enchantment IMPALING = Enchantment.getEnchantment("impaling");
    public static final Enchantment RIPTIDE = Enchantment.getEnchantment("riptide");
    public static final Enchantment CHANNELING = Enchantment.getEnchantment("channeling");
    public static final Enchantment MULTISHOT = Enchantment.getEnchantment("multishot");
    public static final Enchantment QUICK_CHARGE = Enchantment.getEnchantment("quick_charge");
    public static final Enchantment PIERCING = Enchantment.getEnchantment("piercing");
    public static final Enchantment MENDING = Enchantment.getEnchantment("mending");
    public static final Enchantment VANISHING_CURSE = Enchantment.getEnchantment("vanishing_curse");
    public static final Enchantment SOUL_SPEED = Enchantment.getEnchantment("soul_speed");
    public static final Enchantment SWIFT_SNEAK = Enchantment.getEnchantment("swift_sneak");

    @NotNull
    private static Enchantment getEnchantment(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        Enchantment enchantment = Registry.ENCHANTMENT.get(namespacedKey);
        Preconditions.checkNotNull((Object)enchantment, (String)"No Enchantment found for %s. This is a bug.", (Object)namespacedKey);
        return enchantment;
    }

    @Deprecated
    @NotNull
    public abstract String getName();

    public abstract int getMaxLevel();

    public abstract int getStartLevel();

    @NotNull
    public abstract EnchantmentTarget getItemTarget();

    public abstract boolean isTreasure();

    @Deprecated
    public abstract boolean isCursed();

    public abstract boolean conflictsWith(@NotNull Enchantment var1);

    public abstract boolean canEnchantItem(@NotNull ItemStack var1);

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static Enchantment getByKey(@Nullable NamespacedKey key) {
        if (key == null) {
            return null;
        }
        return Registry.ENCHANTMENT.get(key);
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static Enchantment getByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        name = Enchantment.convertLegacy(name);
        return Enchantment.getByKey(NamespacedKey.fromString(name.toLowerCase()));
    }

    @Deprecated
    @NotNull
    public static Enchantment[] values() {
        return Lists.newArrayList(Registry.ENCHANTMENT).toArray(new Enchantment[0]);
    }

    private static String convertLegacy(String from) {
        if (from == null) {
            return null;
        }
        switch (from.toLowerCase()) {
            case "protection_environmental": {
                return "protection";
            }
            case "protection_fire": {
                return "fire_protection";
            }
            case "protection_fall": {
                return "feather_falling";
            }
            case "protection_explosions": {
                return "blast_protection";
            }
            case "protection_projectile": {
                return "projectile_protection";
            }
            case "oxygen": {
                return "respiration";
            }
            case "water_worker": {
                return "aqua_affinity";
            }
            case "damage_all": {
                return "sharpness";
            }
            case "damage_undead": {
                return "smite";
            }
            case "damage_arthropods": {
                return "bane_of_arthropods";
            }
            case "loot_bonus_mobs": {
                return "looting";
            }
            case "sweeping_edge": {
                return "sweeping";
            }
            case "dig_speed": {
                return "efficiency";
            }
            case "durability": {
                return "unbreaking";
            }
            case "loot_bonus_blocks": {
                return "fortune";
            }
            case "arrow_damage": {
                return "power";
            }
            case "arrow_knockback": {
                return "punch";
            }
            case "arrow_fire": {
                return "flame";
            }
            case "arrow_infinite": {
                return "infinity";
            }
            case "luck": {
                return "luck_of_the_sea";
            }
        }
        return from;
    }
}

