/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R4.virtual;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;

public abstract class VirtualEntity<T extends PacketEntity<?>>
extends PacketEntityRenderer<T> {
    public VirtualEntity(T wrapper) {
        super(wrapper);
    }

    @Override
    public Collection<Object> getSpawnPackets(AbstractPlayer target) {
        PacketPlayOutSpawnEntity packetSpawn = this.createSpawnPacket();
        PacketPlayOutEntityMetadata packetData = this.createDataPacket(target, true);
        return Lists.newArrayList((Object[])new Object[]{packetSpawn, packetData});
    }

    @Override
    public void sendPacket(AbstractPlayer player, Collection<Object> packets) {
        Schedulers.ensureAsync(() -> {
            if (packets.size() > 1) {
                ArrayList packetsToSend = Lists.newArrayList();
                for (Object object : packets) {
                    if (object == null || !(object instanceof Packet)) continue;
                    Packet packet = (Packet)object;
                    packetsToSend.add(packet);
                }
                ClientboundBundlePacket bundle = new ClientboundBundlePacket((Iterable)packetsToSend);
                ((CraftPlayer)player.getBukkitEntity()).getHandle().c.b((Packet)bundle);
            } else {
                for (Object object : packets) {
                    if (object == null || !(object instanceof Packet)) continue;
                    Packet packet = (Packet)object;
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().c.b(packet);
                }
            }
        });
    }

    @Override
    public void sendPacket(AbstractPlayer player, Object ... packets) {
        Schedulers.ensureAsync(() -> {
            if (packets.length > 1) {
                ArrayList packetsToSend = Lists.newArrayList();
                for (Object object : packets) {
                    if (object == null || !(object instanceof Packet)) continue;
                    Packet packet = (Packet)object;
                    packetsToSend.add(packet);
                }
                ClientboundBundlePacket bundle = new ClientboundBundlePacket((Iterable)packetsToSend);
                ((CraftPlayer)player.getBukkitEntity()).getHandle().c.b((Packet)bundle);
            } else {
                for (Object object : packets) {
                    if (object == null || !(object instanceof Packet)) continue;
                    Packet packet = (Packet)object;
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().c.b(packet);
                }
            }
        });
    }

    @Override
    public void sendPacket(Object ... packets) {
        Schedulers.ensureAsync(() -> {
            if (packets.length > 1) {
                ArrayList packetsToSend = Lists.newArrayList();
                for (Object object : packets) {
                    if (object == null || !(object instanceof Packet)) continue;
                    Packet packet = (Packet)object;
                    packetsToSend.add(packet);
                }
                ClientboundBundlePacket bundle = new ClientboundBundlePacket((Iterable)packetsToSend);
                for (Map.Entry entry : this.trackedPlayers.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    ((CraftPlayer)((AbstractPlayer)entry.getKey()).getBukkitEntity()).getHandle().c.b((Packet)bundle);
                }
            } else {
                for (Object object : packets) {
                    if (object == null || !(object instanceof Packet)) continue;
                    Packet packet = (Packet)object;
                    for (Map.Entry entry : this.trackedPlayers.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        ((CraftPlayer)((AbstractPlayer)entry.getKey()).getBukkitEntity()).getHandle().c.b(packet);
                    }
                }
            }
        });
    }

    protected abstract PacketPlayOutSpawnEntity createSpawnPacket();

    protected PacketPlayOutSpawnEntity createSpawnPacket(EntityTypes entityType) {
        AbstractLocation location = ((PacketEntity)this.getWrapper()).getLocation().get();
        return new PacketPlayOutSpawnEntity(this.getEntityId(), this.getUniqueId(), location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, entityType, 0, Vec3D.b, 0.0);
    }

    protected abstract PacketPlayOutEntityMetadata createDataPacket(boolean var1);

    protected PacketPlayOutEntityMetadata createDataPacket(AbstractPlayer player, boolean force) {
        return this.createDataPacket(force);
    }

    protected PacketPlayOutEntityDestroy createRemovePacket() {
        return new PacketPlayOutEntityDestroy(new int[]{this.entityId});
    }

    protected PacketPlayOutEntityVelocity createVelocityPacket(double x, double y, double z) {
        return new PacketPlayOutEntityVelocity(this.entityId, new Vec3D(x, y, z));
    }

    protected PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z, float yaw, float pitch) {
        PacketDataSerializer pos = new PacketDataSerializer(Unpooled.buffer());
        pos.c(this.entityId);
        pos.a(x);
        pos.a(y);
        pos.a(z);
        pos.k((int)((byte)(yaw / 360.0f * 255.0f)));
        pos.k(0);
        pos.a(false);
        return (PacketPlayOutEntityTeleport)PacketPlayOutEntityTeleport.a.decode((Object)pos);
    }

    protected PacketPlayOutMount createMountPacket(int vehicleId) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.c(vehicleId);
        mount.c(1);
        mount.c(this.entityId);
        return (PacketPlayOutMount)PacketPlayOutMount.a.decode((Object)mount);
    }

    protected PacketPlayOutMount createPassengerPacket(int passengerId) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.c(this.entityId);
        mount.c(1);
        mount.c(passengerId);
        return (PacketPlayOutMount)PacketPlayOutMount.a.decode((Object)mount);
    }

    protected PacketPlayOutMount createPassengerPacket(Set<Entity> passengers) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.c(this.entityId);
        mount.c(passengers.size());
        for (Entity ent : passengers) {
            mount.c(ent.al());
        }
        return (PacketPlayOutMount)PacketPlayOutMount.a.decode((Object)mount);
    }

    public static <T> void writeData(List<DataWatcher.c<?>> packetData, int id, DataWatcherSerializer<T> serializer, T val) {
        DataWatcher.c data = new DataWatcher.c(id, serializer, val);
        packetData.add(data);
    }
}

