/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R4.packets;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicRemoveEntityPacket;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.glow.GlowData;
import io.lumine.mythic.core.glow.GlowManager;
import io.lumine.mythic.core.volatilecode.v1_20_R4.VolatilePacketHandlerImpl;
import io.lumine.mythic.core.volatilecode.v1_20_R4.packets.PacketInterceptor;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VolatileChannelHandler
extends ChannelDuplexHandler {
    private final VolatilePacketHandlerImpl manager;
    private final Player player;
    private final EntityPlayer serverPlayer;
    private final PacketInterceptor writeInterceptors;
    private final PacketInterceptor readInterceptors;

    public VolatileChannelHandler(VolatilePacketHandlerImpl manager, Player player) {
        this.manager = manager;
        this.player = player;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.writeInterceptors = new PacketInterceptor().register(PacketPlayOutMount.class, this::handlePassengerPacket).register(PacketPlayOutEntityMetadata.class, this::handleEntityDataPacket).registerPost(PacketPlayOutEntityDestroy.class, packet -> {
            if (MythicBukkit.inst().isEnabled()) {
                packet.b().forEach(id -> Events.callSync(new MythicRemoveEntityPacket(id)));
            }
        });
        this.readInterceptors = new PacketInterceptor();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof Packet)) {
            super.write(ctx, (Object)msg, promise);
            return;
        }
        Packet packet = (Packet)msg;
        try {
            if (packet instanceof ClientboundBundlePacket) {
                ClientboundBundlePacket bundle = (ClientboundBundlePacket)packet;
                ArrayList list = new ArrayList();
                for (Packet subPacket : bundle.b()) {
                    Packet result = this.writeInterceptors.accept(subPacket);
                    if (result == null) continue;
                    list.add(result);
                    this.writeInterceptors.acceptPost(packet);
                }
                msg = new ClientboundBundlePacket(list);
                super.write(ctx, (Object)msg, promise);
            } else {
                msg = this.writeInterceptors.accept(packet);
                if (msg == null) {
                    return;
                }
                super.write(ctx, msg, promise);
                this.writeInterceptors.acceptPost(packet);
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (!(msg instanceof Packet)) {
            super.channelRead(ctx, (Object)msg);
            return;
        }
        Packet packet = msg;
        msg = this.readInterceptors.accept(packet);
        if (msg == null) {
            return;
        }
        super.channelRead(ctx, msg);
        this.readInterceptors.acceptPost(packet);
    }

    private PacketPlayOutMount handlePassengerPacket(PacketPlayOutMount packet) {
        int vehicleId = packet.e();
        Collection<Integer> additions = MythicBukkit.inst().getHologramManager().getAttachedHolograms(vehicleId);
        if (additions == null) {
            return packet;
        }
        int[] oldPassengers = packet.b();
        List passengerList = Arrays.stream(oldPassengers).boxed().collect(Collectors.toList());
        passengerList.addAll(additions);
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.c(vehicleId);
        mount.c(passengerList.size());
        for (Integer i : passengerList) {
            mount.c(i.intValue());
        }
        return (PacketPlayOutMount)PacketPlayOutMount.a.decode((Object)mount);
    }

    private PacketPlayOutEntityMetadata handleEntityDataPacket(PacketPlayOutEntityMetadata packet) {
        boolean currentGlowValue;
        GlowManager glowManager = MythicBukkit.inst().getGlowManager();
        GlowData glowData = glowManager.getGlowData(packet.b());
        if (glowData == null) {
            return packet;
        }
        DataWatcher.c data = (DataWatcher.c)packet.e().getFirst();
        if (data.a() != 0) {
            return packet;
        }
        byte dataValue = (Byte)data.c();
        boolean internalGlowValue = (dataValue & 0x40) == 64;
        if (internalGlowValue == (currentGlowValue = glowData.data().containsKey(this.player.getUniqueId()))) {
            return packet;
        }
        byte newValue = (byte)(currentGlowValue ? dataValue | 0x40 : dataValue & 0xFFFFFFBF);
        packet.e().set(0, DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(0, DataWatcherRegistry.a), (Object)newValue));
        return packet;
    }
}

