/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R4;

import com.google.common.collect.Maps;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileItemHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.gson.GsonProvider;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.volatilecode.v1_20_R4.VolatileCompoundTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class VolatileItemHandlerImpl
implements VolatileItemHandler {
    private final Reflector<CraftItemStack> refItemStack = new Reflector<CraftItemStack>(CraftItemStack.class, "handle");

    public VolatileItemHandlerImpl(VolatileCodeHandler handler) {
    }

    private net.minecraft.world.item.ItemStack getNMSItemStack(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack;
        if (itemStack instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)itemStack;
            nmsItemStack = (net.minecraft.world.item.ItemStack)this.refItemStack.get(craftItemStack, "handle");
        } else {
            nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        }
        return nmsItemStack;
    }

    @Override
    public void destroyItem(ItemStack itemStack) {
        CraftItemStack craftItemStack;
        net.minecraft.world.item.ItemStack realStack;
        if (itemStack instanceof CraftItemStack && (realStack = (net.minecraft.world.item.ItemStack)this.refItemStack.get(craftItemStack = (CraftItemStack)itemStack, "handle")) != null) {
            realStack.e(0);
        }
    }

    @Override
    public ItemStack addNBTData(ItemStack itemStack, String key, Tag value) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.getNMSItemStack(itemStack);
        Object nbt = this.getNBTData(itemStack).builder(builder -> builder.put(key, value)).getValue();
        NBTTagCompound volatileNbt = new VolatileCompoundTag((Map<String, Tag>)nbt).toNMSTag();
        nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)volatileNbt));
        if (itemStack instanceof CraftItemStack) {
            return itemStack;
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public CompoundTag getNBTData(ItemStack itemStack) {
        CustomData customDataComponent;
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && (customDataComponent = (CustomData)nmsItemStack.a(DataComponents.b)) != null && !customDataComponent.b()) {
            return VolatileCompoundTag.fromNMSTag(customDataComponent.c());
        }
        return new VolatileCompoundTag(new HashMap<String, Tag>());
    }

    @Override
    public ItemStack setNBTData(ItemStack itemStack, CompoundTag compoundTag) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.getNMSItemStack(itemStack);
        nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)((VolatileCompoundTag)compoundTag).toNMSTag()));
        if (itemStack instanceof CraftItemStack) {
            return itemStack;
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack setNBTData(ItemStack itemStack, CompoundTag compoundTag, PlaceholderMeta meta) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.getNMSItemStack(itemStack);
        nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)((VolatileCompoundTag)compoundTag).toNMSTag(meta)));
        if (itemStack instanceof CraftItemStack) {
            return itemStack;
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public String serializeItem(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        return "";
    }

    @Override
    public Map<String, Object> getComponentData(ItemStack bukkitItemStack) {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)bukkitItemStack);
        TextComponent.Builder visualOutput = Component.text();
        StringBuilder itemCommandBuilder = new StringBuilder();
        Set<DataComponentType> referencedComponentTypes = Collections.newSetFromMap(new IdentityHashMap());
        DataComponentPatch patch = itemStack.d();
        referencedComponentTypes.addAll(patch.b().stream().map(Map.Entry::getKey).toList());
        DataComponentMap prototype = itemStack.g().p();
        referencedComponentTypes.addAll(prototype.b());
        IRegistryCustom.Dimension access = MinecraftServer.getServer().bc();
        RegistryOps ops = access.a((DynamicOps)JsonOps.INSTANCE);
        IRegistry registry = access.d(Registries.av);
        ArrayList componentComponents = new ArrayList();
        ArrayList commandComponents = new ArrayList();
        ConcurrentMap ret = Maps.newConcurrentMap();
        for (DataComponentType type : referencedComponentTypes) {
            Object bbb;
            Codec aaa;
            String path = ((ResourceKey)registry.d((Object)type).orElseThrow()).a().a();
            Optional patchedValue = patch.a(type);
            TypedDataComponent prototypeValue = prototype.c(type);
            if (patchedValue != null) {
                if (patchedValue.isEmpty()) continue;
                aaa = type.c();
                bbb = aaa.encodeStart((DynamicOps)ops, patchedValue.get());
                Object ccc = bbb.getOrThrow();
                ret.put(path, ccc);
                continue;
            }
            if (prototypeValue == null) continue;
            aaa = prototypeValue.a((DynamicOps)ops);
            bbb = aaa.getOrThrow();
            ret.put(path, bbb);
        }
        return ret;
    }

    @Override
    public String dumpComponentData(ItemStack bukkitItemStack) {
        return GsonProvider.standard().toJson((Object)this.getNBTData(bukkitItemStack));
    }

    @Override
    public String dumpNBTData(ItemStack itemStack) {
        CustomData customDataComponent;
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && (customDataComponent = (CustomData)nmsItemStack.a(DataComponents.b)) != null && !customDataComponent.b()) {
            return customDataComponent.d().toString();
        }
        return "";
    }

    @Override
    public int spawnFakeItem(Player player, ItemStack itemStack, AbstractLocation location) {
        EntityItem item = new EntityItem((World)((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle(), location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        item.a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity((Entity)item);
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(item.al(), item.ap().c());
        Schedulers.async().run(() -> {
            ((CraftPlayer)player).getHandle().c.b((Packet)spawnItem);
            ((CraftPlayer)player).getHandle().c.b((Packet)data);
        });
        return item.al();
    }

    @Override
    public void collectFakeItem(Player player, int id) {
        int playerID = ((CraftPlayer)player).getHandle().al();
        PacketPlayOutCollect spawnItem = new PacketPlayOutCollect(id, playerID, 1);
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().c.b((Packet)spawnItem));
    }

    public void updateFakeItem(Player player, int id, ItemStack itemStack, AbstractLocation location) {
        EntityItem item = new EntityItem((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        item.a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(item.al(), item.ap().c());
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().c.b((Packet)data));
    }

    @Override
    public void destroyFakeItem(Player player, int id) {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{id});
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().c.b((Packet)destroyPacket));
    }

    public void playTotemEffect(AbstractPlayer player, int modelId) {
    }

    @Override
    public float getItemRecharge(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.D(0.0f);
    }

    @Override
    public boolean getItemRecharging(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.D(0.0f) < 1.0f;
    }

    @Override
    public void resetItemRecharge(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        ep.gw();
    }

    @Override
    public void setTridentItem(Trident entity, ItemStack item) {
        ((CraftTrident)entity).setItem(item);
    }

    @Override
    public ItemStack setDisplayName(ItemStack itemStack, Component displayName) {
        IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(displayName)), (HolderLookup.a)CraftRegistry.getMinecraftRegistry());
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        nms.b(DataComponents.h, (Object)component);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
    }

    @Override
    public ItemStack setLore(ItemStack itemStack, Collection<Component> lore) {
        List<IChatBaseComponent> components = lore.stream().map(line -> IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(line)), (HolderLookup.a)CraftRegistry.getMinecraftRegistry())).toList();
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        nms.b(DataComponents.i, (Object)new ItemLore(components));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
    }

    @Override
    public ItemStack setSkinData(ItemStack itemStack, @Nullable String playerName, @Nullable UUID playerUuid, @Nullable String textureData, @Nullable String textureUrl) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        PropertyMap properties = new PropertyMap();
        if (playerName != null) {
            nms.b(DataComponents.V, (Object)new ResolvableProfile(Optional.of(playerName), Optional.ofNullable(playerUuid), properties));
        } else if (textureData != null || textureUrl != null) {
            properties.put((Object)"textures", (Object)new Property("textures", Objects.requireNonNullElseGet(textureData, () -> Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + textureUrl + "\"}}}")))));
            nms.b(DataComponents.V, (Object)new ResolvableProfile(Optional.empty(), Optional.empty(), properties));
        } else {
            throw new IllegalArgumentException("cannot set skin data with none of player name, texture data, or texture URL non-null.");
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
    }

    @Override
    public ItemStack setCanPlaceOn(ItemStack itemStack, Collection<Material> materials) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        nms.b(DataComponents.l, (Object)new AdventureModePredicate(List.of(CriterionConditionBlock.a.a().a(materials.stream().map(it -> (Block)((IRegistry)CraftRegistry.getMinecraftRegistry().c(Registries.f).orElseThrow()).a(new MinecraftKey(it.getKey().toString()))).toList()).b()), false));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
    }

    @Override
    public ItemStack setCanBreak(ItemStack itemStack, Collection<Material> materials) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        nms.b(DataComponents.m, (Object)new AdventureModePredicate(List.of(CriterionConditionBlock.a.a().a(materials.stream().map(it -> (Block)((IRegistry)CraftRegistry.getMinecraftRegistry().c(Registries.f).orElseThrow()).a(new MinecraftKey(it.getKey().toString()))).toList()).b()), false));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
    }
}

