/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random.generators;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.lib.math3.ml.clustering.DBSCANClusterer;
import io.lumine.mythic.bukkit.utils.lib.math3.ml.clustering.DoublePoint;
import io.lumine.mythic.core.spawning.random.PlayerGroup;
import io.lumine.mythic.core.spawning.random.RandomSpawnGenerator;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.SpawnCategory;

public class ClusterGenerator
extends RandomSpawnGenerator {
    public ClusterGenerator(RandomSpawnerManager manager) {
        super(manager);
    }

    @Override
    public void tick() {
        for (AbstractWorld world : this.getPlugin().getBootstrap().getWorlds()) {
            Map<SpawnPointType, List<RandomSpawner>> worldSpawners;
            if (world.getPlayers().isEmpty() || (worldSpawners = this.getManager().getRandomSpawnersAdd().get(world.getName())) == null) continue;
            List<PlayerGroup> playerGroups = this.getPlayerGroups(world);
            MythicSpawnState spawnState = this.getPlugin().getVolatileCodeHandler().getSpawningHandler().getSpawnState(world);
            if (spawnState.getMonsterCount() > this.getManager().getMythicMobCap(spawnState)) continue;
            Collections.shuffle(playerGroups);
            block1: for (PlayerGroup playerGroup : playerGroups) {
                RandomSpawnPoint spawnLocation;
                Map<SpawnCategory, Integer> mobTypeCounts = playerGroup.getLocalMobCounts();
                Integer localMonsterCount = mobTypeCounts.getOrDefault(SpawnCategory.MONSTER, 0);
                double localMobCap = (double)spawnState.getMaxMobsPerPlayer() * this.getPlugin().getConfiguration().getRandomSpawningLimitMultiplier();
                if (playerGroup.getPlayers().size() > 1) {
                    localMobCap += (double)(playerGroup.getPlayers().size() - 1) * (localMobCap * this.getPlugin().getConfiguration().getRandomSpawningGroupMultiplier());
                }
                if ((double)localMonsterCount.intValue() > localMobCap || (spawnLocation = playerGroup.getRandomSpawnablePoint()) == null) continue;
                for (RandomSpawner spawner : worldSpawners.getOrDefault((Object)spawnLocation.getPointType(), Collections.emptyList())) {
                    if (!spawner.checkSpawn(spawnLocation)) continue;
                    Schedulers.sync().run(() -> spawner.spawn(spawnLocation));
                    continue block1;
                }
            }
        }
    }

    private List<PlayerGroup> getPlayerGroups(AbstractWorld world) {
        double groupingRadius = this.getPlugin().getConfiguration().getRandomSpawningGroupDistance();
        List points = world.getPlayers().stream().map(e -> new DoublePoint(new double[]{e.getLocation().getX(), e.getLocation().getZ()})).collect(Collectors.toList());
        DBSCANClusterer clusterer = new DBSCANClusterer(groupingRadius, 0);
        ArrayList<PlayerGroup> clusters = new ArrayList<PlayerGroup>();
        clusterer.cluster(points).forEach(cluster -> {
            List<AbstractPlayer> clusterEntities = cluster.getPoints().stream().map(dp -> world.getPlayers().get(points.indexOf(dp))).collect(Collectors.toList());
            clusters.add(new PlayerGroup(this.getManager(), world, clusterEntities));
        });
        return clusters;
    }
}

