/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.cooldown.Cooldown;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.WorldScaling;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawnerAction;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawner {
    public static Set<RandomSpawnPoint> spawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MythicBukkit plugin;
    private final RandomSpawnerManager manager;
    private String name;
    private List<MythicMob> mobTypes = Lists.newArrayList();
    private RandomSpawnerAction action;
    private int priority;
    private int level;
    private float chance;
    private Cooldown cooldown;
    private Collection<AbstractBiome> biomes = Sets.newConcurrentHashSet();
    private Collection<AbstractWorld> worlds = Lists.newArrayList();
    private Collection<String> worldNames = Lists.newArrayList();
    private Collection<CreatureSpawnEvent.SpawnReason> spawnReasons = Lists.newArrayList();
    private List<SkillCondition> conditions;
    private SpawnPointType positionType = SpawnPointType.LAND;
    private boolean hasConditions = false;
    private boolean useWorldScaling = true;

    public RandomSpawner(RandomSpawnerManager manager, String file, String name, MythicConfig mc) {
        int n;
        Object ns;
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.name = name;
        String strAction = mc.getString("SpawnMethod", "ADD");
        strAction = mc.getString("Action", strAction);
        this.action = RandomSpawnerAction.valueOf(strAction.toUpperCase());
        String strMobName = mc.getString("Mobname", "");
        strMobName = mc.getString("MobName", strMobName);
        strMobName = mc.getString("MobType", strMobName);
        strMobName = mc.getString("Type", strMobName);
        strMobName = mc.getString("Types", strMobName);
        if (!strMobName.equalsIgnoreCase("GROUP")) {
            String[] types;
            for (String s2 : types = strMobName.split(",")) {
                this.getPlugin().getMobManager().getMythicMob(s2).ifPresent(mm4 -> this.mobTypes.add((MythicMob)mm4));
            }
        }
        this.level = mc.getInteger("Level", 1);
        this.chance = (float)mc.getDouble("Chance", 1.0);
        this.priority = mc.getInteger("Priority", 1);
        this.useWorldScaling = mc.getBoolean("UseWorldScaling", true);
        int cooldown = mc.getInteger("Cooldown", 0);
        if (cooldown > 0) {
            this.cooldown = Cooldown.of(cooldown, TimeUnit.SECONDS);
        }
        String strPositionType = "LAND";
        try {
            strPositionType = mc.getString("PositionType", "LAND");
            this.positionType = SpawnPointType.valueOf(strPositionType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorSpawnConfig(this, mc, "'" + strPositionType + "' is not a valid value for PositionType");
            this.positionType = SpawnPointType.LAND;
        }
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            SkillCondition sc;
            if (s2.contains("\"")) {
                String[] split = s2.split("\"");
                int i = 0;
                ns = "";
                String[] stringArray = split;
                n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String ss = stringArray[j];
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList<SkillCondition>();
            }
            this.conditions.add(sc);
        }
        if (this.conditions != null && this.conditions.size() > 0) {
            this.hasConditions = true;
        }
        String world = mc.getString("Worlds");
        String reasons = mc.getString("Reason");
        reasons = mc.getString("Reasons", reasons);
        if (world != null) {
            String[] worldName = world.split(",");
            World w = null;
            if (worldName != null) {
                ns = worldName;
                int n2 = ((String[])ns).length;
                for (n = 0; n < n2; ++n) {
                    String wName = ns[n];
                    this.worldNames.add(wName);
                    w = Bukkit.getWorld((String)wName);
                    if (w == null) continue;
                    this.worlds.add(BukkitAdapter.adapt(w));
                }
            }
        }
        ArrayList biomes = null;
        if (mc.isSet("Biomes")) {
            biomes = mc.isList("Biomes") ? mc.getStringList("Biomes") : Lists.newArrayList((Object[])mc.getString("Biomes").split(","));
        } else if (mc.isSet("Biome")) {
            biomes = Lists.newArrayList((Object[])new String[]{mc.getString("Biome")});
        }
        if (biomes != null) {
            for (String biomeName : biomes) {
                try {
                    Collection<AbstractBiome> maybeBiomes = this.getPlugin().getBootstrap().getBiomes(biomeName);
                    this.biomes.addAll(maybeBiomes);
                }
                catch (Error | Exception ex) {
                    MythicLogger.errorSpawnConfig(this, mc, "Biome '" + biomeName + "' not found");
                    ex.printStackTrace();
                }
            }
        }
        if (reasons != null) {
            String[] r;
            for (String rr : r = reasons.split(",")) {
                CreatureSpawnEvent.SpawnReason fr = CreatureSpawnEvent.SpawnReason.valueOf((String)rr);
                if (fr == null) continue;
                this.spawnReasons.add(fr);
            }
        }
    }

    public float getChance() {
        return this.chance;
    }

    public int getLevel(AbstractLocation location) {
        int level = this.getBaseLevel();
        if (this.useWorldScaling) {
            level = (int)((double)level + WorldScaling.getLevelBonus(location));
        }
        return level;
    }

    public int getBaseLevel() {
        return this.level;
    }

    public Collection<CreatureSpawnEvent.SpawnReason> getReasons() {
        return this.spawnReasons;
    }

    public boolean isValid() {
        return !this.mobTypes.isEmpty();
    }

    public boolean hasConditions() {
        return this.hasConditions;
    }

    public boolean checkSpawn(RandomSpawnPoint rsp) {
        if (this.cooldown != null && !this.cooldown.testSilently()) {
            return false;
        }
        if ((double)this.chance < Numbers.randomDouble()) {
            return false;
        }
        if (!this.spawnReasons.isEmpty()) {
            if (!this.spawnReasons.contains(rsp.getReason())) {
                return false;
            }
        } else {
            switch (rsp.getReason()) {
                case NATURAL: {
                    break;
                }
                case REINFORCEMENTS: {
                    break;
                }
                case VILLAGE_INVASION: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.worlds != null && !this.worlds.isEmpty() && !this.worlds.contains(rsp.getLocation().getWorld())) {
            return false;
        }
        if (!this.biomes.isEmpty() && !this.biomes.contains(rsp.getBiome())) {
            return false;
        }
        if (this.hasConditions()) {
            for (SkillCondition condition : this.conditions) {
                if (condition.evaluateRandomSpawnPoint(rsp)) continue;
                return false;
            }
        }
        if (this.cooldown != null) {
            this.cooldown.test();
        }
        return true;
    }

    public ActiveMob spawn(RandomSpawnPoint rsp) {
        if (this.mobTypes.isEmpty()) {
            return null;
        }
        MythicMob mm4 = this.mobTypes.size() > 1 ? this.mobTypes.get(Numbers.randomInt(this.mobTypes.size())) : this.mobTypes.get(0);
        return MythicBukkit.inst().getMobManager().spawnMob(mm4.getInternalName(), rsp.getLocation(), SpawnReason.NATURAL, (float)this.getLevel(rsp.getLocation()) * rsp.getLevelMod());
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public RandomSpawnerManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public RandomSpawnerAction getAction() {
        return this.action;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getLevel() {
        return this.level;
    }

    public Collection<AbstractBiome> getBiomes() {
        return this.biomes;
    }

    public Collection<AbstractWorld> getWorlds() {
        return this.worlds;
    }

    public Collection<String> getWorldNames() {
        return this.worldNames;
    }

    public Collection<CreatureSpawnEvent.SpawnReason> getSpawnReasons() {
        return this.spawnReasons;
    }

    public List<SkillCondition> getConditions() {
        return this.conditions;
    }

    public SpawnPointType getPositionType() {
        return this.positionType;
    }
}

