/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;

public class PlayerGroup {
    private final RandomSpawnerManager manager;
    private final AbstractWorld world;
    private final List<AbstractPlayer> players;
    private final Collection<Chunk> localChunks = Sets.newConcurrentHashSet();

    public PlayerGroup(RandomSpawnerManager manager, AbstractWorld world, List<AbstractPlayer> clusterEntities) {
        this.manager = manager;
        this.players = clusterEntities;
        this.world = world;
        int spawnRadiusMax = ((MythicBukkit)this.getManager().getPlugin()).getConfiguration().getRandomSpawningPlayerRadiusMax();
        int chunkRadius = spawnRadiusMax / 16;
        World bukkitWorld = BukkitAdapter.adapt(world);
        for (AbstractPlayer player : this.players) {
            Location playerLocation = BukkitAdapter.adapt(player.getLocation());
            int chunkX = playerLocation.getChunk().getX();
            int chunkZ = playerLocation.getChunk().getZ();
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                    Chunk chunk = bukkitWorld.getChunkAt(dx + chunkX, dz + chunkZ, false);
                    this.localChunks.add(chunk);
                }
            }
        }
    }

    public Map<SpawnCategory, Integer> getLocalMobCounts() {
        ConcurrentMap ret = Maps.newConcurrentMap();
        for (Chunk chunk : this.localChunks) {
            for (Entity entity : chunk.getEntities()) {
                ret.compute(entity.getSpawnCategory(), (k, v) -> v == null ? 1 : v + 1);
            }
        }
        return ret;
    }

    public RandomSpawnPoint getRandomSpawnablePoint() {
        RandomSpawnPoint point;
        block17: {
            SpawnPointType type;
            int ny;
            Location spawnLocation;
            int spawnRadiusMax = ((MythicBukkit)this.getManager().getPlugin()).getConfiguration().getRandomSpawningPlayerRadiusMax();
            int spawnRadiusMaxSq = Numbers.floor(Math.pow(spawnRadiusMax, 2.0));
            int spawnRadiusMinSq = Numbers.floor(Math.pow(((MythicBukkit)this.getManager().getPlugin()).getConfiguration().getRandomSpawningPlayerRadiusMin(), 2.0));
            int spawnRadiusY = ((MythicBukkit)this.getManager().getPlugin()).getConfiguration().getRandomSpawningPlayerRadiusY();
            block0: while (true) {
                AbstractPlayer player = this.players.get(Numbers.randomInt(this.players.size()));
                AbstractWorld world = player.getWorld();
                Location location = BukkitAdapter.adapt(player.getLocation());
                int nx = (int)(location.getX() - (double)spawnRadiusMax) + Numbers.randomInt(spawnRadiusMax * 2);
                int nz = (int)(location.getZ() - (double)spawnRadiusMax) + Numbers.randomInt(spawnRadiusMax * 2);
                spawnLocation = new Location(location.getWorld(), (double)nx, 0.0, (double)nz);
                if (!world.isChunkLoaded(spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Skipping player, area chunks not loaded.", new Object[0]);
                    continue;
                }
                Chunk spawnChunk = spawnLocation.getWorld().getChunkAt(spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4);
                ChunkSnapshot chunkSnapshot = spawnChunk.getChunkSnapshot(true, false, false);
                ny = (int)(location.getY() - (double)spawnRadiusY) + Numbers.randomInt(spawnRadiusY * 2);
                int maxHeight = chunkSnapshot.getHighestBlockYAt(Math.abs(nx % 16), Math.abs(nz % 16)) + 1;
                int minHeight = spawnLocation.getWorld().getMinHeight() + 1;
                if (ny < minHeight) {
                    ny = minHeight;
                } else if (ny > maxHeight) {
                    ny = maxHeight;
                }
                spawnLocation.setY((double)ny);
                for (AbstractPlayer clusterPlayer : this.players) {
                    Location playerLocation = BukkitAdapter.adapt(clusterPlayer.getLocation());
                    if (!spawnLocation.getWorld().equals((Object)playerLocation.getWorld()) || !(spawnLocation.distanceSquared(playerLocation) < (double)spawnRadiusMinSq)) continue;
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Too close to player, skipping", new Object[0]);
                    continue block0;
                }
                BlockData spawnBlock = chunkSnapshot.getBlockData(Math.abs(spawnLocation.getBlockX() % 16), spawnLocation.getBlockY(), Math.abs(spawnLocation.getBlockZ() % 16));
                if (spawnBlock.getMaterial() == Material.LAVA || spawnBlock.getMaterial() == Material.WATER) {
                    if (spawnBlock.getMaterial() == Material.LAVA) {
                        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Found lava. Adding Lava point", new Object[0]);
                        point = new RandomSpawnPoint(BukkitAdapter.adapt(spawnLocation).center(), SpawnPointType.LAVA);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Found water. Adding Sea point", new Object[0]);
                        point = new RandomSpawnPoint(BukkitAdapter.adapt(spawnLocation).center(), SpawnPointType.SEA);
                    }
                    break block17;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Adding Land point", new Object[0]);
                type = null;
                if (!spawnBlock.getMaterial().isSolid()) {
                    for (int j = 0; j < spawnRadiusY * 2 && ny - 1 >= minHeight && ny <= maxHeight; ++j) {
                        spawnLocation.setY((double)(--ny));
                        spawnBlock = chunkSnapshot.getBlockData(Math.abs(spawnLocation.getBlockX() % 16), spawnLocation.getBlockY(), Math.abs(spawnLocation.getBlockZ() % 16));
                        if (spawnBlock.getMaterial() == Material.WATER) {
                            type = SpawnPointType.SEA;
                            break;
                        }
                        if (spawnBlock.getMaterial() == Material.LAVA) {
                            type = SpawnPointType.LAVA;
                            break;
                        }
                        if (!spawnBlock.getMaterial().isSolid()) continue;
                        type = SpawnPointType.LAND;
                        break;
                    }
                    if (type == null) {
                        continue;
                    }
                } else {
                    type = SpawnPointType.LAND;
                }
                if (type == SpawnPointType.LAND) {
                    for (int k = 1; k < 3; ++k) {
                        spawnLocation.setY(spawnLocation.getY() + 1.0);
                        spawnBlock = chunkSnapshot.getBlockData(Math.abs(spawnLocation.getBlockX() % 16), spawnLocation.getBlockY(), Math.abs(spawnLocation.getBlockZ() % 16));
                        if (!spawnBlock.getMaterial().isSolid()) continue;
                        type = null;
                        break;
                    }
                }
                if (type != null) break;
                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Couldn't find land position this time", new Object[0]);
            }
            spawnLocation.setY((double)ny);
            point = type == SpawnPointType.LAND ? new RandomSpawnPoint(BukkitAdapter.adapt(spawnLocation).center().add(0.0, 0.5, 0.0), type) : new RandomSpawnPoint(BukkitAdapter.adapt(spawnLocation).center().subtract(0.0, 0.5, 0.0), type);
        }
        return point;
    }

    public RandomSpawnerManager getManager() {
        return this.manager;
    }

    public AbstractWorld getWorld() {
        return this.world;
    }

    public List<AbstractPlayer> getPlayers() {
        return this.players;
    }

    public Collection<Chunk> getLocalChunks() {
        return this.localChunks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerGroup)) {
            return false;
        }
        PlayerGroup other = (PlayerGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RandomSpawnerManager this$manager = this.getManager();
        RandomSpawnerManager other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !this$manager.equals(other$manager)) {
            return false;
        }
        AbstractWorld this$world = this.getWorld();
        AbstractWorld other$world = other.getWorld();
        if (this$world == null ? other$world != null : !((Object)this$world).equals(other$world)) {
            return false;
        }
        List<AbstractPlayer> this$players = this.getPlayers();
        List<AbstractPlayer> other$players = other.getPlayers();
        if (this$players == null ? other$players != null : !((Object)this$players).equals(other$players)) {
            return false;
        }
        Collection<Chunk> this$localChunks = this.getLocalChunks();
        Collection<Chunk> other$localChunks = other.getLocalChunks();
        return !(this$localChunks == null ? other$localChunks != null : !((Object)this$localChunks).equals(other$localChunks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RandomSpawnerManager $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
        AbstractWorld $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        List<AbstractPlayer> $players = this.getPlayers();
        result = result * 59 + ($players == null ? 43 : ((Object)$players).hashCode());
        Collection<Chunk> $localChunks = this.getLocalChunks();
        result = result * 59 + ($localChunks == null ? 43 : ((Object)$localChunks).hashCode());
        return result;
    }

    public String toString() {
        return "PlayerGroup(manager=" + String.valueOf(this.getManager()) + ", world=" + String.valueOf(this.getWorld()) + ", players=" + String.valueOf(this.getPlayers()) + ", localChunks=" + String.valueOf(this.getLocalChunks()) + ")";
    }
}

