/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.triggers.meta;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import java.util.Map;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamagedMetadata
extends SkillTriggerMetadata {
    private final EntityDamageEvent event;
    private final AbstractEntity damaged;
    private double damage;
    private Map<String, Double> bonusDamage;
    private String damageCause;
    private String element;

    public DamagedMetadata(EntityDamageEvent event, AbstractEntity damaged) {
        this.event = event;
        this.damaged = damaged;
        this.damage = event.getDamage();
        this.bonusDamage = Maps.newHashMap();
        this.element = this.damageCause = event.getCause().toString();
    }

    public double getFinalDamage() {
        return this.damage;
    }

    public String getDamageType() {
        return this.element;
    }

    @Override
    public void applyToSkillMetadata(SkillMetadata skillMetadata) {
        AbstractEntity damaged = BukkitAdapter.adapt(this.event.getEntity());
        skillMetadata.getVariables().putFloat("damage-amount", (float)this.damage);
        skillMetadata.getVariables().putString("damage-cause", this.event.getCause().toString());
    }

    public EntityDamageEvent getEvent() {
        return this.event;
    }

    public AbstractEntity getDamaged() {
        return this.damaged;
    }

    public double getDamage() {
        return this.damage;
    }

    public Map<String, Double> getBonusDamage() {
        return this.bonusDamage;
    }

    public String getDamageCause() {
        return this.damageCause;
    }

    public String getElement() {
        return this.element;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public void setBonusDamage(Map<String, Double> bonusDamage) {
        this.bonusDamage = bonusDamage;
    }

    public void setDamageCause(String damageCause) {
        this.damageCause = damageCause;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DamagedMetadata)) {
            return false;
        }
        DamagedMetadata other = (DamagedMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDamage(), other.getDamage()) != 0) {
            return false;
        }
        EntityDamageEvent this$event = this.getEvent();
        EntityDamageEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        AbstractEntity this$damaged = this.getDamaged();
        AbstractEntity other$damaged = other.getDamaged();
        if (this$damaged == null ? other$damaged != null : !this$damaged.equals(other$damaged)) {
            return false;
        }
        Map<String, Double> this$bonusDamage = this.getBonusDamage();
        Map<String, Double> other$bonusDamage = other.getBonusDamage();
        if (this$bonusDamage == null ? other$bonusDamage != null : !((Object)this$bonusDamage).equals(other$bonusDamage)) {
            return false;
        }
        String this$damageCause = this.getDamageCause();
        String other$damageCause = other.getDamageCause();
        if (this$damageCause == null ? other$damageCause != null : !this$damageCause.equals(other$damageCause)) {
            return false;
        }
        String this$element = this.getElement();
        String other$element = other.getElement();
        return !(this$element == null ? other$element != null : !this$element.equals(other$element));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DamagedMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $damage = Double.doubleToLongBits(this.getDamage());
        result = result * 59 + (int)($damage >>> 32 ^ $damage);
        EntityDamageEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        AbstractEntity $damaged = this.getDamaged();
        result = result * 59 + ($damaged == null ? 43 : $damaged.hashCode());
        Map<String, Double> $bonusDamage = this.getBonusDamage();
        result = result * 59 + ($bonusDamage == null ? 43 : ((Object)$bonusDamage).hashCode());
        String $damageCause = this.getDamageCause();
        result = result * 59 + ($damageCause == null ? 43 : $damageCause.hashCode());
        String $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        return result;
    }

    public String toString() {
        return "DamagedMetadata(event=" + String.valueOf(this.getEvent()) + ", damaged=" + String.valueOf(this.getDamaged()) + ", damage=" + this.getDamage() + ", bonusDamage=" + String.valueOf(this.getBonusDamage()) + ", damageCause=" + this.getDamageCause() + ", element=" + this.getElement() + ")";
    }
}

