/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import java.util.ArrayList;
import java.util.Collection;

public class PlayersNearOriginTargeter
extends IEntitySelector {
    private double radius;

    public PlayersNearOriginTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        double range = Math.pow(this.radius, 2.0);
        for (AbstractPlayer player : data.getCaster().getEntity().getWorld().getPlayers()) {
            if (!data.getCaster().getLocation().getWorld().equals(player.getWorld()) || !(this.distanceSquared(data.getOrigin(), player) < range)) continue;
            targets.add(player);
        }
        return targets;
    }
}

