/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import java.util.Collection;
import java.util.HashSet;

public class PlayerLocationsInRadiusTargeter
extends ILocationSelector {
    double radius;
    double yOffset;

    public PlayerLocationsInRadiusTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getDouble("radius", 5.0);
        this.radius = mlc.getDouble("r", this.radius);
        this.yOffset = mlc.getDouble("yoffset", 0.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        for (AbstractPlayer p : am.getEntity().getWorld().getPlayers()) {
            if (!am.getLocation().getWorld().equals(p.getWorld()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            AbstractLocation l = p.getLocation();
            l.add(0.0, this.yOffset, 0.0);
            targets.add(l);
        }
        return targets;
    }
}

