/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@MythicTargeter(author="Ashijin", name="owner", aliases={}, description="Targets the caster's owner")
public class OwnerTargeter
extends IEntitySelector {
    public OwnerTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        UUID uuid;
        Player player;
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        if (!(data.getCaster() instanceof ActiveMob)) {
            return targets;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        if (am.getOwner().isPresent() && (player = Bukkit.getPlayer((UUID)(uuid = am.getOwner().get()))) != null) {
            targets.add(BukkitAdapter.adapt(player));
        }
        return targets;
    }
}

