/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import java.util.Collection;
import java.util.HashSet;

public class NearestPlayerTargeter
extends IEntitySelector {
    private double radius;

    public NearestPlayerTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        AbstractPlayer nearest = null;
        double distSqr = Math.pow(this.radius, 2.0);
        for (AbstractPlayer p : am.getEntity().getWorld().getPlayers()) {
            if (p.getUniqueId().equals(am.getEntity().getUniqueId()) || !p.getWorld().equals(am.getEntity().getWorld())) continue;
            if (nearest == null) {
                nearest = p;
                continue;
            }
            double d = this.distanceSquared(am.getEntity().getLocation(), p);
            if (!(d < distSqr)) continue;
            nearest = p;
            distSqr = d;
        }
        if (nearest != null) {
            targets.add(nearest);
        }
        return targets;
    }
}

