/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="livingNearTargetLocation", aliases={"LNTL", "ENTL", "ENT"}, description="Targets entities near the target location")
public class LivingNearTargetLocationTargeter
extends IEntitySelector {
    double radius;

    public LivingNearTargetLocationTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        block0: for (AbstractEntity p : data.getCaster().getEntity().getWorld().getLivingEntities()) {
            if (p.getUniqueId().equals(data.getCaster().getEntity().getUniqueId())) continue;
            for (AbstractLocation l : data.getLocationTargets()) {
                if (!(this.distanceSquared(l, p) < Math.pow(this.radius, 2.0))) continue;
                targets.add(p);
                continue block0;
            }
        }
        return targets;
    }
}

