/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.targeters.IEntityTargeter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.targeters.SelfTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Villager;
import org.bukkit.metadata.MetadataValue;

public abstract class IEntitySelector
extends SkillTargeter
implements IEntityTargeter {
    protected boolean targetSelf = ConfigExecutor.isTargetSelf();
    private boolean targetPlayers = ConfigExecutor.isTargetPlayers();
    private boolean targetArmorStands = ConfigExecutor.isTargetArmorStands();
    private boolean targetMarkers = ConfigExecutor.isTargetMarkers();
    private boolean targetCreativeMode = ConfigExecutor.isTargetCreativeMode();
    private boolean targetSpectatorMode = ConfigExecutor.isTargetSpectatorMode();
    private boolean targetCitizensNPCs = ConfigExecutor.isTargetCitizensNPCs();
    private boolean targetAnimals = ConfigExecutor.isTargetAnimals();
    private boolean targetCreatures = ConfigExecutor.isTargetCreatures();
    private boolean targetMonsters = ConfigExecutor.isTargetMonsters();
    private boolean targetGroundMobs = true;
    private boolean targetWaterMobs = ConfigExecutor.isTargetWaterMobs();
    private boolean targetFlyingMobs = ConfigExecutor.isTargetFlyingMobs();
    private boolean targetSameFaction = ConfigExecutor.isTargetSameFaction();
    private boolean targetOwner = ConfigExecutor.isTargetOwner();
    private boolean targetNonMythic = ConfigExecutor.isTargetNonMythic();
    private boolean targetVillagers = ConfigExecutor.isTargetVillagers();
    protected boolean useBoundingBox;
    protected PlaceholderInt unique;
    protected boolean filterMegHitbox;
    private PlaceholderInt limit;
    private FilterSorter sorter = FilterSorter.NONE;
    private List<String> ignoreTypes = null;

    public IEntitySelector(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        if (this instanceof SelfTargeter) {
            this.targetArmorStands = true;
        }
        this.limit = mlc.getPlaceholderInteger(new String[]{"limit"}, 0, new String[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Setting limit of the target to " + String.valueOf(this.limit), new Object[0]);
        String sort = mlc.getString(new String[]{"sort", "sortby"}, "NONE", new String[0]).toUpperCase();
        try {
            this.sorter = FilterSorter.valueOf(sort);
        }
        catch (Exception ex) {
            MythicLogger.errorTargeterConfig(this, mlc, "'" + sort + "' is not a valid sorter.");
        }
        if (this instanceof SelfTargeter) {
            this.targetSelf = true;
        }
        String target = mlc.getString("target", null);
        String ignore = mlc.getString("ignore", null);
        String ignoreTypes = mlc.getString("ignoretype", null);
        if (target != null) {
            if ((target = target.toLowerCase()).equalsIgnoreCase("ground")) {
                this.targetGroundMobs = true;
                this.targetWaterMobs = false;
                this.targetFlyingMobs = false;
            } else if (target.equalsIgnoreCase("water")) {
                this.targetGroundMobs = false;
                this.targetWaterMobs = true;
                this.targetFlyingMobs = false;
            } else if (target.equalsIgnoreCase("flying")) {
                this.targetGroundMobs = false;
                this.targetWaterMobs = false;
                this.targetFlyingMobs = true;
            } else {
                this.targetPlayers = false;
                this.targetArmorStands = false;
                this.targetMarkers = false;
                this.targetCreativeMode = false;
                this.targetSpectatorMode = false;
                this.targetCitizensNPCs = false;
                this.targetAnimals = false;
                this.targetCreatures = false;
                this.targetMonsters = false;
                this.targetVillagers = false;
                if (target.contains("self") || target.contains("caster")) {
                    this.targetSelf = true;
                }
                if (target.contains("player")) {
                    this.targetPlayers = true;
                }
                if (target.contains("creative")) {
                    this.targetCreativeMode = true;
                }
                if (target.contains("armorstand") || target.contains("armor_stand")) {
                    this.targetArmorStands = true;
                }
                if (target.contains("marker")) {
                    this.targetMarkers = true;
                }
                if (target.contains("spectator")) {
                    this.targetSpectatorMode = true;
                }
                if (target.contains("npc")) {
                    this.targetCitizensNPCs = true;
                }
                if (target.contains("flying")) {
                    this.targetMonsters = true;
                    this.targetCreatures = true;
                    this.targetFlyingMobs = true;
                }
                if (target.contains("animal")) {
                    this.targetAnimals = true;
                    this.targetCreatures = true;
                    this.targetWaterMobs = true;
                    this.targetFlyingMobs = true;
                }
                if (target.contains("monster")) {
                    this.targetMonsters = true;
                    this.targetCreatures = true;
                    this.targetWaterMobs = true;
                    this.targetFlyingMobs = true;
                }
                if (target.contains("creature")) {
                    this.targetCreatures = true;
                    this.targetWaterMobs = true;
                    this.targetFlyingMobs = true;
                }
                if (target.contains("villager")) {
                    this.targetVillagers = true;
                }
            }
        }
        if (ignore != null) {
            if ((ignore = ignore.toLowerCase()).contains("player")) {
                this.targetPlayers = false;
            }
            if (ignore.contains("creative")) {
                this.targetCreativeMode = false;
            }
            if (ignore.contains("armorstand") || ignore.contains("armor_stand")) {
                this.targetArmorStands = false;
            }
            if (ignore.contains("marker")) {
                this.targetMarkers = false;
            }
            if (ignore.contains("spectator")) {
                this.targetSpectatorMode = false;
            }
            if (ignore.contains("npc")) {
                this.targetCitizensNPCs = false;
            }
            if (ignore.contains("animal")) {
                this.targetAnimals = false;
            }
            if (ignore.contains("monster")) {
                this.targetMonsters = false;
            }
            if (ignore.contains("creature")) {
                this.targetCreatures = false;
            }
            if (ignore.contains("faction")) {
                this.targetSameFaction = false;
            }
            if (ignore.contains("vanilla")) {
                this.targetNonMythic = false;
            }
            if (ignore.contains("villager")) {
                this.targetVillagers = false;
            }
            if (ignore.contains("owner")) {
                this.targetOwner = false;
            }
        }
        if (ignoreTypes != null) {
            this.ignoreTypes = new ArrayList<String>();
            for (String s2 : ignoreTypes.split(",")) {
                this.ignoreTypes.add(s2);
            }
        }
        this.targetSelf = mlc.getBoolean("targetself", this.targetSelf);
        this.targetPlayers = mlc.getBoolean("targetplayers", this.targetPlayers);
        this.targetCreativeMode = mlc.getBoolean("targetcreative", this.targetCreativeMode);
        this.targetSpectatorMode = mlc.getBoolean("targetspectator", this.targetSpectatorMode);
        this.targetArmorStands = mlc.getBoolean("targetarmorstands", this.targetArmorStands);
        this.targetMarkers = mlc.getBoolean("targetmarkers", this.targetMarkers);
        this.targetCitizensNPCs = mlc.getBoolean("targetnpcs", this.targetCitizensNPCs);
        this.targetAnimals = mlc.getBoolean("targetanimals", this.targetAnimals);
        this.targetCreatures = mlc.getBoolean("targetcreatures", this.targetCreatures);
        this.targetSameFaction = mlc.getBoolean("targetsamefaction", this.targetSameFaction);
        this.targetOwner = mlc.getBoolean("targetowner", this.targetOwner);
        this.targetNonMythic = mlc.getBoolean(new String[]{"targetvanilla", "targetnonmythic"}, this.targetNonMythic);
        this.targetVillagers = mlc.getBoolean("targetvillagers", this.targetVillagers);
        this.useBoundingBox = mlc.getBoolean(new String[]{"bb", "useboundingbox"}, this.useBoundingBox);
        this.unique = mlc.getPlaceholderInteger(new String[]{"u", "unique"}, 1, new String[0]);
        this.filterMegHitbox = mlc.getBoolean(new String[]{"nomegbb", "nmb"}, false);
    }

    @Override
    public abstract Collection<AbstractEntity> getEntities(SkillMetadata var1);

    public void filter(SkillMetadata data, boolean targetCreative) {
        if (this.targetConditions != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying target conditions", new Object[0]);
            for (SkillCondition mc : this.targetConditions) {
                if (mc.evaluateTargets(data)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying entity target filters", new Object[0]);
        Collection targets = data.getEntityTargets();
        if (targets == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ No targets to filter?", new Object[0]);
            return;
        }
        int uniqueCount = this.unique.get(data);
        HashMap uniqueMap = uniqueCount > 0 ? new HashMap() : null;
        Optional<AbstractModelEngineSupport> megSupport = this.getPlugin().getCompatibility().getModelEngine();
        targets.removeIf(t2 -> {
            ActiveMob am;
            if (t2 == null) {
                return true;
            }
            if (megSupport.isPresent()) {
                if (this.filterMegHitbox && ((AbstractModelEngineSupport)megSupport.get()).isSubHitbox(t2.getUniqueId())) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering SUB_HITBOX", new Object[0]);
                    return true;
                }
                t2 = ((AbstractModelEngineSupport)megSupport.get()).getParent((AbstractEntity)t2);
            }
            if (uniqueMap != null) {
                int count = uniqueMap.getOrDefault(t2.getUniqueId(), 0);
                if (count >= uniqueCount) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering DUPLICATES", new Object[0]);
                    return true;
                }
                uniqueMap.put(t2.getUniqueId(), count + 1);
            }
            if (!this.targetSelf && !(this instanceof SelfTargeter) && t2.getUniqueId().equals(data.getCaster().getEntity().getUniqueId())) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering SELF", new Object[0]);
                return true;
            }
            if (!this.targetPlayers) {
                if (t2.isPlayer()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering PLAYER", new Object[0]);
                    return true;
                }
            } else {
                if ((!this.targetCreativeMode || !targetCreative) && t2.isPlayer() && t2.asPlayer().isInCreativeMode()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering CREATIVE", new Object[0]);
                    return true;
                }
                if ((!this.targetSpectatorMode || !targetCreative) && t2.isPlayer() && t2.asPlayer().isInSpectatorMode()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering SPECTATOR", new Object[0]);
                    return true;
                }
            }
            if (!this.targetArmorStands && t2.getBukkitEntity() instanceof ArmorStand) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering ARMOR_STAND", new Object[0]);
                return true;
            }
            if (!this.targetMarkers && ServerVersion.isAfterOrEq(MinecraftVersions.v1_17) && t2.getBukkitEntity() instanceof Marker) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering MARKER", new Object[0]);
                return true;
            }
            if (!this.targetWaterMobs && t2.isWaterMob()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering WATER MOB", new Object[0]);
                return true;
            }
            if (!this.targetFlyingMobs && t2.isFlyingMob()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering FLYING MOB", new Object[0]);
                return true;
            }
            if (!(this.targetGroundMobs || t2.isWaterMob() || t2.isFlyingMob())) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering GROUND MOB", new Object[0]);
                return true;
            }
            if (!this.targetAnimals && t2.isAnimal()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering ANIMAL", new Object[0]);
                return true;
            }
            if (!this.targetCreatures && t2.isCreature()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering CREATURE", new Object[0]);
                return true;
            }
            if (!this.targetMonsters && t2.isMonster()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering MONSTER", new Object[0]);
                return true;
            }
            if (!this.targetCitizensNPCs && t2.isLiving() && t2.getBukkitEntity().hasMetadata("NPC")) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering NPC", new Object[0]);
                return true;
            }
            if (!this.targetNonMythic && !MythicBukkit.inst().getMobManager().isActiveMob((AbstractEntity)t2)) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering NON-MYTHIC", new Object[0]);
                return true;
            }
            if (!this.targetSameFaction) {
                Optional<String> maybeFaction;
                ActiveMob activeMob;
                SkillCaster caster = data.getCaster();
                String casterFaction = caster instanceof ActiveMob ? ((activeMob = (ActiveMob)caster).getFaction() == null ? "" : activeMob.getFaction()) : (caster.getEntity().isPlayer() ? this.getPlugin().getPlayerManager().getFactionProvider().getFaction(caster.getEntity().asPlayer()).orElse("") : "");
                String targetFaction = t2.isPlayer() ? ((maybeFaction = this.getPlugin().getPlayerManager().getFactionProvider().getFaction(t2.asPlayer())).isPresent() ? maybeFaction.get() : "") : ((activeMob = this.getPlugin().getMobManager().getMythicMobInstance((AbstractEntity)t2)) != null ? (activeMob.getFaction() == null ? "" : activeMob.getFaction()) : (t2.getBukkitEntity().hasMetadata("Faction") ? ((MetadataValue)t2.getBukkitEntity().getMetadata("Faction").get(0)).asString() : ""));
                if (casterFaction.equals(targetFaction)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering SAMEFACTION", new Object[0]);
                    return true;
                }
            }
            if (!this.targetOwner && this.getPlugin().getMobManager().isActiveMob(data.getCaster().getEntity()) && (am = (ActiveMob)data.getCaster()).getOwner().isPresent() && am.getOwner().get().equals(t2.getUniqueId())) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering OWNER", new Object[0]);
                return true;
            }
            if (!this.targetVillagers && t2.getBukkitEntity() instanceof Villager) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering VILLAGERS", new Object[0]);
                return true;
            }
            return false;
        });
        int limit = this.limit.get(data);
        if (limit > 0) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Limit of " + limit + " being checked for with " + this.sorter.name() + " sort being applied.", new Object[0]);
            switch (this.sorter.ordinal()) {
                case 2: {
                    AbstractLocation origin = data.getOrigin();
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Sorting from nearest... thanks josh.", new Object[0]);
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared(o1.getLocation());
                        double d2 = origin.distanceSquared(o2.getLocation());
                        return Double.compare(d1, d2);
                    }).limit(limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case 3: {
                    AbstractLocation origin = data.getOrigin();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared(o1.getLocation());
                        double d2 = origin.distanceSquared(o2.getLocation());
                        return Double.compare(d2, d1);
                    }).limit(limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case 4: {
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = o1.getHealth();
                        double d2 = o2.getHealth();
                        return Double.compare(d2, d1);
                    }).limit(limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case 5: {
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = o1.getHealth();
                        double d2 = o2.getHealth();
                        return Double.compare(d1, d2);
                    }).limit(limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case 6: {
                    if (!(data.getCaster() instanceof ActiveMob) || !((ActiveMob)data.getCaster()).hasThreatTable()) {
                        MythicLogger.errorTargeterConfig(this, this.config, "Threat sorters can only be used with mobs that have ThreatTables enabled");
                    }
                    ActiveMob am = (ActiveMob)data.getCaster();
                    ActiveMob.ThreatTable tt = am.getThreatTable();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = tt.getThreat((AbstractEntity)o1);
                        double d2 = tt.getThreat((AbstractEntity)o2);
                        return Double.compare(d2, d1);
                    }).limit(limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case 7: {
                    if (!(data.getCaster() instanceof ActiveMob) || !((ActiveMob)data.getCaster()).hasThreatTable()) {
                        MythicLogger.errorTargeterConfig(this, this.config, "Threat sorters can only be used with mobs that have ThreatTables enabled");
                    }
                    ActiveMob am = (ActiveMob)data.getCaster();
                    ActiveMob.ThreatTable tt = am.getThreatTable();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = tt.getThreat((AbstractEntity)o1);
                        double d2 = tt.getThreat((AbstractEntity)o2);
                        return Double.compare(d1, d2);
                    }).limit(limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case 1: {
                    targets = targets.stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
                        Collections.shuffle(collected);
                        return collected.stream();
                    })).limit(limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                default: {
                    targets = targets.stream().limit(limit).collect(Collectors.toCollection(ArrayList::new));
                }
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Returning {0} targets", targets.size());
        data.setEntityTargets(targets);
    }

    protected double distanceSquared(AbstractLocation location, AbstractEntity entity) {
        return this.useBoundingBox ? location.distanceSquared(entity) : location.distanceSquared(entity.getLocation());
    }

    private static enum FilterSorter {
        NONE,
        RANDOM,
        NEAREST,
        FURTHEST,
        HIGHEST_HEALTH,
        LOWEST_HEALTH,
        HIGHEST_THREAT,
        LOWEST_THREAT;

    }
}

