/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.stats.StatExecution;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicStatChangeEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.EnumProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.stats.PercentModifyer;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public abstract class StatType
implements PropertyHolder,
Terminable,
TerminableConsumer {
    private static final BooleanProp ENABLED = Property.Boolean(Scope.STATS, "Enabled", false);
    private static final StringProp DISPLAY = Property.String(Scope.STATS, "Display", "");
    private static final EnumProp<StatExecution> EXECUTION_POINT = Property.Enum(Scope.STATS, StatExecution.class, "ExecutionPoint", StatExecution.NONE);
    private static final IntProp PRIORITY = Property.Int(Scope.STATS, "Priority", 0);
    private static final BooleanProp ALWAYS_ACTIVE = Property.Boolean(Scope.STATS, "AlwaysActive", false);
    private static final StringProp FORMULA = Property.String(Scope.STATS, "Formula", null);
    private static final StringProp FORMULA_KEY = Property.String(Scope.STATS, "FormulaKey", null);
    private static final DoubleProp BASE_VALUE = Property.Double(Scope.STATS, "BaseValue", 0.0);
    private static final DoubleProp MIN_VALUE = Property.Double(Scope.STATS, "MinValue", 0.0);
    private static final DoubleProp MAX_VALUE = Property.Double(Scope.STATS, "MaxValue", Double.MAX_VALUE);
    private static final StringListProp TRIGGERS = Property.StringList(Scope.STATS, "Triggers");
    private static final StringListProp PARENTS = Property.StringList(Scope.STATS, "ParentStats");
    private static final StringProp FORMATTING_ADDITIVE = Property.String(Scope.STATS, "Formatting.Additive", "+<value> <display>");
    private static final StringProp FORMATTING_MULTIPLY = Property.String(Scope.STATS, "Formatting.Multiply", "+<value>% <display>");
    private static final StringProp FORMATTING_COMPOUND = Property.String(Scope.STATS, "Formatting.Compound", "x<value>% <display>");
    private static final StringProp FORMATTING_SET = Property.String(Scope.STATS, "Formatting.Setter", "Force <value> <display>");
    private static final IntProp FORMATTING_ROUNDING = Property.Int(Scope.STATS, "Formatting.Rounding", 2);
    private static final StringListProp MECHANICS = Property.StringList(Scope.STATS, "Skills");
    private StatExecutor manager;
    private Object scope;
    private final TerminableRegistry registry = TerminableRegistry.create();
    private boolean enabled;
    private String key;
    private String formulaKey;
    protected StatExecution executionPoint = StatExecution.NONE;
    private int priority = 0;
    private boolean alwaysActive;
    private final Collection<SkillTrigger> applicableTriggers = Sets.newConcurrentHashSet();
    private final Collection<SkillMechanic> skills = Lists.newArrayList();
    private double baseValue = 0.0;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private String display;
    private PlaceholderString formattingAdditive;
    private PlaceholderString formattingMultiply;
    private PlaceholderString formattingCompound;
    private PlaceholderString formattingSet;
    private int formattingRounding;
    private Expression expression;
    private final Collection<StatType> parentStats = Sets.newConcurrentHashSet();
    private boolean initialized = false;

    public StatType(String key) {
        this(Scope.STATS, key);
    }

    public StatType(Object scope, String key) {
        this.key = key;
        this.scope = scope;
    }

    public void initialize(StatExecutor manager) {
        this.enabled = (Boolean)ENABLED.fget(this.scope, this);
        if (this.initialized || !this.enabled) {
            return;
        }
        this.manager = manager;
        this.minValue = (Double)MIN_VALUE.fget(this.scope, this);
        this.maxValue = (Double)MAX_VALUE.fget(this.scope, this);
        String formulaKey = (String)FORMULA_KEY.fget(this.scope, this);
        this.formulaKey = formulaKey == null ? this.key : formulaKey;
        this.priority = (Integer)PRIORITY.fget(this.scope, this);
        this.alwaysActive = (Boolean)ALWAYS_ACTIVE.fget(this.scope, this);
        this.display = (String)DISPLAY.fget(this.scope, this);
        this.formattingAdditive = PlaceholderString.of(((String)FORMATTING_ADDITIVE.fget(this.scope, this)).replace("<display>", this.display));
        this.formattingMultiply = PlaceholderString.of(((String)FORMATTING_MULTIPLY.fget(this.scope, this)).replace("<display>", this.display));
        this.formattingCompound = PlaceholderString.of(((String)FORMATTING_COMPOUND.fget(this.scope, this)).replace("<display>", this.display));
        this.formattingSet = PlaceholderString.of(((String)FORMATTING_SET.fget(this.scope, this)).replace("<display>", this.display));
        this.formattingRounding = (Integer)FORMATTING_ROUNDING.fget(this.scope, this);
        this.executionPoint = (StatExecution)((Object)EXECUTION_POINT.fget(this.scope, this));
        for (String in : (List)TRIGGERS.fget(this.scope, this)) {
            SkillTrigger trigger = SkillTrigger.get(in);
            if (trigger == null) continue;
            this.getApplicableTriggers().add(trigger);
        }
        List skills = (List)MECHANICS.fget(this.scope, this.key);
        if (!skills.isEmpty()) {
            MythicBukkit.inst().getSkillManager().queueSecondPass(() -> {
                for (String line : skills) {
                    SkillMechanic mechanic = MythicBukkit.inst().getSkillManager().getMechanic(line);
                    this.skills.add(mechanic);
                }
            });
        }
        List parents = (List)PARENTS.fget(this.scope, this);
        for (String parentKey : parents) {
            Optional<StatType> maybeStat = this.getManager().getStat(parentKey);
            if (maybeStat.isEmpty()) {
                MythicLogger.error("Invalid parent stat {0}", parentKey);
                return;
            }
            this.parentStats.add(maybeStat.get());
        }
        if (!this.parentStats.isEmpty()) {
            for (StatType parentStat : this.parentStats) {
                if (parentStat.isInitialized()) continue;
                parentStat.initialize(manager);
            }
            String formula = (String)FORMULA.fget(this.scope, this);
            if (formula != null) {
                try {
                    ExpressionBuilder builder = new ExpressionBuilder(formula).operator(Operators.operators).functions(Functions.functions);
                    for (StatType parentStat : this.parentStats) {
                        builder.variable(parentStat.getFormulaKey());
                    }
                    this.expression = builder.build();
                }
                catch (Exception ex) {
                    MythicLogger.error("X Invalid stat formula defined: " + formula);
                    ex.printStackTrace();
                    this.expression = new ExpressionBuilder("0").build();
                    return;
                }
            }
            Events.subscribe(MythicStatChangeEvent.class).handler(event -> {
                SkillCaster caster = event.getCaster();
                if (!this.parentStats.contains(event.getStat())) {
                    return;
                }
                StatRegistry stats = caster.getStatRegistry();
                if (stats != null) {
                    stats.putBaseValue(this, this.calculateFormulaicBaseValue(stats));
                }
            }).bindWith(this);
        } else {
            this.baseValue = (Double)BASE_VALUE.fget(this.scope, this);
        }
        this.load(manager);
        this.initialized = true;
    }

    protected void load(StatExecutor manager) {
    }

    public boolean isApplicable(AbstractEntity entity) {
        return true;
    }

    public StatRegistry getStatRegistry(AbstractEntity entity) {
        return MythicBukkit.inst().getStatManager().getStatRegistry(entity).orElse(null);
    }

    public double getStat(AbstractEntity entity) {
        Optional<StatRegistry> maybeRegistry = MythicBukkit.inst().getStatManager().getStatRegistry(entity);
        if (maybeRegistry.isEmpty()) {
            return 0.0;
        }
        return maybeRegistry.get().get(this);
    }

    public String getFormattedValue(StatModifierType operation, double value) {
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case StatModifierType.ADDITIVE -> {
                value = Numbers.round(value, this.formattingRounding);
                yield this.formattingAdditive.get().replace("<value>", this.getFormattedNumber(operation, value));
            }
            case StatModifierType.ADDITIVE_MULTIPLIER -> {
                value = Numbers.round(value, this.formattingRounding + 2);
                yield this.formattingMultiply.get().replace("<value>", this.getFormattedNumber(operation, value));
            }
            case StatModifierType.COMPOUND_MULTIPLIER -> {
                value = Numbers.round(value, this.formattingRounding + 2);
                yield this.formattingCompound.get().replace("<value>", this.getFormattedNumber(operation, value));
            }
            case StatModifierType.SETTER -> {
                value = Numbers.round(value, this.formattingRounding);
                yield this.formattingSet.get().replace("<value>", this.getFormattedNumber(operation, value));
            }
        };
    }

    private String getFormattedNumber(StatModifierType operation, double value) {
        NumberFormat percentFormat = NumberFormat.getPercentInstance(Locale.US);
        String ret = switch (operation) {
            default -> throw new MatchException(null, null);
            case StatModifierType.ADDITIVE -> {
                if (this instanceof PercentModifyer) {
                    yield percentFormat.format(value);
                }
                yield String.valueOf(value);
            }
            case StatModifierType.ADDITIVE_MULTIPLIER -> percentFormat.format(value);
            case StatModifierType.COMPOUND_MULTIPLIER -> percentFormat.format(value);
            case StatModifierType.SETTER -> String.valueOf(value);
        };
        return ret;
    }

    public String getTooltipLine(StatModifierType operation, double value) {
        return "";
    }

    public boolean isApplicable(SkillTrigger trigger) {
        return this.applicableTriggers.contains(trigger);
    }

    public void processTrigger(SkillMetadata skillMetadata, SkillTriggerMetadata triggerMetadata, StatRegistry statRegistry, double value) {
    }

    protected void runProcSkills(SkillMetadata skillMetadata, SkillTriggerMetadata triggerMetadata) {
        for (SkillMechanic skill : this.skills) {
            if (!skill.isUsableFromCaster(skillMetadata)) continue;
            skill.execute(skillMetadata);
        }
    }

    @Override
    public String getPropertyNode() {
        return this.key;
    }

    @Override
    public <T extends AutoCloseable> T bind(T binding) {
        this.registry.accept((Terminable)binding);
        return binding;
    }

    @Override
    public void close() throws Exception {
        this.applicableTriggers.clear();
        this.parentStats.clear();
        this.skills.clear();
        this.registry.terminate();
        this.initialized = false;
    }

    public double getBaseValue() {
        return this.getBaseValue(null);
    }

    public double getBaseValue(StatRegistry statRegistry) {
        if (this.parentStats.isEmpty()) {
            return this.baseValue;
        }
        return this.calculateFormulaicBaseValue(statRegistry);
    }

    private double calculateFormulaicBaseValue(StatRegistry statRegistry) {
        if (this.expression == null) {
            if (statRegistry == null) {
                return 0.0;
            }
            double val = 0.0;
            for (StatType parentStat : this.parentStats) {
                val += statRegistry.get(parentStat);
            }
            return val;
        }
        Expression expression = this.expression;
        if (statRegistry == null) {
            for (StatType parentStat : this.parentStats) {
                expression.setVariable(parentStat.getFormulaKey(), 0.0);
            }
        } else {
            for (StatType parentStat : this.parentStats) {
                expression.setVariable(parentStat.getFormulaKey(), statRegistry.get(parentStat));
            }
        }
        double val = expression.evaluate();
        return val;
    }

    public StatExecutor getManager() {
        return this.manager;
    }

    public Object getScope() {
        return this.scope;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getKey() {
        return this.key;
    }

    public String getFormulaKey() {
        return this.formulaKey;
    }

    public StatExecution getExecutionPoint() {
        return this.executionPoint;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isAlwaysActive() {
        return this.alwaysActive;
    }

    public Collection<SkillTrigger> getApplicableTriggers() {
        return this.applicableTriggers;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public String getDisplay() {
        return this.display;
    }

    public Collection<StatType> getParentStats() {
        return this.parentStats;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

