/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.stats.Stats;
import io.lumine.mythic.core.skills.stats.types.CompositeStat;
import io.lumine.mythic.core.skills.stats.types.DamageBonusStat;
import io.lumine.mythic.core.skills.stats.types.DamageModifierStat;
import io.lumine.mythic.core.skills.stats.types.ProcStat;
import io.lumine.mythic.core.skills.stats.types.StaticStat;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class StatExecutor
extends ReloadableModule<MythicBukkit> {
    private static final Map<String, Class<? extends StatType>> HARDCODED_STATS = new ConcurrentHashMap<String, Class<? extends StatType>>();
    private static final NodeListProp STATS = Property.NodeList(Scope.STATS, "");
    private static final StringProp STAT_TYPE = Property.String(Scope.STATS, "Type", "STATIC");
    private final Map<String, StatType> stats = Maps.newConcurrentMap();
    private final Collection<StatType> nonZeroBaseStats = Lists.newArrayList();
    private final Map<SkillTrigger, StatType> triggerModifyingStats = Maps.newConcurrentMap();

    public StatExecutor(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.registerPrimaryStat(Stats.DODGE_NEGATION);
        this.registerPrimaryStat(Stats.BONUS_DAMAGE);
        this.registerPrimaryStat(Stats.CRITICAL_STRIKE_CHANCE);
        this.registerPrimaryStat(Stats.CRITICAL_STRIKE_DAMAGE);
        this.registerPrimaryStat(Stats.CRITICAL_STRIKE_RESILIENCE);
        this.registerPrimaryStat(Stats.PARRY_NEGATION);
        this.registerPrimaryStat(Stats.PERCENT_DAMAGE);
        this.registerPrimaryStat(Stats.DAMAGE_REDUCTION);
        this.registerPrimaryStat(Stats.DEFENSE);
        this.registerPrimaryStat(Stats.DODGE_CHANCE);
        this.registerPrimaryStat(Stats.HEALTH_REGENERATION);
        this.registerPrimaryStat(Stats.LIFESTEAL_CHANCE);
        this.registerPrimaryStat(Stats.LIFESTEAL_POWER);
        this.registerPrimaryStat(Stats.PARRY_CHANCE);
        this.registerPrimaryStat(Stats.PARRY_POWER);
        this.registerPrimaryStat(Stats.ATTACK_DAMAGE);
        this.registerPrimaryStat(Stats.ATTACK_SPEED);
        this.registerPrimaryStat(Stats.HEALTH);
        this.registerPrimaryStat(Stats.MOVEMENT_SPEED);
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            File file = pack.getPackFile("stats.yml");
            if (!file.exists()) continue;
            for (String node : (Set)STATS.fget(file)) {
                this.registerStat(file, node);
            }
        }
        this.loadStats();
    }

    @Override
    public void unload() {
        for (StatType stat : this.stats.values()) {
            stat.terminate();
        }
        this.stats.clear();
        this.nonZeroBaseStats.clear();
    }

    private void registerPrimaryStat(StatType type) {
        if (this.stats.containsKey(type.getPropertyNode())) {
            return;
        }
        this.stats.put(type.getPropertyNode(), type);
    }

    private void registerStat(File file, String key) {
        if (this.stats.containsKey(key)) {
            return;
        }
        String type = (String)STAT_TYPE.fget((Object)file, key);
        StatType stat = null;
        switch (type.toUpperCase()) {
            case "COMPOSITE": {
                stat = new CompositeStat(file, key);
                break;
            }
            case "DAMAGE_MODIFIER": {
                stat = new DamageModifierStat(file, key);
                break;
            }
            case "DAMAGE_BONUS": {
                stat = new DamageBonusStat(file, key);
                break;
            }
            case "PROC": {
                stat = new ProcStat(file, key);
                break;
            }
            default: {
                stat = new StaticStat(file, key);
            }
        }
        if (stat != null) {
            this.stats.put(key, stat);
        }
    }

    private void loadStats() {
        this.stats.values().forEach(stat -> {
            stat.initialize(this);
            if (stat.getBaseValue() != 0.0 || stat.isAlwaysActive()) {
                this.nonZeroBaseStats.add((StatType)stat);
            }
        });
    }

    public Optional<StatType> getStat(String statName) {
        return Optional.ofNullable(this.stats.getOrDefault(statName, null));
    }

    public StatType getStatOrRegisterStatic(String statName) {
        return this.stats.compute(statName, (key, stat) -> stat == null ? new StaticStat((String)key) : stat);
    }

    public Optional<StatRegistry> getStatRegistry(AbstractEntity entity) {
        if (entity.isPlayer()) {
            PlayerData profile = ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer());
            if (profile == null) {
                return Optional.empty();
            }
            StatRegistry registry = profile.getStatRegistry();
            return Optional.of(registry);
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity);
        if (am == null) {
            return Optional.empty();
        }
        return Optional.of(am.getStatRegistry());
    }

    public Map<String, StatType> getStats() {
        return this.stats;
    }

    public Collection<StatType> getNonZeroBaseStats() {
        return this.nonZeroBaseStats;
    }
}

