/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.events.MythicProjectileHitEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public abstract class Projectile
extends SkillMechanic {
    public static final Set<AbstractEntity> BULLET_ENTITIES = ConcurrentHashMap.newKeySet();
    @MythicField(name="onTickSkill", aliases={"ontick", "ot"}, description="The meta-skill to execute every time the projectile is ticked")
    protected Optional<Skill> onTickSkill = Optional.empty();
    @MythicField(name="onHitSkill", aliases={"onhit", "oh"}, description="The meta-skill to execute when the projectile hits and entity")
    protected Optional<Skill> onHitSkill = Optional.empty();
    @MythicField(name="onBounceSkill", aliases={"onbounce", "ot"}, description="The meta-skill to execute when the projectile bounces", premium=true)
    protected Optional<Skill> onBounceSkill = Optional.empty();
    @MythicField(name="onEndSkill", aliases={"onend", "oe"}, description="The meta-skill to execute when the projectile ends")
    protected Optional<Skill> onEndSkill = Optional.empty();
    @MythicField(name="onStartSkill", aliases={"onstart", "os"}, description="The meta-skill to execute when the projectile starts")
    protected Optional<Skill> onStartSkill = Optional.empty();
    @MythicField(name="onHitBlockSkill", aliases={"onhitblockskill", "onhitblock", "ohb"}, description="The meta-skill to execute when the projectile hits a block")
    protected Optional<Skill> onHitBlockSkill = Optional.empty();
    @MythicField(name="onInteractSkill", aliases={"onInteract"}, description="The meta-skill to execute when the projectile is interacted with")
    protected Optional<Skill> onInteractSkill = Optional.empty();
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onBounceSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected String onHitBlockName;
    protected String onInteractName;
    protected ProjectileType type;
    @MythicField(name="fromOrigin", aliases={"fo"}, description="Whether to start the projectile at the origin or from the caster", defValue="true")
    protected boolean fromOrigin;
    @MythicField(name="requireLineOfSight", aliases={"rlos", "los"}, description="Whether the starting point must have line-of-sight to the origin", defValue="PLAYERS_ONLY")
    protected ProjectileTriOption requireLineOfSight;
    @MythicField(name="bulletType", aliases={"bullet", "b"}, description="    The bullet type of the projectile.\n    Bullet Types:\n    - ARROW\n    - BLOCK\n    - ITEM\n    - MYTHICITEM\n    - MOB\n    - TRACKING\n", defValue="NONE")
    protected Optional<ProjectileBulletType> bulletType;
    protected ProjectileBullet bullet;
    @MythicField(name="maxDuration", aliases={"duration", "md", "d"}, description="The max duration of the projectile will persist", defValue="400")
    protected PlaceholderInt duration;
    @MythicField(name="interval", aliases={"int", "i"}, description="How often the projectile is updated in ticks", defValue="1")
    protected int tickInterval;
    protected float ticksPerSecond;
    @MythicField(name="interpolation", aliases={"tickinterpolation", "ti"}, description="Interpolates additional points between each tick of the projectile, running onTick multiple times", defValue="0")
    protected int tickInterpolation;
    @MythicField(name="horizontalRadius", aliases={"hradius", "hr", "r"}, description="The horizontal hit radius of the projectile", defValue="1.25")
    protected PlaceholderFloat hitRadius;
    @MythicField(name="verticalRadius", aliases={"vradius", "vr"}, description="The vertical hit radius of the projectile", defValue="1.25")
    protected PlaceholderFloat verticalHitRadius;
    @MythicField(name="maxRange", aliases={"mr"}, description="The max range in blocks the projectile will travel", defValue="40")
    protected PlaceholderFloat range;
    @MythicField(name="deathDelay", aliases={"death", "dd"}, description="Delays the removal of project bullets when the projectile is terminated", defValue="2")
    protected PlaceholderInt deathDelay;
    @MythicField(name="startYOffset", aliases={"syo"}, description="The start y-offset", defValue="1")
    protected PlaceholderDouble startYOffset;
    @MythicField(name="startForwardOffset", aliases={"forwardoffset", "sfo"}, description="The start forward offset", defValue="1")
    protected PlaceholderFloat startForwardOffset;
    @MythicField(name="startSideOffset", aliases={"ssoffset", "sso"}, description="How far to the side of the caster the projectile is", defValue="0")
    protected PlaceholderDouble startSideOffset;
    @MythicField(name="endSideOffset", aliases={"endoffset", "esoffset", "eso"}, description="How far to the side of the target location the projectile will end up", defValue="0")
    protected PlaceholderDouble endSideOffset;
    @MythicField(name="targetYOffset", aliases={"targety", "tyo"}, description="The y-offset of the target location", defValue="0")
    protected PlaceholderDouble targetYOffset;
    protected Optional<SkillTargeter> projectileStartDirection;
    @MythicField(name="velocity", aliases={"v"}, description="The velocity of the projectile", defValue="5")
    protected PlaceholderFloat projectileVelocity;
    @MythicField(name="verticalOffset", aliases={"vo"}, description="The velocity vertical offset of the projectile", defValue="0")
    protected PlaceholderFloat projectileVelocityVertOffset;
    @MythicField(name="horizontalOffset", aliases={"ho"}, description="The velocity horizontal offset of the projectile", defValue="0")
    protected PlaceholderFloat projectileVelocityHorizOffset;
    @MythicField(name="accuracy", aliases={"ac", "a"}, description="The accuracy of the projectile", defValue="1")
    protected float projectileVelocityAccuracy;
    @MythicField(name="verticalNoise", aliases={"vn"}, description="The vertical noise/randomness of the projectile velocity")
    protected float projectileVelocityVertNoise;
    @MythicField(name="horizontalNoise", aliases={"hn"}, description="The horizontal noise/randomness of the projectile velocity")
    protected float projectileVelocityHorizNoise;
    protected float projectileVelocityVertNoiseBase;
    protected float projectileVelocityHorizNoiseBase;
    @MythicField(name="stopAtEntity", aliases={"se"}, description="Terminates the projectile when hitting an entity", defValue="true")
    protected boolean stopOnHitEntity;
    @MythicField(name="stopAtBlock", aliases={"sb"}, description="Terminates the projectile when hitting a block", defValue="true")
    protected boolean stopOnHitGround;
    @MythicField(name="powerAffectsVelocity", aliases={"pav"}, description="Whether the skill's power affects velocity", defValue="true")
    protected boolean powerAffectsVelocity;
    @MythicField(name="powerAffectsRange", aliases={"par"}, description="Whether the skill's power affects the maximum range", defValue="true")
    protected boolean powerAffectsRange;
    @MythicField(name="interactable", aliases={}, description="Is the projectile hittable? (1.19.4+ only)", defValue="false")
    protected boolean interactable;
    @MythicField(name="hitSelf", description="Can hit the caster", defValue="false")
    protected boolean hitSelf = false;
    @MythicField(name="hitTarget", aliases={"ht"}, description="Can hit the target", defValue="true")
    protected boolean hitTarget = true;
    @MythicField(name="hitPlayers", aliases={"hp"}, description="Can hit players", defValue="true")
    protected boolean hitPlayers = true;
    @MythicField(name="hitNonPlayers", aliases={"hnp"}, description="Can hit non player entities", defValue="false")
    protected boolean hitNonPlayers = false;
    @MythicField(name="hitTargetOnly", aliases={"hto"}, description="Can hit the target only", defValue="false")
    protected boolean hitTargetOnly = false;
    protected boolean hitArmorStands = false;
    @MythicField(name="immuneDelay", aliases={"immune", "id"}, description="Sets the immunity delay (when the target can be hit by the projectile again)", defValue="2000")
    protected int immuneDelay;
    @MythicField(name="shareSubHitboxCooldown", aliases={"shcd"}, description="Draw the hitbox of the projectile, useful for debugging", defValue="false")
    protected boolean shareSubHitboxCooldown;
    @MythicField(name="drawHitbox", description="Draw the hitbox of the projectile, useful for debugging", defValue="false")
    protected boolean drawHitbox = false;
    protected String stopConditionString;
    @MythicField(name="stopConditions", aliases={"stpcond"}, defValue="NONE", version="4.9", premium=true, description="Conditions applied to the stop the projectile when hitting the target")
    protected List<SkillCondition> stopConditions = null;
    protected String hitConditionString;
    @MythicField(name="hitConditions", aliases={"conditions", "cond", "c"}, defValue="NONE", version="4.9", premium=true, description="Conditions applied to the hit target")
    protected List<SkillCondition> hitConditions = null;

    public Projectile(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onBounceSkillName = mlc.getString(new String[]{"onbounceskill", "onbounce"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        this.onHitBlockName = mlc.getString(new String[]{"onhitblockskill", "onhitblock", "ohb"});
        this.onInteractName = mlc.getString(new String[]{"oninteractskill", "oninteract"});
        String bulletType = mlc.getString(new String[]{"bullettype", "bullet", "b"}, "NONE", new String[0]);
        try {
            this.bulletType = ProjectileBulletType.get(bulletType);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet type specified");
            this.bulletType = Optional.empty();
        }
        if (this.bulletType.isPresent()) {
            this.bullet = this.bulletType.get().create(this, mlc);
        }
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 1);
        this.ticksPerSecond = 20.0f / (float)this.tickInterval;
        this.tickInterpolation = mlc.getInteger(new String[]{"tickinterpolation", "interpolation", "ti"}, 0);
        this.hitRadius = mlc.getPlaceholderFloat(new String[]{"horizontalradius", "hradius", "hr", "r"}, 1.25f, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"maxduration", "duration", "md", "d"}, 400, new String[0]);
        this.range = mlc.getPlaceholderFloat(new String[]{"maxrange", "mr"}, 40.0f, new String[0]);
        this.deathDelay = mlc.getPlaceholderInteger(new String[]{"deathdelay", "death", "dd"}, 2, new String[0]);
        this.verticalHitRadius = mlc.getPlaceholderFloat(new String[]{"verticalradius", "vradius", "vr"}, 1.25f, new String[0]);
        this.startYOffset = mlc.getPlaceholderDouble(new String[]{"startyoffset", "syo"}, 1.0, new String[0]);
        this.startForwardOffset = mlc.getPlaceholderFloat(new String[]{"forwardoffset", "startfoffset", "sfo"}, 1.0f, new String[0]);
        this.targetYOffset = mlc.getPlaceholderDouble(new String[]{"targetyoffset", "targety", "tyo"}, 0.0, new String[0]);
        String projectileStartDirection = mlc.getString(new String[]{"startingdirection", "startingdir", "startdir", "sdir"}, null, new String[0]);
        this.projectileStartDirection = projectileStartDirection != null ? Optional.of(this.parseSkillTargeter(projectileStartDirection)) : Optional.empty();
        float sideOffset = mlc.getFloat(new String[]{"sideoffset", "soffset", "so"}, 0.0f);
        this.startSideOffset = mlc.getPlaceholderDouble(new String[]{"startsideoffset", "ssoffset", "sso"}, sideOffset, new String[0]);
        this.endSideOffset = mlc.getPlaceholderDouble(new String[]{"endsideoffset", "endoffset", "esoffset", "eso"}, sideOffset, new String[0]);
        this.projectileVelocity = mlc.getPlaceholderFloat(new String[]{"velocity", "v"}, 5.0f, new String[0]);
        this.projectileVelocityVertOffset = mlc.getPlaceholderFloat(new String[]{"verticaloffset", "vo"}, 0.0f, new String[0]);
        this.projectileVelocityHorizOffset = mlc.getPlaceholderFloat(new String[]{"horizontaloffset", "ho"}, 0.0f, new String[0]);
        this.projectileVelocityAccuracy = mlc.getFloat(new String[]{"accuracy", "ac", "a"}, 1.0f);
        float defNoise = (1.0f - this.projectileVelocityAccuracy) * 45.0f;
        this.projectileVelocityVertNoise = mlc.getFloat(new String[]{"verticalnoise", "vn"}, defNoise) / 10.0f;
        this.projectileVelocityHorizNoise = mlc.getFloat(new String[]{"horizontalnoise", "hn"}, defNoise);
        this.projectileVelocityVertNoiseBase = 0.0f - this.projectileVelocityVertNoise / 2.0f;
        this.projectileVelocityHorizNoiseBase = 0.0f - this.projectileVelocityHorizNoise / 2.0f;
        this.stopOnHitEntity = mlc.getBoolean(new String[]{"stopatentity", "se"}, true);
        this.stopOnHitGround = mlc.getBoolean(new String[]{"stopatblock", "sb"}, true);
        this.powerAffectsVelocity = mlc.getBoolean(new String[]{"poweraffectsvelocity", "pav"}, true);
        this.powerAffectsRange = mlc.getBoolean(new String[]{"poweraffectsrange", "par"}, true);
        this.hitSelf = mlc.getBoolean(new String[]{"hitself"}, false);
        this.hitPlayers = mlc.getBoolean(new String[]{"hitplayers", "hp"}, true);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, false);
        this.hitTarget = mlc.getBoolean(new String[]{"hittarget", "ht"}, true);
        this.hitTargetOnly = mlc.getBoolean(new String[]{"hittargetonly", "hto"}, false);
        this.interactable = mlc.getBoolean(new String[]{"interactable"}, false);
        this.immuneDelay = mlc.getInteger(new String[]{"immunedelay", "immune", "iD"}, 2000);
        this.shareSubHitboxCooldown = mlc.getBoolean(new String[]{"shareSubHitboxCooldown", "shcd"}, true);
        this.stopConditionString = mlc.getString(new String[]{"stopconditions", "stpcond"}, "null", new String[0]);
        this.hitConditionString = mlc.getString(new String[]{"hitconditions", "conditions", "cond", "c"}, "null", new String[0]);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.drawHitbox = mlc.getBoolean(new String[]{"drawhitbox"}, false);
        String requireLineOfSight = mlc.getString(new String[]{"requirelineofsight", "requirelos", "rlos", "los"}, "PLAYERS_ONLY", new String[0]);
        try {
            this.requireLineOfSight = ProjectileTriOption.valueOf(requireLineOfSight.toUpperCase());
        }
        catch (Throwable ex) {
            MythicLogger.errorMechanic(this, "Invalid input for requireLineOfSight option '" + requireLineOfSight + "'");
            this.requireLineOfSight = ProjectileTriOption.PLAYERS_ONLY;
        }
        this.getManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = this.getManager().getSkill(file, this, this.onTickSkillName);
            }
            if (this.onHitSkillName != null) {
                this.onHitSkill = this.getManager().getSkill(file, this, this.onHitSkillName);
            }
            if (this.onBounceSkillName != null) {
                this.onBounceSkill = this.getManager().getSkill(file, this, this.onBounceSkillName);
            }
            if (this.onEndSkillName != null) {
                this.onEndSkill = this.getManager().getSkill(file, this, this.onEndSkillName);
            }
            if (this.onStartSkillName != null) {
                this.onStartSkill = this.getManager().getSkill(file, this, this.onStartSkillName);
            }
            if (this.onHitBlockName != null) {
                this.onHitBlockSkill = this.getManager().getSkill(file, this, this.onHitBlockName);
            }
            if (this.onInteractName != null) {
                this.onInteractSkill = this.getManager().getSkill(file, this, this.onInteractName);
            }
            if (MythicBukkit.isVolatile()) {
                if (this.stopConditionString != null) {
                    this.stopConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.stopConditionString);
                }
                if (this.hitConditionString != null) {
                    this.hitConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.hitConditionString);
                }
            }
        });
    }

    protected Optional<AbstractModelEngineSupport> meg() {
        return ((MythicBukkit)this.getPlugin()).getCompatibility().getModelEngine();
    }

    protected boolean canStopAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.stopOnHitEntity) {
            if (this.stopConditions != null) {
                for (SkillCondition condition : this.stopConditions) {
                    if (condition.evaluateToEntity(data, target)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int getTickInterpolation() {
        return this.tickInterpolation;
    }

    public PlaceholderDouble getTargetYOffset() {
        return this.targetYOffset;
    }

    public static enum ProjectileTriOption {
        TRUE,
        FALSE,
        PLAYERS_ONLY;

    }

    public abstract class ProjectileTracker
    implements IParentSkill,
    ProjectileBulletableTracker,
    Runnable,
    Terminable,
    TerminableConsumer {
        protected final TerminableRegistry components = TerminableRegistry.create();
        private Task task;
        protected SkillMetadata data;
        protected double distanceTraveled = 0.0;
        protected int chargesRemaining;
        protected int ticksRemaining;
        protected int deathDelay;
        protected ProjectileBullet.BulletTracker bullet = null;
        protected float power;
        protected AbstractLocation startLocation;
        protected AbstractLocation previousLocation;
        protected AbstractLocation currentLocation;
        protected AbstractVector currentVelocity;
        protected double velocityMagnitude;
        protected BoundingBox hitbox;
        protected AbstractEntity interactionEntity;
        protected float maxDistanceSquared;
        protected Set<AbstractEntity> inRange = ConcurrentHashMap.newKeySet();
        protected HashSet<AbstractEntity> targets = new HashSet();
        protected HashMap<AbstractEntity, Long> immune = new HashMap();

        public ProjectileTracker(SkillMetadata data, AbstractLocation target) {
            this.data = data.deepClone();
            this.data.setCallingEvent(this);
            this.data.setIsAsync(true);
            this.power = data.getPower();
            this.ticksRemaining = Projectile.this.duration.get(data);
            this.deathDelay = Projectile.this.deathDelay.get(data);
            this.velocityMagnitude = Projectile.this.projectileVelocity.get(data) / Projectile.this.ticksPerSecond;
            float parsedRange = Projectile.this.range.get(data);
            this.maxDistanceSquared = parsedRange * parsedRange;
            if (Projectile.this.tickInterpolation > 0) {
                this.velocityMagnitude /= (double)(Projectile.this.tickInterpolation + 1);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ Projectile fired by Entity {0}: skill = {1}", data.getCaster().getEntity().getName(), Projectile.this.line);
        }

        private void evaluatePotentialTargets() {
            this.inRange.clear();
            if (Projectile.this.hitSelf || Projectile.this.hitPlayers || Projectile.this.hitNonPlayers) {
                this.inRange.addAll(((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(this.currentLocation, Projectile.this.hitRadius.get(this.data)));
                Optional<AbstractModelEngineSupport> megSupport = Projectile.this.meg();
                this.inRange.removeIf(e -> {
                    if (megSupport.isPresent()) {
                        e = ((AbstractModelEngineSupport)megSupport.get()).getParent((AbstractEntity)e);
                    }
                    if (e == null) {
                        return true;
                    }
                    if (BULLET_ENTITIES.contains(e)) {
                        return true;
                    }
                    if (!e.isLiving() || e.isCitizensNPC()) {
                        return true;
                    }
                    if (!Projectile.this.hitSelf && e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!Projectile.this.hitPlayers && e.isPlayer()) {
                        return true;
                    }
                    if (!Projectile.this.hitNonPlayers && !e.isPlayer()) {
                        return true;
                    }
                    if (Projectile.this.hitConditions != null) {
                        for (SkillCondition condition : Projectile.this.hitConditions) {
                            if (condition.evaluateToEntity(this.data, (AbstractEntity)e)) continue;
                            return true;
                        }
                    }
                    return false;
                });
            }
        }

        public void evaluateTargetsInBB() {
            if (this.hitbox != null && this.inRange != null && !this.inRange.isEmpty()) {
                this.immune.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - (long)Projectile.this.immuneDelay);
                for (AbstractEntity original : this.inRange) {
                    Optional<AbstractModelEngineSupport> support = Projectile.this.meg();
                    AbstractEntity base = support.isPresent() ? support.get().getParent(original) : original;
                    if (base.isDead() || original.isDead() || Projectile.this.shareSubHitboxCooldown && this.immune.containsKey(base) || !Projectile.this.shareSubHitboxCooldown && this.immune.containsKey(original)) continue;
                    boolean hit = false;
                    if (support.isPresent() && support.get().overlapsOOBB(this.hitbox, original)) {
                        hit = true;
                    }
                    if (this.hitbox.overlaps(original.getBukkitEntity().getBoundingBox())) {
                        hit = true;
                    }
                    if (!hit) continue;
                    AbstractEntity target = Projectile.this.shareSubHitboxCooldown ? base : original;
                    this.immune.put(target, System.currentTimeMillis() + (long)Projectile.this.immuneDelay);
                    MythicProjectileHitEvent hitEvent = Events.callAndReturn(new MythicProjectileHitEvent(this, target));
                    if (hitEvent.isCancelled()) continue;
                    this.targets.add(target);
                    if (!Projectile.this.canStopAtEntity(this.data, target)) continue;
                    break;
                }
            }
        }

        public boolean executeProjectileSkill(Optional<Skill> skill, SkillMetadata data, boolean atCaster) {
            if (skill == null) {
                return true;
            }
            if (skill.isEmpty()) {
                return true;
            }
            data = data.deepClone();
            if (atCaster) {
                data.setEntityTarget(data.getCaster().getEntity());
            } else {
                AbstractLocation location = Projectile.this.bulletType.isPresent() && Projectile.this.bulletType.get() == ProjectileBulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                data.setLocationTargets(List.of(location));
                data.setOrigin(location);
            }
            if (skill.get().isUsable(data)) {
                VariableRegistry vars = data.getVariables();
                skill.get().execute(data);
                return true;
            }
            return false;
        }

        public void setPower(float p) {
            this.power = p;
        }

        public void multiplyPower(float p) {
            this.power *= p;
        }

        public void addPower(float p) {
            this.power += p;
        }

        public void updateHitbox() {
            float hitRadius = Projectile.this.hitRadius.get(this.data);
            float verticalHitRadius = Projectile.this.verticalHitRadius.get(this.data);
            if (hitRadius == 0.0f || verticalHitRadius == 0.0f) {
                this.hitbox = null;
                return;
            }
            try {
                this.hitbox = BoundingBox.of((Location)BukkitAdapter.adapt(this.currentLocation), (double)hitRadius, (double)verticalHitRadius, (double)hitRadius);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.hitbox == null) {
                return;
            }
            if (Projectile.this.interactable && this.interactionEntity != null) {
                this.interactionEntity.teleport(this.currentLocation.clone().subtract(0.0, verticalHitRadius, 0.0));
            }
            if (Projectile.this.drawHitbox) {
                Vector min2 = this.hitbox.getMin();
                Vector max = this.hitbox.getMax();
                double particleDistance = 0.5;
                World world = BukkitAdapter.adapt(this.currentLocation.getWorld());
                Particle particle = Particle.ELECTRIC_SPARK;
                for (double y : new double[]{min2.getY(), max.getY()}) {
                    for (double z : new double[]{min2.getZ(), max.getZ()}) {
                        for (double x = min2.getX(); x <= max.getX(); x += particleDistance) {
                            world.spawnParticle(particle, x, y, z, 0);
                        }
                    }
                }
                for (double x : new double[]{min2.getX(), max.getX()}) {
                    for (double z : new double[]{min2.getZ(), max.getZ()}) {
                        for (double y = min2.getY(); y <= max.getY(); y += particleDistance) {
                            world.spawnParticle(particle, x, y, z, 0);
                        }
                    }
                }
                for (double x : new double[]{min2.getX(), max.getX()}) {
                    for (double y : new double[]{min2.getY(), max.getY()}) {
                        for (double z = min2.getZ(); z <= max.getZ(); z += particleDistance) {
                            world.spawnParticle(particle, x, y, z, 0);
                        }
                    }
                }
            }
        }

        public boolean start() {
            Events.subscribe(WorldUnloadEvent.class).filter(event -> this.startLocation == null || event.getWorld().getUID().equals(this.startLocation.getWorld().getUniqueId())).handler(event -> this.terminate()).bindWith(this);
            Promise.start().thenRunSync(() -> {
                this.projectileStart();
                this.updateHitbox();
                if (this.bullet != null) {
                    this.bullet.spawn(this.currentLocation);
                }
                if (Projectile.this.interactable) {
                    float vhr = Projectile.this.verticalHitRadius.get(this.data);
                    Location loc = BukkitAdapter.adapt(this.currentLocation).subtract(0.0, (double)vhr, 0.0);
                    Interaction bukkitInteractionEntity = (Interaction)loc.getWorld().spawnEntity(loc, EntityType.INTERACTION);
                    bukkitInteractionEntity.setInteractionHeight(vhr * 2.0f);
                    bukkitInteractionEntity.setInteractionWidth(Projectile.this.hitRadius.get(this.data) * 2.0f);
                    bukkitInteractionEntity.setResponsive(true);
                    bukkitInteractionEntity.setPersistent(false);
                    this.interactionEntity = BukkitAdapter.adapt((Entity)bukkitInteractionEntity);
                    Events.subscribe(PlayerInteractEntityEvent.class).filter(event -> event.getRightClicked().getType() == EntityType.INTERACTION && event.getRightClicked().getUniqueId().equals(this.interactionEntity.getUniqueId())).handler(event -> {
                        if (Projectile.this.onInteractSkill.isPresent() && Projectile.this.onInteractSkill.get().isUsable(this.data)) {
                            SkillMetadata sData = this.data.deepClone();
                            AbstractPlayer theTrigger = BukkitAdapter.adapt(event.getPlayer());
                            sData.setTrigger(theTrigger);
                            sData.setEntityTarget(theTrigger);
                            sData.setOrigin(this.currentLocation.clone());
                            Projectile.this.onInteractSkill.get().execute(sData);
                        }
                    }).bindWith(this);
                    Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getEntity().getType() == EntityType.INTERACTION && event.getEntity().getUniqueId().equals(this.interactionEntity.getUniqueId())).handler(event -> {
                        if (Projectile.this.onInteractSkill.isPresent() && Projectile.this.onInteractSkill.get().isUsable(this.data)) {
                            SkillMetadata sData = this.data.deepClone();
                            AbstractEntity theTrigger = BukkitAdapter.adapt(event.getDamager());
                            sData.setTrigger(theTrigger);
                            sData.setEntityTarget(theTrigger);
                            sData.setOrigin(this.currentLocation.clone());
                            Projectile.this.onInteractSkill.get().execute(sData);
                        }
                    }).bindWith(this);
                }
                if (Projectile.this.onStartSkill.isPresent() && Projectile.this.onStartSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                    targets.add(this.startLocation);
                    sData.setLocationTargets(targets);
                    sData.setOrigin(this.currentLocation.clone());
                    Projectile.this.onStartSkill.get().execute(sData);
                }
                this.task = Schedulers.sync().runRepeating(this, 0L, (long)Projectile.this.tickInterval);
                this.task.bindWith(this);
                if (this.requireLineOfSight()) {
                    AbstractLocation origin = Projectile.this.fromOrigin ? this.data.getOrigin().clone().add(0.0, Projectile.this.startYOffset.get(this.data), 0.0) : this.data.getCaster().getLocation().add(0.0, Projectile.this.startYOffset.get(this.data), 0.0);
                    RayTraceResult traceResult = ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getWorldHandler().rayTraceBlock(origin, this.currentLocation, FluidCollisionMode.NEVER, true);
                    if (traceResult != null && traceResult.getHitBlock() != null && !traceResult.getHitBlock().isEmpty()) {
                        AbstractLocation hitLocation = BukkitAdapter.adapt(traceResult.getHitPosition()).toLocation(this.currentLocation.getWorld());
                        hitLocation.setPitch(this.currentLocation.getPitch());
                        hitLocation.setYaw(this.currentLocation.getYaw());
                        this.currentLocation = hitLocation;
                        this.terminate();
                    }
                }
            });
            return true;
        }

        @Override
        public int getTimesRan() {
            return this.task.getTimesRan();
        }

        private boolean requireLineOfSight() {
            return Projectile.this.requireLineOfSight == ProjectileTriOption.TRUE || Projectile.this.requireLineOfSight == ProjectileTriOption.PLAYERS_ONLY && this.data.getCaster().getEntity().isPlayer();
        }

        public void setDirection(AbstractVector direction) {
            this.currentVelocity = direction.normalize().multiply(this.getVelocityMagnitude());
        }

        @Override
        public void run() {
            if (this.data.getCaster() != null && this.data.getCaster().getEntity().isDead()) {
                this.terminate();
                return;
            }
            if (this.currentLocation.distanceSquared(this.startLocation) >= (double)this.maxDistanceSquared) {
                this.terminate();
                return;
            }
            if (this.ticksRemaining <= 0) {
                this.terminate();
                return;
            }
            if (this.bullet != null) {
                this.bullet.tick(this.getCurrentLocation());
            }
            if (Projectile.this.tickInterpolation > 0) {
                for (int i = 0; i <= Projectile.this.tickInterpolation; ++i) {
                    this.projectileMove();
                    this.updateHitbox();
                    this.evaluatePotentialTargets();
                    this.projectileTick();
                }
            } else {
                this.projectileMove();
                this.updateHitbox();
                this.evaluatePotentialTargets();
                this.projectileTick();
            }
            this.ticksRemaining -= Projectile.this.tickInterval;
        }

        public abstract void projectileStart();

        public abstract void projectileMove();

        public abstract void projectileTick();

        public void projectileEnd() {
        }

        @Override
        public void close() {
            if (!this.components.hasTerminated()) {
                this.projectileEnd();
                if (Projectile.this.bulletType.isPresent()) {
                    Schedulers.sync().runLater(() -> {
                        if (this.bullet != null) {
                            this.bullet.despawn();
                        }
                    }, this.deathDelay);
                }
                if (Projectile.this.interactable && this.interactionEntity != null) {
                    this.interactionEntity.remove();
                }
                if (Projectile.this.onEndSkill.isPresent() && Projectile.this.onEndSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    Projectile.this.onEndSkill.get().execute(sData.setOrigin(this.currentLocation).setLocationTarget(this.currentLocation));
                }
                if (this.inRange != null) {
                    this.inRange.clear();
                }
            }
            this.components.closeAndReportException();
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }

        @Override
        public <T extends AutoCloseable> T bind(T terminable) {
            this.components.accept((Terminable)terminable);
            return terminable;
        }

        @Override
        public SkillMetadata getData() {
            return this.data;
        }

        public double getDistanceTraveled() {
            return this.distanceTraveled;
        }

        public int getChargesRemaining() {
            return this.chargesRemaining;
        }

        public int getTicksRemaining() {
            return this.ticksRemaining;
        }

        public int getDeathDelay() {
            return this.deathDelay;
        }

        @Override
        public ProjectileBullet.BulletTracker getBullet() {
            return this.bullet;
        }

        public AbstractLocation getStartLocation() {
            return this.startLocation;
        }

        @Override
        public AbstractLocation getPreviousLocation() {
            return this.previousLocation;
        }

        @Override
        public AbstractLocation getCurrentLocation() {
            return this.currentLocation;
        }

        @Override
        public AbstractVector getCurrentVelocity() {
            return this.currentVelocity;
        }

        public void setCurrentVelocity(AbstractVector currentVelocity) {
            this.currentVelocity = currentVelocity;
        }

        @Override
        public double getVelocityMagnitude() {
            return this.velocityMagnitude;
        }

        public BoundingBox getHitbox() {
            return this.hitbox;
        }

        public AbstractEntity getInteractionEntity() {
            return this.interactionEntity;
        }

        public float getMaxDistanceSquared() {
            return this.maxDistanceSquared;
        }
    }

    protected static enum ProjectileType {
        NORMAL,
        METEOR;

    }
}

