/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderVector;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import net.objecthunter.exp4j.ExpressionBuilder;

public final class PlaceholderVectorImpl
extends PlaceholderParser
implements PlaceholderVector {
    public PlaceholderVectorImpl(String string) {
        super(string);
        if (string != null && (string.startsWith("=") || string.contains("(") && string.contains(")"))) {
            this.doMath = true;
        }
        if (!MythicBukkit.isVolatile()) {
            MythicLogger.error("Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythiccraft.io");
            this.doMath = false;
        }
    }

    @Override
    public AbstractVector get() {
        String parsedInput = this.parse();
        try {
            String[] split = parsedInput.split(",");
            double dx = Double.parseDouble(split[0]);
            double dy = Double.parseDouble(split[1]);
            double dz = Double.parseDouble(split[2]);
            return new AbstractVector(dx, dy, dz);
        }
        catch (Error | Exception ex) {
            MythicLogger.error(this.strValue + " is not a valid vector. Parsed as '" + parsedInput + "'.");
            return new AbstractVector();
        }
    }

    @Override
    public AbstractVector get(PlaceholderMeta meta) {
        return this.get(meta, meta == null ? null : meta.getTrigger());
    }

    @Override
    public AbstractVector get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    @Override
    public AbstractVector get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.parseVector(string);
    }

    @Override
    public AbstractVector get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    @Override
    public boolean isStaticallyEqualTo(AbstractVector value) {
        return this.isStatic() && this.get().equals(value);
    }

    private AbstractVector parseVector(String string) {
        try {
            double dz;
            double dy;
            double dx;
            String[] split = string.split(",");
            if (this.doMath) {
                dx = new ExpressionBuilder(split[0]).operator(Operators.operators).functions(Functions.functions).build().evaluate();
                dy = new ExpressionBuilder(split[1]).operator(Operators.operators).functions(Functions.functions).build().evaluate();
                dz = new ExpressionBuilder(split[2]).operator(Operators.operators).functions(Functions.functions).build().evaluate();
            } else {
                dx = Double.parseDouble(split[0]);
                dy = Double.parseDouble(split[1]);
                dz = Double.parseDouble(split[2]);
            }
            return new AbstractVector(dx, dy, dz);
        }
        catch (Error | Exception ex) {
            MythicLogger.error(this.strValue + " is not a valid vector. Was parsed as '" + string + "'.");
            MythicLogger.handleMinorError(ex);
            return null;
        }
    }
}

