/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.placeholders.parsers.RandomFloat;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticFloat;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderFloatImpl
extends PlaceholderParser
implements PlaceholderFloat {
    public PlaceholderFloatImpl() {
    }

    public PlaceholderFloatImpl(String string) {
        super(string);
        if (string != null && (string.startsWith("=") || string.contains("(") && string.contains(")"))) {
            this.doMath = true;
        }
    }

    @Override
    public float get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public float get(PlaceholderMeta meta) {
        return this.get(meta, meta == null ? null : meta.getTrigger());
    }

    @Override
    public float get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    @Override
    public float get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    public float get(PlaceholderMeta meta, AbstractItemStack itemStack) {
        String string = this.parse(meta, itemStack);
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    private float handleParsing(String string) {
        if (this.doMath) {
            try {
                return (float)new ExpressionBuilder(string).operator(Operators.operators).functions(Functions.functions).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderFloat: " + this.strValue);
                MythicLogger.handleMinorError(ex);
            }
        }
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException e) {
            return 1.0f;
        }
    }

    @Override
    public float get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderFloatImpl of(String string) {
        try {
            if (string == null) {
                return null;
            }
            if (io.lumine.mythic.bukkit.utils.numbers.RandomFloat.matches(string)) {
                return new RandomFloat(string);
            }
            if (string.matches("-?\\d?\\.?\\d*")) {
                return new StaticFloat(string);
            }
            if (!MythicBukkit.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythiccraft.io");
                return new StaticFloat("1");
            }
            return new PlaceholderFloatImpl(string);
        }
        catch (Exception exception) {
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticFloat("1");
        }
    }

    @Override
    public boolean isStaticallyEqualTo(float value) {
        return this.isStatic() && this.get() == value;
    }
}

