/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderBoolean;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticBoolean;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderBooleanImpl
extends PlaceholderParser
implements PlaceholderBoolean {
    public PlaceholderBooleanImpl() {
    }

    public PlaceholderBooleanImpl(String string) {
        super(string);
        if (string != null && (string.startsWith("=") || string.contains("(") && string.contains(")"))) {
            this.doMath = true;
        }
    }

    @Override
    public boolean get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public boolean get(PlaceholderMeta meta) {
        return this.get(meta, meta.getTrigger());
    }

    @Override
    public boolean get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    @Override
    public boolean get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public boolean get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public boolean get(PlaceholderMeta meta, AbstractItemStack itemStack) {
        String string = this.parse(meta, itemStack);
        if (string == null) {
            MythicLogger.error("Item placeholder value is null for {0}", itemStack.toString());
            return false;
        }
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public boolean get(MythicSpawner spawner) {
        String string = this.parse(spawner);
        if (string == null) {
            MythicLogger.error("Spawner placeholder value is null for {0}", spawner.getInternalName());
            return false;
        }
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    private boolean handleParsing(String string) {
        if (this.doMath) {
            try {
                string = String.valueOf((int)new ExpressionBuilder(string).operator(Operators.operators).functions(Functions.functions).build().evaluate());
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderInt: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return string.equalsIgnoreCase("true") || string.equals("1");
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderBooleanImpl of(String string) {
        try {
            if (string == null) {
                return null;
            }
            if (string.matches("true|false|0|1")) {
                return new StaticBoolean(string);
            }
            if (!MythicBukkit.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables require premium! Consider getting MythicMobs Premium at www.mythiccraft.io");
                return new StaticBoolean("0");
            }
            return new PlaceholderBooleanImpl(string);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticBoolean("0");
        }
    }

    @Override
    public boolean isStaticallyEqualTo(Boolean value) {
        return this.isStatic() && this.get() == value.booleanValue();
    }
}

