/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;

@MythicPlaceholder(placeholder="skill", version="5.6")
public class SkillParameterPlaceholder
implements MetaPlaceholder {
    private final PlaceholderExecutor manager;
    private final PlaceholderString parameter;

    public SkillParameterPlaceholder(PlaceholderExecutor manager, MythicLineConfig config, String[] args) {
        this.manager = manager;
        this.parameter = args.length > 0 ? PlaceholderString.of(args[0]) : PlaceholderString.of("[Invalid]");
    }

    @Override
    public String apply(PlaceholderMeta placeholderMeta, String arg) {
        String parameterName = this.parameter.get(placeholderMeta);
        if (placeholderMeta instanceof SkillMetadata) {
            String parameter;
            SkillMetadata data = (SkillMetadata)placeholderMeta;
            String def = "[Undefined]";
            if (parameterName.contains("|")) {
                String[] split = parameterName.split("\\|");
                parameterName = split[0];
                try {
                    def = split[1];
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((parameter = data.getParameters().get(parameterName.toLowerCase())) == null) {
                return def;
            }
            return parameter;
        }
        return "[Undefined]";
    }
}

