/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.all.EntityNumericPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;
import org.bukkit.attribute.Attribute;

@MythicPlaceholder(placeholder="caster.damage", aliases={"caster.dmg", "caster.d"})
public class CasterDamagePlaceholder
extends EntityNumericPlaceholder
implements MetaPlaceholder {
    public CasterDamagePlaceholder(PlaceholderExecutor manager, MythicLineConfig config, String[] args) {
        super(manager, config);
    }

    @Override
    public String apply(PlaceholderMeta placeholderMeta, String args) {
        SkillCaster caster = placeholderMeta.getCaster();
        if (caster instanceof ActiveMob) {
            ActiveMob activeMob = (ActiveMob)caster;
            return this.format(activeMob.getDamage());
        }
        if (caster.getEntity().isPlayer()) {
            return this.format(BukkitAdapter.adapt(caster.getEntity().asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
        }
        return "0";
    }
}

