/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.pins;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.pins.PinManager;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.ConfigurationSectionProp;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.constants.MobKeys;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.pins.MultiPin;
import io.lumine.mythic.core.skills.pins.Pin;
import io.lumine.mythic.core.skills.pins.SinglePin;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PinExecutor
extends ReloadableModule<MythicBukkit>
implements PinManager {
    private static final ConfigurationSectionProp REMOVER = Property.ConfigurationSection(Scope.CONFIG, "");
    private final Map<String, Pin> pins = Maps.newConcurrentMap();
    private Task pinUpdateTask;
    private final Map<AbstractLocation, PacketTextDisplay> pinHolograms = Maps.newConcurrentMap();
    private final Collection<AbstractPlayer> playersViewingPins = Sets.newHashSet();

    public PinExecutor(MythicBukkit plugin) {
        super(plugin, false);
        this.load(plugin);
        Events.subscribe(PlayerQuitEvent.class).handler(event -> {
            AbstractPlayer player = BukkitAdapter.adapt(event.getPlayer());
            if (this.playersViewingPins.contains(player)) {
                this.toggleViewingPins(player);
            }
        }).bindWith(this);
        Events.subscribe(PlayerInteractEvent.class).filter(event -> event.getHand() == EquipmentSlot.HAND).filter(event -> event.getItem() != null).filter(event -> event.getItem().getType() == Material.BLAZE_ROD).filter(event -> event.getItem().hasItemMeta()).handler(event -> {
            ItemMeta meta = event.getItem().getItemMeta();
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            if (!pdc.has(MobKeys.PIN_WAND)) {
                return;
            }
            event.setCancelled(true);
            Player player = event.getPlayer();
            AbstractLocation location = BukkitAdapter.adapt(player.getLocation());
            String pinName = (String)pdc.get(MobKeys.PIN_WAND, PersistentDataType.STRING);
            String pinPack = (String)pdc.get(MobKeys.PIN_PACK, PersistentDataType.STRING);
            Optional<Pack> maybePack = ((MythicBukkit)this.getPlugin()).getPackManager().getPack(pinPack);
            if (maybePack.isEmpty()) {
                CommandHelper.sendError((CommandSender)player, "Pack not found");
                return;
            }
            Pack pack = maybePack.get();
            Optional<Pin> maybePin = this.getPin(pinName);
            if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (maybePin.isEmpty()) {
                    CommandHelper.sendSuccess((CommandSender)player, "Created new multi-pin " + pinPack + "." + pinName + " at location");
                    this.createMultiPin(pack, pinName, location);
                } else {
                    Pin pin = maybePin.get();
                    if (!(pin instanceof MultiPin)) {
                        CommandHelper.sendError((CommandSender)player, "Pin is not a multi-pin");
                        return;
                    }
                    pin.getLocations().add(location);
                    pin.save();
                    CommandHelper.sendSuccess((CommandSender)player, "Added location to multi-pin " + pinPack + "." + pinName);
                }
            } else if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Pin patt0$temp;
                if (maybePin.isPresent() && (patt0$temp = maybePin.get()) instanceof MultiPin) {
                    MultiPin pin = (MultiPin)patt0$temp;
                    if (!pin.getLocations().isEmpty()) {
                        pin.getLocations().remove(pin.getLocations().size() - 1);
                        pin.save();
                        CommandHelper.sendSuccess((CommandSender)player, "Removed the most recent location from multi-pin " + pinPack + "." + pinName);
                    } else {
                        CommandHelper.sendError((CommandSender)player, "No locations to remove");
                    }
                } else {
                    CommandHelper.sendError((CommandSender)player, "Multi-pin not found or not a multi-pin");
                }
            }
        }).bindWith(this);
    }

    @Override
    public void load(MythicBukkit mythicBukkit) {
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            File file = pack.getPackFile("pins.yml");
            if (!file.exists()) continue;
            MythicConfigImpl baseConfig = new MythicConfigImpl(file);
            for (String node : baseConfig.getKeys("")) {
                try {
                    if (baseConfig.isSet(node + ".Locations")) {
                        this.pins.put(node, new MultiPin(pack, file, node));
                        continue;
                    }
                    this.pins.put(node, new SinglePin(pack, file, node));
                }
                catch (Throwable ex) {
                    MythicLogger.error("Failed to load pin {0} - world may be unloaded", node);
                }
            }
        }
    }

    @Override
    public void unload() {
        this.disablePinHolograms();
        this.pins.clear();
    }

    private File getPinFile(Pack pack) {
        return pack.getPackFile("pins.yml");
    }

    public void createPin(Pack pack, String node, AbstractLocation location) {
        SinglePin pin = new SinglePin(pack, this.getPinFile(pack), node, location);
        pin.save();
        this.pins.put(node, pin);
        if (!this.playersViewingPins.isEmpty()) {
            this.createPinHologram(pin, location);
        }
    }

    public MultiPin createMultiPin(Pack pack, String node, AbstractLocation location) {
        MultiPin pin = new MultiPin(pack, this.getPinFile(pack), node, location);
        pin.save();
        this.pins.put(node, pin);
        if (!this.playersViewingPins.isEmpty()) {
            this.createPinHologram(pin, location);
        }
        return pin;
    }

    @Override
    public Optional<Pin> getPin(String key) {
        return Optional.ofNullable(this.pins.get(key));
    }

    public void movePin(SinglePin singlePin, AbstractLocation location) {
        AbstractLocation oldLocation = singlePin.getLocations().get(0);
        PacketTextDisplay hologram = this.pinHolograms.remove(oldLocation);
        if (hologram != null) {
            hologram.destroy();
        }
        singlePin.getLocations().clear();
        singlePin.getLocations().add(location);
        singlePin.save();
        if (!this.playersViewingPins.isEmpty()) {
            this.createPinHologram(singlePin, location);
        }
    }

    public boolean removeMultiPinPoint(MultiPin multiPin, AbstractLocation location) {
        PacketTextDisplay hologram = this.pinHolograms.remove(location);
        if (hologram != null) {
            hologram.destroy();
        }
        multiPin.getLocations().remove(location);
        multiPin.save();
        return true;
    }

    public boolean removePin(Pack pack, String node) {
        Pin pin = this.pins.remove(node);
        if (pin == null) {
            return false;
        }
        File file = pack.getPackFile("pins.yml");
        if (!file.exists()) {
            return false;
        }
        REMOVER.fdelete((Object)file, node);
        for (AbstractLocation loc : pin.getLocations()) {
            PacketTextDisplay hologram = this.pinHolograms.remove(loc);
            if (hologram == null) continue;
            hologram.destroy();
        }
        return true;
    }

    public ItemStack createWand(Pack pack, String nodeName) {
        return ItemFactory.of(Material.BLAZE_ROD).name("<gold>Pin Wand <gray>(<aqua>" + nodeName + "<gray>)").lore("<yellow>Pack<gray>: <white>" + pack.getKey()).breakable(false).enchant(Enchantment.VANISHING_CURSE).hideAttributes().pdc(pdc -> {
            pdc.set(MobKeys.PIN_WAND, PersistentDataType.STRING, (Object)nodeName);
            pdc.set(MobKeys.PIN_PACK, PersistentDataType.STRING, (Object)pack.getKey());
        }).build();
    }

    public boolean toggleViewingPins(AbstractPlayer player) {
        if (this.playersViewingPins.contains(player)) {
            this.playersViewingPins.remove(player);
            if (this.playersViewingPins.isEmpty()) {
                this.disablePinHolograms();
            }
            return false;
        }
        if (this.playersViewingPins.isEmpty()) {
            this.playersViewingPins.add(player);
            this.setupPinHolograms();
        } else {
            this.playersViewingPins.add(player);
        }
        return true;
    }

    public void setupPinHolograms() {
        for (Pin pin : this.pins.values()) {
            for (AbstractLocation loc : pin.getLocations()) {
                this.createPinHologram(pin, loc);
            }
        }
        this.pinUpdateTask = Schedulers.async().runRepeating(() -> {
            for (PacketTextDisplay hologram : this.pinHolograms.values()) {
                hologram.getRenderer().updateRenderedPlayers();
            }
        }, 20L, 20L);
    }

    public void createPinHologram(Pin pin, AbstractLocation location) {
        PacketTextDisplay hologram = PacketTextDisplay.create().lineWidth(200).scale(new AbstractVector(0.65, 0.65, 0.65)).yOffset(Float.valueOf(0.0f)).text("<gold>Pin\n<white>" + pin.getPropertyNode()).cullingDistance(32).build(location);
        ((PacketEntityRenderer)hologram.getRenderer()).spawn(() -> this.playersViewingPins);
        this.pinHolograms.put(location, hologram);
    }

    public void disablePinHolograms() {
        for (PacketTextDisplay hologram : this.pinHolograms.values()) {
            hologram.destroy();
        }
        if (this.pinUpdateTask != null) {
            this.pinUpdateTask.terminate();
        }
        this.pinHolograms.clear();
        this.playersViewingPins.clear();
    }

    public Map<String, Pin> getPins() {
        return this.pins;
    }
}

