/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.pins;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import java.io.File;
import java.util.List;

public abstract class Pin
implements PropertyHolder {
    protected final Pack pack;
    protected final File file;
    protected final String propertyNode;
    protected final List<AbstractLocation> locations = Lists.newArrayList();

    public Pin(Pack pack, File file, String node) {
        this.pack = pack;
        this.file = file;
        this.propertyNode = node;
        this.loadLocations();
    }

    public Pin(Pack pack, File file, String node, AbstractLocation location) {
        this.pack = pack;
        this.file = file;
        this.propertyNode = node;
        this.locations.add(location);
    }

    public abstract void loadLocations();

    public abstract void save();

    public Pack getPack() {
        return this.pack;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getPropertyNode() {
        return this.propertyNode;
    }

    public List<AbstractLocation> getLocations() {
        return this.locations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pin)) {
            return false;
        }
        Pin other = (Pin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pack this$pack = this.getPack();
        Pack other$pack = other.getPack();
        if (this$pack == null ? other$pack != null : !this$pack.equals(other$pack)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$propertyNode = this.getPropertyNode();
        String other$propertyNode = other.getPropertyNode();
        if (this$propertyNode == null ? other$propertyNode != null : !this$propertyNode.equals(other$propertyNode)) {
            return false;
        }
        List<AbstractLocation> this$locations = this.getLocations();
        List<AbstractLocation> other$locations = other.getLocations();
        return !(this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pack $pack = this.getPack();
        result = result * 59 + ($pack == null ? 43 : $pack.hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $propertyNode = this.getPropertyNode();
        result = result * 59 + ($propertyNode == null ? 43 : $propertyNode.hashCode());
        List<AbstractLocation> $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        return result;
    }

    public String toString() {
        return "Pin(pack=" + String.valueOf(this.getPack()) + ", file=" + String.valueOf(this.getFile()) + ", propertyNode=" + this.getPropertyNode() + ", locations=" + String.valueOf(this.getLocations()) + ")";
    }
}

