/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicModifiedInventoryEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@MythicMechanic(author="Ashijin", name="takeitem", aliases={"take", "takeitems", "itemtake"}, description="Takes an item from the target")
public class TakeItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private AbstractItemStack item;
    private PlaceholderInt amount;
    private boolean exact;

    public TakeItemMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        this.exact = mlc.getBoolean(new String[]{"exact", "e"}, true);
        String materialString = mlc.getString(new String[]{"item", "i", "type", "t", "material", "mat", "m", "mi", "mythicitem"}, "DIRT", new String[0]);
        ((MythicBukkit)this.getPlugin()).getClock().queueSecondPass(() -> {
            try {
                this.item = ((MythicBukkit)this.getPlugin()).getBootstrap().createItem(materialString);
            }
            catch (IllegalArgumentException ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "'" + materialString + "' is not a valid material.");
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        this.removeItem(data, target, (Inventory)player.getInventory(), this.amount.get(data, target));
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof Container)) {
            return SkillResult.INVALID_TARGET;
        }
        Container container = (Container)blockState;
        this.removeItem(data, null, container.getInventory(), this.amount.get(data));
        return SkillResult.SUCCESS;
    }

    private void removeItem(SkillMetadata data, AbstractEntity target, Inventory inventory, int amountToRemove) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack inventoryItem = inventory.getItem(i);
            if (inventoryItem == null || this.exact && !this.item.isSimilar(BukkitAdapter.adapt(inventoryItem))) continue;
            if (!this.exact) {
                ItemStack checkItem = BukkitAdapter.adapt(this.item);
                if (checkItem.getType() != inventoryItem.getType() || checkItem.hasItemMeta() != inventoryItem.hasItemMeta()) continue;
                if (checkItem.hasItemMeta()) {
                    ItemMeta checkMeta = checkItem.getItemMeta();
                    ItemMeta inventoryMeta = inventoryItem.getItemMeta();
                    if (checkMeta.hasDisplayName() && (!inventoryMeta.hasDisplayName() || !checkMeta.getDisplayName().equals(inventoryMeta.getDisplayName())) || checkMeta.hasCustomModelData() != inventoryMeta.hasCustomModelData() || checkMeta.hasCustomModelData() && checkMeta.getCustomModelData() != inventoryMeta.getCustomModelData() || checkMeta.getClass() != inventoryMeta.getClass()) continue;
                }
            }
            int slotAmount = inventoryItem.getAmount();
            int newAmount = Math.max(0, slotAmount - amountToRemove);
            amountToRemove = Math.max(0, amountToRemove - slotAmount);
            if (newAmount <= 0) {
                ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().destroyItem(inventoryItem);
                if (target != null && target.isPlayer()) {
                    AbstractPlayer player = target.asPlayer();
                    player.updateInventory();
                    Events.call(new MythicModifiedInventoryEvent(data.getCaster(), BukkitAdapter.adapt(player)));
                }
            } else {
                inventoryItem.setAmount(newAmount);
            }
            if (amountToRemove == 0) break;
        }
    }
}

