/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="summon", aliases={"spawnMob", "spawnMobs", "pirateSummon"}, description="Summons mobs at the target location")
public class SummonMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected MythicMob mm;
    protected BukkitEntityType me;
    protected PlaceholderString strType;
    protected PlaceholderInt amount;
    protected PlaceholderDouble level;
    protected PlaceholderFloat yaw;
    protected PlaceholderFloat pitch;
    protected int noise;
    protected int yNoise;
    protected double force;
    protected double yForce;
    protected boolean summonerIsOwner;
    protected boolean summonerIsParent;
    protected boolean summonerIsFaction;
    protected boolean yUpOnly;
    protected boolean onSurface;
    protected boolean inheritFaction;
    protected boolean inheritThreatTable;
    protected boolean copyThreatTable;
    protected boolean inheritDespawnOption;
    @MythicField(name="onSummon", aliases={"then"}, version="4.14", description="Skill to execute when the destination is reached")
    protected Optional<Skill> onSummonSkill = Optional.empty();
    protected String onSummonSkillName;

    public SummonMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        this.level = mlc.getPlaceholderDouble(new String[]{"level", "l"}, -1.0, new String[0]);
        this.yaw = mlc.getPlaceholderFloat(new String[]{"yaw"}, null, new String[0]);
        this.pitch = mlc.getPlaceholderFloat(new String[]{"pitch"}, null, new String[0]);
        this.noise = mlc.getInteger(new String[]{"noise", "n", "radius", "r"}, 0);
        this.yNoise = mlc.getInteger(new String[]{"ynoise", "yn", "yradius", "yr"}, this.noise);
        this.yUpOnly = mlc.getBoolean(new String[]{"yradiusuponly", "yradiusonlyup", "yruo", "yu"}, false);
        this.force = mlc.getDouble(new String[]{"force", "f", "velocity", "v"}, 0.0);
        this.yForce = mlc.getDouble(new String[]{"yforce", "yf", "yvelocity", "yv"}, this.force);
        this.onSurface = mlc.getBoolean(new String[]{"onsurface", "os", "s"}, false);
        this.copyThreatTable = mlc.getBoolean(new String[]{"copythreattable", "ctt"}, false);
        this.inheritFaction = mlc.getBoolean(new String[]{"inheritfaction", "if"}, true);
        this.inheritThreatTable = mlc.getBoolean(new String[]{"inheritthreattable", "itt"}, false);
        this.summonerIsOwner = mlc.getBoolean(new String[]{"summonerisowner", "sio"}, true);
        this.summonerIsParent = mlc.getBoolean(new String[]{"summonerisparent", "sip"}, true);
        this.summonerIsFaction = mlc.getBoolean(new String[]{"summonerisfaction", "sif"}, false);
        this.inheritDespawnOption = mlc.getBoolean(new String[]{"inheritdespawn", "inheritdespawnoption", "ido"}, false);
        this.strType = mlc.getPlaceholderString(new String[]{"type", "t", "mob", "m"}, "SKELETON", new String[0]);
        if (this.strType.isStatic()) {
            ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
                this.mm = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(this.strType.get()).orElse(null);
                if (this.mm == null) {
                    this.me = BukkitEntityType.getMythicEntity(this.strType.get());
                    if (this.me == null) {
                        MythicLogger.errorMechanicConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
                    }
                }
            });
        } else {
            this.mm = null;
            this.me = null;
        }
        this.onSummonSkillName = mlc.getString(new String[]{"onsummonskill", "onsummon", "then"});
        this.getManager().queueSecondPass(() -> {
            if (this.onSummonSkillName != null) {
                this.onSummonSkill = this.getManager().getSkill(file, this, this.onSummonSkillName);
            }
        });
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        int amount = this.amount.get(data);
        double level = this.level.get(data);
        level = level == -1.0 ? data.getCaster().getLevel() : level;
        MythicMob mythicSpawnType = this.mm;
        BukkitEntityType bukkitEntityType = this.me;
        if (mythicSpawnType == null && (mythicSpawnType = (MythicMob)((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(this.strType.get(data)).orElse(null)) == null && (bukkitEntityType = BukkitEntityType.getMythicEntity(this.strType.get(data))) == null) {
            MythicLogger.error("The 'type' attribute must be a valid MythicMob or MythicEntity type. Spawned from a placeholder summon mechanic, no MLC available. Mob String: " + this.strType.get());
        }
        if (mythicSpawnType != null) {
            if (this.noise > 0) {
                for (int i = 1; i <= amount; ++i) {
                    int height = mythicSpawnType.getMythicEntity() == null ? 2 : mythicSpawnType.getMythicEntity().getHeight();
                    AbstractLocation l = MobExecutor.findSafeSpawnLocation(target, this.noise, this.yNoise, height, this.yUpOnly, this.onSurface);
                    if (this.yaw != null) {
                        l.setYaw(this.yaw.get(data));
                    } else {
                        l.setYaw(data.getCaster().getLocation().getYaw());
                    }
                    if (this.pitch != null) {
                        l.setPitch(this.pitch.get(data));
                    } else {
                        l.setPitch(data.getCaster().getLocation().getPitch());
                    }
                    ActiveMob ams2 = mythicSpawnType.spawn(l, level, SpawnReason.SUMMON);
                    if (ams2 == null) continue;
                    ams2.getEntity().setVelocity(new AbstractVector((Numbers.randomDouble() - 0.5) * this.force, (Numbers.randomDouble() - 0.5) * this.yForce, (Numbers.randomDouble() - 0.5) * this.force));
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1}", this.strType, l.toString());
                    SkillCaster skillCaster = data.getCaster();
                    if (skillCaster instanceof ActiveMob) {
                        ActiveMob am = (ActiveMob)skillCaster;
                        if (this.summonerIsOwner) {
                            ams2.setParent(am);
                            ams2.setOwner(data.getCaster().getEntity().getUniqueId());
                        }
                        if (this.inheritFaction) {
                            ams2.setFaction(am.getFaction());
                        }
                        if (this.inheritDespawnOption) {
                            ams2.setDespawnMode(am.getDespawnMode());
                        }
                        if (am.hasThreatTable()) {
                            if (this.copyThreatTable) {
                                try {
                                    ams2.importThreatTable(am.getThreatTable().clone());
                                    ams2.getThreatTable().targetHighestThreat();
                                }
                                catch (CloneNotSupportedException e1) {
                                    e1.printStackTrace();
                                }
                            } else if (this.inheritThreatTable) {
                                ams2.importThreatTable(am.getThreatTable());
                                ams2.getThreatTable().targetHighestThreat();
                            }
                        }
                    } else if (this.summonerIsOwner) {
                        ams2.setParent(data.getCaster());
                        ams2.setOwner(data.getCaster().getEntity().getUniqueId());
                    }
                    if (!this.onSummonSkill.isPresent()) continue;
                    SkillMetadata summonData = data.deepClone();
                    data.getEntityTargets().clear();
                    summonData.setEntityTarget(ams2.getEntity());
                    this.onSummonSkill.get().execute(summonData);
                }
            } else {
                for (int i = 1; i <= amount; ++i) {
                    if (this.yaw != null) {
                        target.setYaw(this.yaw.get(data));
                    } else {
                        target.setYaw(data.getCaster().getLocation().getYaw());
                    }
                    if (this.pitch != null) {
                        target.setPitch(this.pitch.get(data));
                    } else {
                        target.setPitch(data.getCaster().getLocation().getPitch());
                    }
                    ActiveMob ams = mythicSpawnType.spawn(target, level, SpawnReason.SUMMON);
                    if (ams == null) continue;
                    ams.getEntity().setVelocity(new AbstractVector((Numbers.randomDouble() - 0.5) * this.force, (Numbers.randomDouble() - 0.5) * this.yForce, (Numbers.randomDouble() - 0.5) * this.force));
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1}", this.strType, target.toString());
                    SkillCaster ams2 = data.getCaster();
                    if (ams2 instanceof ActiveMob) {
                        ActiveMob am = (ActiveMob)ams2;
                        if (this.summonerIsOwner) {
                            ams.setParent(am);
                            ams.setOwner(data.getCaster().getEntity().getUniqueId());
                        }
                        if (this.inheritFaction) {
                            ams.setFaction(am.getFaction());
                        }
                        if (this.inheritDespawnOption) {
                            ams.setDespawnMode(am.getDespawnMode());
                        }
                        if (this.copyThreatTable) {
                            try {
                                ams.importThreatTable(am.getThreatTable().clone());
                                ams.getThreatTable().targetHighestThreat();
                            }
                            catch (CloneNotSupportedException e1) {
                                e1.printStackTrace();
                            }
                        } else if (this.inheritThreatTable) {
                            ams.importThreatTable(am.getThreatTable());
                            ams.getThreatTable().targetHighestThreat();
                        }
                    } else if (this.summonerIsOwner) {
                        ams.setParent(data.getCaster());
                        ams.setOwner(data.getCaster().getEntity().getUniqueId());
                    }
                    if (!this.onSummonSkill.isPresent()) continue;
                    SkillMetadata summonData = data.deepClone();
                    data.getEntityTargets().clear();
                    summonData.setEntityTarget(ams.getEntity());
                    this.onSummonSkill.get().execute(summonData);
                }
            }
            return SkillResult.SUCCESS;
        }
        if (bukkitEntityType != null) {
            if (this.noise > 0) {
                for (int i = 1; i <= amount; ++i) {
                    AbstractLocation l = MobExecutor.findSafeSpawnLocation(target, this.noise, this.yNoise, bukkitEntityType.getHeight(), this.yUpOnly, this.onSurface);
                    Entity entity = bukkitEntityType.spawn(BukkitAdapter.adapt(l), SpawnReason.SUMMON);
                    entity.setVelocity(new Vector((Numbers.randomDouble() - 0.5) * this.force, (Numbers.randomDouble() - 0.5) * this.yForce, (Numbers.randomDouble() - 0.5) * this.force));
                    if (this.onSummonSkill.isPresent()) {
                        SkillMetadata summonData = data.deepClone();
                        data.getEntityTargets().clear();
                        summonData.setEntityTarget(BukkitAdapter.adapt(entity));
                        this.onSummonSkill.get().execute(summonData);
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1} with noise", this.strType, l.toString());
                }
            } else {
                for (int i = 1; i <= amount; ++i) {
                    Entity entity = bukkitEntityType.spawn(BukkitAdapter.adapt(target), SpawnReason.SUMMON);
                    entity.setVelocity(new Vector((Numbers.randomDouble() - 0.5) * this.force, (Numbers.randomDouble() - 0.5) * this.yForce, (Numbers.randomDouble() - 0.5) * this.force));
                    if (this.onSummonSkill.isPresent()) {
                        SkillMetadata summonData = data.deepClone();
                        data.getEntityTargets().clear();
                        summonData.setEntityTarget(BukkitAdapter.adapt(entity));
                        this.onSummonSkill.get().execute(summonData);
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1}", this.strType, target.toString());
                }
            }
            return SkillResult.SUCCESS;
        }
        MythicLogger.error("SummonMechanic: Mob Type {0} not found", this.strType);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.castAtLocation(data, target.getLocation());
        return SkillResult.SUCCESS;
    }
}

