/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="stataura", aliases={"statbuff", "statdebuff"}, description="Applies a generic aura to the target")
public class StatAuraMechanic
extends Aura
implements ITargetedEntitySkill {
    private StatType stat;
    private StatModifierType modifier;
    private PlaceholderDouble modifierValue;

    public StatAuraMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        String statName = mlc.getString(new String[]{"stat", "s"}, null, new String[0]);
        if (statName == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "Stat is required");
            return;
        }
        String modifierType = mlc.getString(new String[]{"type", "t", "modifier", "mod", "m"}, StatModifierType.ADDITIVE.toString(), new String[0]);
        if (modifierType == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "Modifier type is required");
            return;
        }
        try {
            this.modifier = StatModifierType.get(modifierType.toUpperCase());
        }
        catch (Error | Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid modifier type specified!");
        }
        this.modifierValue = mlc.getPlaceholderDouble(new String[]{"value", "val", "v"}, 0.0, new String[0]);
        this.getManager().queueSecondPass(() -> {
            Optional<StatType> maybeStat = ((MythicBukkit)this.getPlugin()).getStatManager().getStat(statName);
            if (maybeStat.isEmpty()) {
                MythicLogger.errorMechanicConfig(this, mlc, "Stat not found!");
                return;
            }
            this.stat = maybeStat.get();
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer() && !((MythicBukkit)this.getPlugin()).getMobManager().isMythicMob(target)) {
            return SkillResult.INVALID_TARGET;
        }
        new Tracker(data, target);
        return SkillResult.SUCCESS;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable,
    StatSource {
        private final AbstractEntity target;
        private final Optional<StatRegistry> registry;
        private double value;
        private final SkillMetadata data;

        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)StatAuraMechanic.this, entity, data);
            this.target = entity;
            this.registry = ((MythicBukkit)StatAuraMechanic.this.getPlugin()).getStatManager().getStatRegistry(entity);
            this.value = StatAuraMechanic.this.modifierValue.get(data, entity) * (double)this.stacks;
            this.data = data;
            this.start();
        }

        @Override
        public void auraTick() {
            super.auraTick();
            if (StatAuraMechanic.this.modifierValue.isStatic()) {
                return;
            }
            double val = StatAuraMechanic.this.modifierValue.get(this.data, this.target) * (double)this.stacks;
            if (val != this.value) {
                this.value = val;
                this.registry.ifPresent(r -> r.putValue(StatAuraMechanic.this.stat, this, StatAuraMechanic.this.modifier, val));
            }
        }

        @Override
        public void auraStart() {
            this.executeAuraSkill(StatAuraMechanic.this.onStartSkill, this.skillMetadata);
            this.registry.ifPresent(r -> r.putValue(StatAuraMechanic.this.stat, this, StatAuraMechanic.this.modifier, this.value));
        }

        @Override
        public void auraStop() {
            this.registry.ifPresent(r -> r.removeValue(StatAuraMechanic.this.stat, this));
            this.executeAuraSkill(StatAuraMechanic.this.onEndSkill, this.skillMetadata);
        }
    }
}

