/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="setSkillCooldown", aliases={"skillCooldown", "setskillcd", "skillcd"}, description="Sets the cooldown on the given skill for the target")
public class SkillCooldownMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private Optional<Skill> skill;
    private PlaceholderDouble cooldown;

    public SkillCooldownMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        String skillName = mlc.getString(new String[]{"skill", "s"}, null, new String[0]);
        this.cooldown = mlc.getPlaceholderDouble(new String[]{"seconds", "sec", "time", "t"}, 0.0, new String[0]);
        this.getManager().queueSecondPass(() -> {
            if (skillName != null) {
                this.skill = this.getManager().getSkill(file, this, skillName);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.skill.isEmpty()) {
            return SkillResult.INVALID_CONFIG;
        }
        MetaSkill skill = (MetaSkill)this.skill.get();
        double cd2 = this.cooldown.get(data, target);
        if (target.isPlayer()) {
            PlayerData profile = ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(target.asPlayer());
            skill.setCooldown(profile, cd2);
        } else {
            ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(target);
            if (am != null) {
                skill.setCooldown(am, cd2);
            }
        }
        return SkillResult.SUCCESS;
    }
}

