/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="setname", description="Sets the casting mob's name")
public class SetNameMechanic
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill {
    private PlaceholderString name;

    public SetNameMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.name = mlc.getPlaceholderString(new String[]{"name", "n"}, null, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        SkillCaster skillCaster = data.getCaster();
        if (skillCaster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)skillCaster;
            String newName = this.name.get(data);
            am.setDisplayName(newName);
            if (CompatibilityManager.LibsDisguises != null && am.getType() != null && am.getType().getDisguise() != null) {
                CompatibilityManager.LibsDisguises.setDisguiseName(am.getEntity(), newName);
            }
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        SkillCaster skillCaster = data.getCaster();
        if (skillCaster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)skillCaster;
            String newName = this.name.get((PlaceholderMeta)data, target);
            am.setDisplayName(newName);
            if (CompatibilityManager.LibsDisguises != null && am.getType() != null && am.getType().getDisguise() != null) {
                CompatibilityManager.LibsDisguises.setDisguiseName(am.getEntity(), newName);
            }
        }
        return SkillResult.SUCCESS;
    }
}

