/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;

@MythicMechanic(author="Seyarada", name="setDisplayEntityItem", description="Sets the item component of Item Display entity")
public class SetDisplayEntityItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="item", aliases={"i", "type", "t", "material", "mat", "m"}, description="The item to use. If not set, the mechanic will remove the item from the entity instead.")
    private AbstractItemStack itemStack;

    public SetDisplayEntityItemMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        String itemString = mlc.getString(new String[]{"item", "i", "type", "t", "material", "mat", "m"}, "AIR", new String[0]);
        MythicBukkit.inst().getClock().queueSecondPass(() -> {
            this.itemStack = MythicBukkit.inst().getBootstrap().createItem(itemString);
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof ItemDisplay)) {
            return SkillResult.INVALID_TARGET;
        }
        ItemDisplay itemDisplay = (ItemDisplay)entity;
        itemDisplay.setItemStack(BukkitAdapter.adapt(this.itemStack));
        return SkillResult.SUCCESS;
    }
}

