/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@MythicMechanic(author="Ashijin", name="sendtoast", version="2.8", aliases={"advancementmessage", "advmessage", "toastmessage", "toastmsg"}, description="Sends a message to the target player as an advancement")
public class SendToastMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    protected PlaceholderString message;
    private String icon;
    private String iconnbt;
    private String frame;

    public SendToastMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.target_creative = true;
        try {
            this.message = PlaceholderString.of(mlc.getString(new String[]{"message", "msg", "m"}));
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.message = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            ex.printStackTrace();
        }
        this.icon = "minecraft:" + mlc.getString(new String[]{"icon", "i"}, "diamond_sword", new String[0]).toLowerCase();
        this.iconnbt = mlc.getString(new String[]{"iconnbt", "nbt"}, null, new String[0]);
        this.frame = mlc.getString(new String[]{"frame", "f"}, "challenge", new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            NamespacedKey id = new NamespacedKey((Plugin)MythicBukkit.inst(), "temp-" + UUID.randomUUID().toString());
            String advJSON = this.build(data, target);
            Bukkit.getUnsafe().loadAdvancement(id, advJSON);
            Player player = (Player)target.asPlayer().getBukkitEntity();
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)id);
            AdvancementProgress progress = player.getAdvancementProgress(advancement);
            if (!progress.isDone()) {
                for (String criteria : progress.getRemainingCriteria()) {
                    progress.awardCriteria(criteria);
                }
            }
            Schedulers.sync().runLater(() -> {
                if (progress.isDone()) {
                    for (String criteria : progress.getAwardedCriteria()) {
                        progress.revokeCriteria(criteria);
                    }
                }
                Bukkit.getUnsafe().removeAdvancement(id);
            }, 20L);
            return SkillResult.SUCCESS;
        }
        return SkillResult.INVALID_TARGET;
    }

    private String build(SkillMetadata data, AbstractEntity target) {
        JsonObject json = new JsonObject();
        JsonObject icon = new JsonObject();
        JsonObject display = new JsonObject();
        JsonObject criteria = new JsonObject();
        JsonObject trigger = new JsonObject();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            icon.addProperty("id", this.icon);
            if (this.iconnbt != null) {
                icon.addProperty("components", this.iconnbt);
            }
        } else {
            icon.addProperty("item", this.icon);
            if (this.iconnbt != null) {
                icon.addProperty("nbt", this.iconnbt);
            }
        }
        display.add("icon", (JsonElement)icon);
        display.addProperty("title", this.message.get((PlaceholderMeta)data, target));
        display.addProperty("description", "MythicMobs Toast Message");
        display.addProperty("background", "minecraft:textures/gui/advancements/backgrounds/adventure.png");
        display.addProperty("frame", this.frame);
        display.addProperty("announce_to_chat", Boolean.valueOf(false));
        display.addProperty("show_toast", Boolean.valueOf(true));
        display.addProperty("hidden", Boolean.valueOf(true));
        trigger.addProperty("trigger", "minecraft:impossible");
        criteria.add("impossible", (JsonElement)trigger);
        json.add("criteria", (JsonElement)criteria);
        json.add("display", (JsonElement)display);
        return gson.toJson((JsonElement)json);
    }
}

