/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@MythicMechanic(name="displaytransformation", aliases={"settransformation", "transformation"}, description="Sets the display entity's transformations")
public class DisplayTransformationMechanic
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill {
    @MythicField(name="action", aliases={"a"}, defValue="SET", description="The action to perform for the display entity's transformations. SET/ADD/MULTIPLY/DIVIDE")
    private final Action action;
    @MythicField(name="transformationType", aliases={"transformation", "type", "tt"}, defValue="TRANSLATION", description="The type of transformation to apply to the display entity. TRANSLATION/SCALE/RIGHT_ROTATION/LEFT_ROTATION")
    private final TransformationType transformationType;
    @MythicField(name="values", aliases={"value", "val"}, defValue="0,0,0", description="The values for the transformation.")
    private final List<PlaceholderFloat> values;

    public DisplayTransformationMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.action = mlc.getEnum(new String[]{"action", "a"}, Action.class, Action.SET);
        this.transformationType = mlc.getEnum(new String[]{"transformationtype", "transformation", "type", "tt"}, TransformationType.class, TransformationType.TRANSLATION);
        String[] values = mlc.getString(new String[]{"value", "val"}, "0,0,0", new String[0]).split(",");
        this.values = Arrays.stream(values).map(PlaceholderFloat::of).toList();
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!(target.getBukkitEntity() instanceof Display)) {
            return SkillResult.INVALID_TARGET;
        }
        this.applyTransformation(data, target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!(data.getCaster().getEntity().getBukkitEntity() instanceof Display)) {
            return SkillResult.INVALID_TARGET;
        }
        this.applyTransformation(data, data.getCaster().getEntity());
        return SkillResult.SUCCESS;
    }

    private void applyTransformation(SkillMetadata data, AbstractEntity target) {
        Display display = (Display)target.getBukkitEntity();
        Transformation current = display.getTransformation();
        List<Float> vals = this.values.stream().map(a -> Float.valueOf(a.get(data, target))).toList();
        Transformation transformation = switch (this.action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (this.transformationType.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new Transformation(new Vector3f(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getLeftRotation(), current.getScale(), current.getRightRotation());
                    }
                    case 1: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), new Vector3f(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getRightRotation());
                    }
                    case 2: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), current.getScale(), new Quaternionf(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue()));
                    }
                    case 3: 
                }
                yield new Transformation(current.getTranslation(), new Quaternionf(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue()), current.getScale(), current.getRightRotation());
            }
            case 1 -> {
                switch (this.transformationType.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new Transformation(current.getTranslation().add(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getLeftRotation(), current.getScale(), current.getRightRotation());
                    }
                    case 1: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), current.getScale().add(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getRightRotation());
                    }
                    case 2: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), current.getScale(), current.getRightRotation().add(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue()));
                    }
                    case 3: 
                }
                yield new Transformation(current.getTranslation(), current.getLeftRotation().add(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue()), current.getScale(), current.getRightRotation());
            }
            case 2 -> {
                switch (this.transformationType.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new Transformation(current.getTranslation().mul(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getLeftRotation(), current.getScale(), current.getRightRotation());
                    }
                    case 1: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), current.getScale().mul(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getRightRotation());
                    }
                    case 2: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), current.getScale(), current.getRightRotation().mul(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue()));
                    }
                    case 3: 
                }
                yield new Transformation(current.getTranslation(), current.getLeftRotation().mul(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue()), current.getScale(), current.getRightRotation());
            }
            case 3 -> {
                switch (this.transformationType.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new Transformation(current.getTranslation().div(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getLeftRotation(), current.getScale(), current.getRightRotation());
                    }
                    case 1: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), current.getScale().div(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue()), current.getRightRotation());
                    }
                    case 2: {
                        yield new Transformation(current.getTranslation(), current.getLeftRotation(), current.getScale(), current.getRightRotation().div((Quaternionfc)new Quaternionf(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue())));
                    }
                    case 3: 
                }
                yield new Transformation(current.getTranslation(), current.getLeftRotation().div((Quaternionfc)new Quaternionf(vals.get(0).floatValue(), vals.get(1).floatValue(), vals.get(2).floatValue(), vals.get(3).floatValue())), current.getScale(), current.getRightRotation());
            }
        };
        display.setInterpolationDelay(display.getInterpolationDelay());
        display.setTransformation(transformation);
    }

    public static enum Action {
        SET,
        ADD,
        MULTIPLY,
        DIVIDE;

    }

    public static enum TransformationType {
        TRANSLATION,
        SCALE,
        RIGHT_ROTATION,
        LEFT_ROTATION;

    }
}

