/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.event.entity.EntityDeathEvent;

@MythicMechanic(author="Ashijin", name="chain", version="4.8", description="Casts a metaskill that bounces between targets")
public class ChainMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected Skill onBounceSkill = null;
    @MythicField(name="onBounce", aliases={"ob"}, version="4.8", description="The skill that bounces between targets")
    protected String onBounceSkillName;
    @MythicField(name="bounces", aliases={"b"}, defValue="2", version="4.8", description="How many times the chain should bounce")
    protected PlaceholderInt bounces;
    @MythicField(name="delay", aliases={"d"}, defValue="1", version="4.8", description="The delay between bounces")
    protected PlaceholderInt bounceDelay;
    @MythicField(name="radius", aliases={"r"}, defValue="5", version="4.8", description="How far the skill will bounce to a new target")
    protected PlaceholderDouble bounceRadius;
    protected BounceSelector bounceSelector;
    @MythicField(name="hitSelf", aliases={"hs"}, defValue="false", version="4.8", description="Whether the chain should affect the caster")
    protected boolean hitSelf = false;
    @MythicField(name="hitTarget", aliases={"ht"}, defValue="true", version="4.8", description="Whether the chain should do the initial from the caster to the first target")
    protected boolean hitTarget = true;
    @MythicField(name="hitPlayers", aliases={"hp"}, defValue="true", version="4.8", description="Whether the chain should bounce to players")
    protected boolean hitPlayers = true;
    @MythicField(name="hitNonPlayers", aliases={"hnp"}, defValue="false", version="4.8", description="Whether the chain should bounce to non-players")
    protected boolean hitNonPlayers = false;
    protected String bounceConditionString;
    @MythicField(name="bounceConditions", aliases={"conditions", "cond", "c"}, defValue="NONE", version="4.8", description="Conditions applied to the bounce target")
    protected List<SkillCondition> bounceConditions = null;

    public ChainMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.onBounceSkillName = mlc.getString(new String[]{"onbounceskill", "onbounce", "ob", "ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.bounces = mlc.getPlaceholderInteger(new String[]{"bounces", "b"}, 2, new String[0]);
        this.bounceDelay = mlc.getPlaceholderInteger(new String[]{"bouncedelay", "bd", "delay", "interval", "i", "d"}, 1, new String[0]);
        this.bounceRadius = mlc.getPlaceholderDouble(new String[]{"bounceradius", "bouncerange", "radius", "range", "r"}, 5.0, new String[0]);
        this.hitSelf = mlc.getBoolean(new String[]{"hitself", "hs"}, false);
        this.hitPlayers = mlc.getBoolean(new String[]{"hitplayers", "hp"}, true);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, false);
        this.hitTarget = mlc.getBoolean(new String[]{"hittarget", "ht"}, true);
        this.bounceConditionString = mlc.getString(new String[]{"bounceconditions", "conditions", "cond", "c"}, "null", new String[0]);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (this.onBounceSkillName != null) {
                Optional<Skill> maybeSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(file, this, this.onBounceSkillName);
                if (!maybeSkill.isPresent()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "onBounce skill is required and was not found");
                    return;
                }
                this.onBounceSkill = maybeSkill.get();
                if (this.bounceConditionString != null) {
                    this.bounceConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.bounceConditionString);
                }
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new ChainTracker(data, target);
        return SkillResult.SUCCESS;
    }

    public class ChainTracker
    implements IParentSkill,
    Runnable,
    Terminable {
        protected final TerminableRegistry components = TerminableRegistry.create();
        protected SkillMetadata data;
        AbstractEntity currentBounce;
        UUID currentBounceUUID;
        AbstractLocation currentOrigin;
        protected final double bounceRadius;
        protected final double bounceRadiusSq;
        protected final int bounceDelay;
        protected int bouncesRemaining;
        protected float power;
        protected HashSet<AbstractEntity> potentialTargets = new HashSet();

        public ChainTracker(SkillMetadata data, AbstractEntity target) {
            this.data = data;
            this.data.setCallingEvent(this);
            this.power = data.getPower();
            this.currentBounce = data.getCaster().getEntity();
            this.currentBounceUUID = this.currentBounce.getUniqueId();
            this.currentOrigin = data.getCaster().getLocation();
            this.bouncesRemaining = ChainMechanic.this.bounces.get(data);
            this.bounceRadius = ChainMechanic.this.bounceRadius.get(data);
            this.bounceRadiusSq = Math.pow(this.bounceRadius, 2.0);
            this.bounceDelay = ChainMechanic.this.bounceDelay.get(data);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ Chain fired by Entity {0}: skill = {1}", data.getCaster().getEntity().getName(), ChainMechanic.this.line);
            this.start(target);
        }

        public void start(AbstractEntity target) {
            this.evaluatePotentialTargets();
            this.components.accept(Events.subscribe(EntityDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(this.currentBounceUUID)).handler(event -> {
                this.currentOrigin = this.currentBounce.getLocation();
                this.currentBounce = null;
            }));
            if (ChainMechanic.this.hitTarget) {
                this.executeChainSkill(target);
            } else {
                this.potentialTargets.remove(target);
                this.currentBounce = target;
                this.currentBounceUUID = target.getUniqueId();
                this.currentOrigin = target.getLocation();
            }
            if (this.potentialTargets.size() > 0) {
                this.components.accept(Schedulers.sync().runRepeating(this, (long)this.bounceDelay, (long)this.bounceDelay));
            } else {
                this.terminate();
            }
        }

        public boolean executeChainSkill(AbstractEntity target) {
            if (ChainMechanic.this.onBounceSkill == null || target == null) {
                return true;
            }
            this.data = this.data.deepClone();
            this.data.setEntityTarget(target);
            this.data.setOrigin(this.currentOrigin);
            this.potentialTargets.remove(target);
            if (ChainMechanic.this.onBounceSkill.isUsable(this.data)) {
                VariableRegistry vars = this.data.getVariables();
                vars.putInt("chain-bounces", this.bouncesRemaining);
                ChainMechanic.this.onBounceSkill.execute(this.data);
                this.currentBounce = target;
                this.currentBounceUUID = target.getUniqueId();
                this.currentOrigin = target.getLocation();
                return true;
            }
            return false;
        }

        @Override
        public void close() {
            if (!this.components.hasTerminated()) {
                this.potentialTargets.clear();
            }
            this.components.terminate();
        }

        @Override
        public void run() {
            AbstractEntity nextTarget = this.getNextTarget();
            if (nextTarget != null && this.executeChainSkill(nextTarget)) {
                if (--this.bouncesRemaining <= 0) {
                    this.terminate();
                }
            } else {
                this.terminate();
            }
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }

        private void evaluatePotentialTargets() {
            double maxDistance = Math.pow(this.bounceRadius * (double)this.bouncesRemaining * 2.0, 2.0);
            if (ChainMechanic.this.hitSelf || ChainMechanic.this.hitPlayers || ChainMechanic.this.hitNonPlayers) {
                this.potentialTargets.addAll(this.data.getCaster().getLocation().getWorld().getLivingEntities());
                this.potentialTargets.removeIf(e -> {
                    if (e == null) {
                        return true;
                    }
                    if (this.currentOrigin.distanceSquared(e.getLocation()) > maxDistance) {
                        return true;
                    }
                    if (!e.isLiving() || e.isCitizensNPC()) {
                        return true;
                    }
                    if (!ChainMechanic.this.hitSelf && e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!ChainMechanic.this.hitPlayers && e.isPlayer()) {
                        return true;
                    }
                    return !ChainMechanic.this.hitNonPlayers && !e.isPlayer();
                });
            }
        }

        private AbstractEntity getNextTarget() {
            if (this.currentBounce == null) {
                return null;
            }
            AbstractEntity target = null;
            double range = 0.0;
            for (AbstractEntity entity : this.potentialTargets) {
                double nextRange;
                AbstractLocation origin;
                if (entity == null || !(origin = this.currentBounce != null ? this.currentBounce.getLocation() : this.currentOrigin).getWorld().equals(entity.getLocation().getWorld()) || (nextRange = origin.distanceSquared(entity.getLocation())) > this.bounceRadiusSq) continue;
                if (ChainMechanic.this.bounceConditions != null) {
                    boolean ok = true;
                    for (SkillCondition condition : ChainMechanic.this.bounceConditions) {
                        if (condition.evaluateToEntity(this.currentBounce, entity)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                }
                if (target == null) {
                    target = entity;
                    range = this.currentBounce.getLocation().distanceSquared(entity.getLocation());
                    continue;
                }
                if (!(nextRange < range)) continue;
                target = entity;
                range = nextRange;
            }
            return target;
        }

        public void modifyPower(float p) {
            this.power *= p;
        }

        public AbstractEntity getCurrentBounce() {
            return this.currentBounce;
        }

        public UUID getCurrentBounceUUID() {
            return this.currentBounceUUID;
        }

        public AbstractLocation getCurrentOrigin() {
            return this.currentOrigin;
        }

        public double getBounceRadius() {
            return this.bounceRadius;
        }

        public double getBounceRadiusSq() {
            return this.bounceRadiusSq;
        }

        public int getBounceDelay() {
            return this.bounceDelay;
        }

        public int getBouncesRemaining() {
            return this.bouncesRemaining;
        }

        public float getPower() {
            return this.power;
        }
    }

    public static enum BounceSelector {
        RANDOM,
        CLOSEST,
        FURTHEST;

    }
}

