/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="jaylawl", name="wearing", aliases={"iswearing", "wielding", "iswielding"}, version="4.5", description="Tests what the target entity has equipped.")
public class WearingCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="armorslot", aliases={"slot", "s"}, description="The item slot to check", defValue="HEAD")
    private EquipSlot slot;
    @MythicField(name="material", aliases={"mmitem", "m"}, description="A material or MythicItem name to check for")
    private BukkitItemStack item;
    private final Collection<AbstractItemStack> items;

    public WearingCondition(String line, MythicLineConfig mlc) {
        super(line);
        String s2 = mlc.getString(new String[]{"armorslot", "slot", "s"}, "HEAD", new String[0]).toUpperCase();
        String item = mlc.getString(new String[]{"material", "mat", "m", "mythicmobsitem", "mmitem", "mmi", "item"}, "DIRT", this.conditionVar);
        this.slot = EquipSlot.of(s2);
        this.items = BukkitItemStack.getMatches(item);
    }

    @Override
    public boolean check(AbstractEntity e) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking WEARING Condition...", new Object[0]);
        if (this.slot == EquipSlot.NONE) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Invalid slot supplied", new Object[0]);
            return false;
        }
        AbstractItemStack slotitem = this.slot.get(e).orElse(null);
        slotitem = slotitem == null ? BukkitAdapter.adapt(new ItemStack(Material.AIR)) : slotitem;
        for (AbstractItemStack bukkitItemStack : this.items) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "| Check {0} == {1}", bukkitItemStack.toString(), slotitem.toString());
            if (!bukkitItemStack.isSimilar(slotitem)) continue;
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "+ Items are similar, returning true", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "+ Items are not similar, returning false", new Object[0]);
        return false;
    }
}

