/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;

@MythicCondition(author="Ashijin", name="spawnReason", description="Checks the target's spawn reason.")
public class SpawnReasonCondition
extends SkillCondition
implements IEntityCondition {
    private CreatureSpawnEvent.SpawnReason reason;

    public SpawnReasonCondition(String line, MythicLineConfig mlc) {
        super(line);
        String strReason = mlc.getString(new String[]{"reason", "r"}, this.conditionVar, new String[0]);
        try {
            this.reason = CreatureSpawnEvent.SpawnReason.valueOf((String)strReason);
        }
        catch (Throwable ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Invalid SpawnReason supplied for condition");
            this.reason = null;
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (target.isPlayer()) {
            return false;
        }
        Entity bukkitEntity = target.getBukkitEntity();
        CreatureSpawnEvent.SpawnReason spawnReason = bukkitEntity.getEntitySpawnReason();
        if (spawnReason == null) {
            return false;
        }
        return spawnReason == this.reason;
    }
}

