/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import java.util.List;

@MythicCondition(author="Ashijin", name="onBlock", aliases={}, description="Matches the block the target entity is standing on")
public class OnBlockCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="material", aliases={"m"}, description="A list of materials")
    private Collection<AbstractBlock> types = Sets.newHashSet();

    public OnBlockCondition(String line, MythicLineConfig mlc) {
        super(line);
        List<String> materials = mlc.getStringList(new String[]{"types", "type", "t", "material", "mat", "m", "block", "b"}, "STONE");
        for (String s2 : materials) {
            try {
                AbstractBlock block = OnBlockCondition.getPlugin().getBootstrap().getBlock(s2);
                if (block instanceof AbstractBlock.InvalidBlock) {
                    MythicLogger.errorConditionConfig(this, mlc, "'" + s2 + "' is not a valid block type.");
                    return;
                }
                this.types.add(block);
            }
            catch (Exception ex) {
                MythicLogger.errorConditionConfig(this, mlc, "'" + s2 + "' is not a valid Material");
            }
        }
    }

    @Override
    public boolean check(AbstractLocation target) {
        AbstractLocation location = target.clone().subtract(0.0, 0.1, 0.0);
        for (AbstractBlock type : this.types) {
            if (!type.matches(location)) continue;
            return true;
        }
        return false;
    }
}

