/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@MythicCondition(author="Ashijin", name="mythicMobType", aliases={"mmType"}, description="Checks the MythicMob type of the target mob")
public class MythicMobTypeCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="type", aliases={"types", "t"}, description="A list of MythicMob types")
    private Set<String> types = new HashSet<String>();

    public MythicMobTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String types = mlc.getString(new String[]{"types", "type", "t"}, this.conditionVar, new String[0]);
        String[] split = types.split(",");
        this.types.addAll(Arrays.asList(split));
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (MythicBukkit.inst().getMobManager().isActiveMob(entity)) {
            ActiveMob am = MythicMobTypeCondition.getPlugin().getMobManager().getMythicMobInstance(entity);
            return this.types.contains(am.getType().getInternalName());
        }
        return false;
    }
}

