/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

@MythicCondition(author="Seyarada", name="lookingAt", description="Checks if the player is looking at something")
public class LookingAtCondition
extends SkillCondition
implements IEntityCondition {
    private final String thing;

    public LookingAtCondition(String line, MythicLineConfig config) {
        super(line);
        this.thing = config.getString(new String[]{"block", "b", "entity", "e", "type", "t"}, null, new String[0]);
    }

    @Override
    public boolean check(AbstractEntity target) {
        Entity targetEntity;
        Material blockType;
        Block targetBlock;
        if (!target.isPlayer()) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Target is not a player, returning false", new Object[0]);
            return false;
        }
        if (this.thing == null) {
            return false;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        RayTraceResult blockRayTraceResult = player.getWorld().rayTraceBlocks(player.getEyeLocation(), player.getLocation().getDirection(), 5.0);
        if (blockRayTraceResult != null && (targetBlock = blockRayTraceResult.getHitBlock()) != null && LookingAtCondition.matches((blockType = targetBlock.getType()).toString(), this.thing)) {
            return true;
        }
        RayTraceResult entityRayTraceResult = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getLocation().getDirection(), 5.0, e -> e != player);
        if (entityRayTraceResult != null && (targetEntity = entityRayTraceResult.getHitEntity()) != null) {
            EntityType entityType = targetEntity.getType();
            return LookingAtCondition.matches(entityType.toString(), this.thing);
        }
        return false;
    }

    public static boolean matches(String obj, String wantType) {
        wantType = wantType.toUpperCase();
        switch (wantType.charAt(0)) {
            case '#': {
                if (!obj.contains(wantType.substring(1))) break;
                return true;
            }
            case '@': {
                if (!obj.startsWith(wantType.substring(1))) break;
                return true;
            }
            default: {
                try {
                    if (Material.valueOf((String)wantType) == Material.valueOf((String)obj)) {
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    if (EntityType.valueOf((String)wantType) == EntityType.valueOf((String)obj)) {
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return false;
            }
        }
        return false;
    }
}

