/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.conditions.ICasterCondition;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="level", aliases={}, description="Checks the target MythicMob's level")
public class LevelCondition
extends SkillCondition
implements ICasterCondition,
IEntityCondition {
    @MythicField(name="level", aliases={"l"}, description="The level range to match")
    private final RangedDouble data;

    public LevelCondition(String line, MythicLineConfig config) {
        super(line);
        this.data = new RangedDouble(config.getString(new String[]{"level", "l"}, this.conditionVar, new String[0]));
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (LevelCondition.getPlugin().getMobManager().isActiveMob(target)) {
            ActiveMob am = LevelCondition.getPlugin().getMobManager().getMythicMobInstance(target);
            return this.data.equals(am.getLevel());
        }
        return true;
    }

    @Override
    public boolean check(SkillCaster caster) {
        return this.data.equals(caster.getLevel());
    }
}

