/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import java.util.Optional;

@MythicCondition(author="Ashijin", name="holding", aliases={}, description="Checks if the target is holding a given material")
public class HoldingCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="material", aliases={"m", "type", "t"}, description="The material type to match")
    private final Collection<AbstractItemStack> comparisons;

    public HoldingCondition(String line, MythicLineConfig mlc) {
        super(line);
        String materialString = mlc.getString(new String[]{"material", "m", "item", "i", "type", "t"}, "DIRT", this.conditionVar);
        this.comparisons = BukkitItemStack.getMatches(materialString);
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (!target.isLiving()) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Target is not living entity", new Object[0]);
            return false;
        }
        Optional<AbstractItemStack> maybeItem = target.getItemMainHand();
        if (maybeItem.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "No item in hand", new Object[0]);
            return false;
        }
        AbstractItemStack holding = maybeItem.get();
        for (AbstractItemStack item : this.comparisons) {
            if (!item.isSimilar(holding)) continue;
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Held item not similar", new Object[0]);
        return false;
    }
}

