/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.volatilecode.VolatileEntityType;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Ashijin", name="entityItemType", description="Tests the item type of the target item entity")
public class EntityItemTypeCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="material", aliases={"mat", "m", "type", "types", "t"}, description="A list of item types to match")
    protected List<MatchedItem> materials = Lists.newArrayList();

    public EntityItemTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String entityTypesStringList = mlc.getString(new String[]{"material", "mat", "m", "type", "types", "t"}, null, this.conditionVar);
        if (entityTypesStringList != null) {
            for (String entityTypeString : entityTypesStringList.split(",")) {
                try {
                    this.materials.add(new MatchedItem(this, entityTypeString));
                }
                catch (Exception exception) {
                    MythicLogger.errorConditionConfig(this, mlc, "Couldn't parse \"" + entityTypeString + "\" as an item!");
                }
            }
        }
    }

    @Override
    public boolean check(AbstractEntity targetEntity) {
        Entity entity = targetEntity.getBukkitEntity();
        if (entity.getType() != VolatileEntityType.ITEM) {
            return false;
        }
        Item item = (Item)entity;
        for (MatchedItem mi : this.materials) {
            if (!mi.check(item)) continue;
            return true;
        }
        return false;
    }

    private class MatchedItem {
        private final Material material;
        private final int model;

        public MatchedItem(EntityItemTypeCondition entityItemTypeCondition, String itemString) {
            if (itemString.contains(":")) {
                String[] split = itemString.split(":");
                this.material = Material.matchMaterial((String)split[0]);
                this.model = Numbers.parseInteger(split[1]).orElse(0);
            } else {
                this.material = Material.matchMaterial((String)itemString);
                this.model = 0;
            }
        }

        public boolean check(Item itemEntity) {
            if (this.model == 0) {
                return this.material == itemEntity.getItemStack().getType();
            }
            ItemStack stack = itemEntity.getItemStack();
            if (!stack.hasItemMeta()) {
                return false;
            }
            if (this.material != stack.getType()) {
                return false;
            }
            return stack.getItemMeta().getCustomModelData() == this.model;
        }

        public Material getMaterial() {
            return this.material;
        }

        public int getModel() {
            return this.model;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchedItem)) {
                return false;
            }
            MatchedItem other = (MatchedItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getModel() != other.getModel()) {
                return false;
            }
            Material this$material = this.getMaterial();
            Material other$material = other.getMaterial();
            return !(this$material == null ? other$material != null : !this$material.equals(other$material));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MatchedItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getModel();
            Material $material = this.getMaterial();
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            return result;
        }

        public String toString() {
            return "EntityItemTypeCondition.MatchedItem(material=" + String.valueOf(this.getMaterial()) + ", model=" + this.getModel() + ")";
        }
    }
}

