/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.auras;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.core.skills.auras.Aura;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;

public class AuraRegistry {
    private final UUID holder;
    private Map<String, Queue<Aura.AuraTracker>> auras = Maps.newConcurrentMap();
    private long lastAction = System.currentTimeMillis();

    public AuraRegistry(UUID uuid) {
        this.holder = uuid;
    }

    public void registerAura(String name, Aura.AuraTracker buff) {
        this.auras.compute(name, (key, value) -> {
            if (value == null) {
                value = new LinkedList<Aura.AuraTracker>();
            }
            value.add(buff);
            return value;
        });
    }

    public boolean mergeAura(String name, Aura.AuraTracker buff, boolean sameCasterOnly) {
        boolean merged = false;
        if (!this.auras.containsKey(name)) {
            this.auras.put(name, new LinkedList());
        }
        Queue<Aura.AuraTracker> value = this.auras.get(name);
        Aura.AuraTracker find = null;
        if (value.size() > 0) {
            if (sameCasterOnly) {
                for (Aura.AuraTracker t2 : value) {
                    if (!t2.getCasterUUID().equals(buff.getCasterUUID())) continue;
                    find = t2;
                    break;
                }
            } else {
                find = value.peek();
            }
        }
        if (find != null) {
            merged = true;
            find.merge(buff);
        } else {
            value.add(buff);
        }
        return merged;
    }

    public void unregisterAura(String name, Aura.AuraTracker buff) {
        Queue<Aura.AuraTracker> collection = this.auras.get(name);
        if (collection == null) {
            return;
        }
        this.auras.get(name).remove(buff);
        if (collection.isEmpty()) {
            this.auras.remove(name);
        }
    }

    public boolean hasAura(String name) {
        if (this.auras.containsKey(name)) {
            return this.auras.get(name).size() > 0;
        }
        return false;
    }

    public boolean hasAuraType(String name) {
        for (Queue<Aura.AuraTracker> aura : this.auras.values()) {
            for (Aura.AuraTracker entry : aura) {
                if (!entry.getGroup().isPresent() || !entry.getGroup().get().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public int getStacks(String name) {
        Queue<Aura.AuraTracker> q;
        if (this.auras.containsKey(name) && (q = this.auras.get(name)).size() > 0) {
            return q.stream().mapToInt(Aura.AuraTracker::getStacks).sum();
        }
        return 0;
    }

    public void removeStack(String buffName, int a) {
        if (this.auras.containsKey(buffName)) {
            Queue<Aura.AuraTracker> queue = this.auras.get(buffName);
            int leftToRemove = a;
            ArrayList toRemove = Lists.newArrayList();
            for (Aura.AuraTracker tracker : queue) {
                if (tracker.getStacks() <= leftToRemove) {
                    leftToRemove -= tracker.getStacks();
                    tracker.terminateFromRegistry();
                    toRemove.add(tracker);
                } else {
                    tracker.setStacks(tracker.getStacks() - leftToRemove);
                    leftToRemove = 0;
                }
                if (leftToRemove > 0) continue;
                break;
            }
            queue.removeAll(toRemove);
        }
    }

    public void removeStacksOfType(String type, int a) {
        for (Queue<Aura.AuraTracker> queue : this.auras.values()) {
            int leftToRemove = a;
            ArrayList toRemove = Lists.newArrayList();
            for (Aura.AuraTracker tracker : queue) {
                if (tracker.getGroup().isPresent() && tracker.getGroup().get().equals(type)) {
                    if (tracker.getStacks() <= leftToRemove) {
                        leftToRemove -= tracker.getStacks();
                        tracker.terminateFromRegistry();
                        toRemove.add(tracker);
                    } else {
                        tracker.setStacks(tracker.getStacks() - leftToRemove);
                        leftToRemove = 0;
                    }
                }
                if (leftToRemove > 0) continue;
                break;
            }
            queue.removeAll(toRemove);
            if (leftToRemove > 0) continue;
            break;
        }
    }

    public void removeAll(String buffName) {
        if (this.auras.containsKey(buffName)) {
            Queue<Aura.AuraTracker> queue = this.auras.get(buffName);
            queue.forEach(tracker -> tracker.terminateFromRegistry());
            queue.clear();
        }
    }

    public void removeAllOfType(String type) {
        for (Queue<Aura.AuraTracker> aura : this.auras.values()) {
            aura.removeIf(entry -> {
                if (entry.getGroup().isPresent() && entry.getGroup().get().equals(type)) {
                    entry.terminateFromRegistry();
                    return true;
                }
                return false;
            });
        }
    }

    public UUID getHolder() {
        return this.holder;
    }

    public Map<String, Queue<Aura.AuraTracker>> getAuras() {
        return this.auras;
    }
}

