/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillManager;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.targeters.IEntityTargeter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.files.Files;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.EventExecutor;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.audience.CustomAudience;
import io.lumine.mythic.core.skills.audience.TargeterAudience;
import io.lumine.mythic.core.skills.auras.AuraManager;
import io.lumine.mythic.core.skills.conditions.CompositeCondition;
import io.lumine.mythic.core.skills.conditions.CustomCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.mechanics.CustomMechanic;
import io.lumine.mythic.core.skills.mechanics.MetaSkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.targeters.ConsoleTargeter;
import io.lumine.mythic.core.skills.targeters.CustomTargeter;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.skills.targeters.LivingInWorldTargeter;
import io.lumine.mythic.core.skills.targeters.LivingNearTargetLocationTargeter;
import io.lumine.mythic.core.skills.targeters.LocationTargeter;
import io.lumine.mythic.core.skills.targeters.MPEntity;
import io.lumine.mythic.core.skills.targeters.MPLocation;
import io.lumine.mythic.core.skills.targeters.MPMeta;
import io.lumine.mythic.core.skills.targeters.MobsInRadiusTargeter;
import io.lumine.mythic.core.skills.targeters.MobsNearOriginTargeter;
import io.lumine.mythic.core.skills.targeters.NearestPlayerTargeter;
import io.lumine.mythic.core.skills.targeters.PassengerTargeter;
import io.lumine.mythic.core.skills.targeters.PlayerLocationsInRadiusTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersInRingTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersInWorldTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersNearOriginTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersNearTargetLocationsTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersOnServerTargeter;
import io.lumine.mythic.core.skills.targeters.ThreatTablePlayersTargeter;
import io.lumine.mythic.core.skills.targeters.ThreatTableRandomTargeter;
import io.lumine.mythic.core.skills.targeters.ThreatTableTargeter;
import io.lumine.mythic.core.skills.targeters.TriggerLocationTargeter;
import io.lumine.mythic.core.skills.targeters.VanillaTargeter;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicAudience;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SkillExecutor
extends ReloadableModule<MythicBukkit>
implements SkillManager {
    private static final Map<String, Class<? extends SkillCondition>> CONDITIONS = new ConcurrentHashMap<String, Class<? extends SkillCondition>>();
    private static final Map<String, Class<? extends SkillMechanic>> MECHANICS = new ConcurrentHashMap<String, Class<? extends SkillMechanic>>();
    private static final Map<String, Class<? extends SkillTargeter>> TARGETERS = new ConcurrentHashMap<String, Class<? extends SkillTargeter>>();
    private static final Map<String, Class<? extends SkillAudience>> AUDIENCES = new ConcurrentHashMap<String, Class<? extends SkillAudience>>();
    private List<File> skillFiles;
    private IOLoader<MythicBukkit> defaultSkills;
    private List<IOLoader<MythicBukkit>> skillLoaders;
    private Map<String, Skill> skills = Maps.newConcurrentMap();
    private AuraManager auraManager;
    private EventExecutor eventBus;

    public SkillExecutor(MythicBukkit core) {
        super(core, false);
        this.loadSkillComponents();
        this.load(core);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.auraManager = new AuraManager((MythicBukkit)this.getPlugin(), this);
        this.eventBus = new EventExecutor((MythicBukkit)this.getPlugin(), this);
        SkillExecutor.loadMechanics();
    }

    @Override
    public void unload() {
        this.auraManager.shutdown();
        Projectile.BULLET_ENTITIES.forEach(AbstractEntity::remove);
    }

    public void loadSkills() {
        MythicLogger.log("Loading Skills...");
        this.defaultSkills = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleSkills.yml", "Skills");
        this.skillFiles = IOHandler.getAllFiles(this.defaultSkills.getFile().getParent());
        this.skills.clear();
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            for (File folder : pack.getPackFolders("Skills", true)) {
                for (File file : Files.getAll(folder.getAbsolutePath(), Lists.newArrayList((Object[])new String[]{"yml", "txt"}))) {
                    MythicConfigImpl fileConfig = new MythicConfigImpl(file);
                    for (String node : NodeListProp.getNodes(file, "")) {
                        try {
                            MythicConfig config = fileConfig.getNestedConfig(node);
                            MetaSkill ms = new MetaSkill(this, pack, file, node, config);
                            this.skills.put(node, ms);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("Error loading skill '" + node + "'. Enable debugging for a stack trace.");
                            MythicLogger.handleMinorError(ex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void queueAfterLoad(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueAfterLoad(r);
    }

    @Override
    public void queueSecondPass(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueSecondPass(r);
    }

    @Override
    public SkillCaster getCaster(AbstractEntity entity) {
        Optional<SkillCaster> maybeFurniture;
        if (entity.isPlayer()) {
            return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer());
        }
        ActiveMob maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity);
        if (maybeMob != null) {
            return maybeMob;
        }
        if (((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().isPresent() && (maybeFurniture = ((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().get().getFurnitureCaster(entity)).isPresent()) {
            return maybeFurniture.get();
        }
        return new GenericCaster(entity);
    }

    public SkillCaster getCasterNullable(AbstractEntity entity) {
        if (entity.isPlayer()) {
            return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer());
        }
        ActiveMob maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity);
        if (maybeMob != null) {
            return maybeMob;
        }
        return null;
    }

    @Override
    public void registerSkill(String internalName, Skill skill) {
        this.skills.put(internalName, skill);
    }

    @Override
    public Optional<Skill> getSkill(String internalName) {
        return this.getSkill(null, internalName);
    }

    @Override
    public Optional<Skill> getSkill(File file, String internalName) {
        return this.getSkill(null, null, internalName);
    }

    @Override
    public Optional<Skill> getSkill(File file, SkillHolder parent, String internalName) {
        if (internalName == null) {
            return Optional.empty();
        }
        if ((internalName = internalName.trim()).startsWith("[") && internalName.endsWith("]")) {
            internalName = internalName.substring(1, internalName.length() - 1);
            internalName = MythicLineConfigImpl.unparseBlock(internalName);
            String uncommentedLines = internalName.replaceAll("<#> *-.*?(?=<#>|-|$)", "");
            String[] split = uncommentedLines.split("-");
            List<String> elements = Arrays.stream(split).map(String::trim).filter(trim -> trim.length() != 0).collect(Collectors.toList());
            MetaSkill skill = new MetaSkill(this, file, elements);
            String skillName = skill.getInternalName();
            if (parent != null) {
                skill.addParent(parent);
                skill.setPack(parent.getPack());
            }
            this.skills.put(skillName, skill);
            skill.setInlineSkill(true);
            return Optional.of(skill);
        }
        if (this.skills.containsKey(internalName)) {
            return Optional.of(this.skills.get(internalName));
        }
        return Optional.empty();
    }

    public Optional<Skill> getSkill(File file, Collection<String> elements) {
        MetaSkill skill = new MetaSkill(this, file, elements);
        String skillName = skill.getInternalName();
        this.skills.put(skillName, skill);
        skill.setInlineSkill(true);
        return Optional.of(skill);
    }

    public MetaSkillMechanic getWrappedSkill(File file, Collection<String> elements) {
        Optional<Skill> maybeSkill = this.getSkill(file, elements);
        Skill skill = maybeSkill.get();
        return new MetaSkillMechanic(this, file, skill);
    }

    @Override
    public Collection<String> getSkillNames() {
        return this.skills.keySet();
    }

    @Override
    public Collection<Skill> getSkills() {
        return this.skills.values();
    }

    public void runTimerSkills(long timer) {
        for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
            if (am == null || am.getEntity() == null || am.getType() == null) continue;
            am.tick(timer, ((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain());
            if (am.isDead() || am.getEntity() == null || !am.getEntity().isValid() || !am.getType().isUsingTimers()) continue;
            this.executeMobTimerSkills(am, timer);
            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "---- Executed TIMER skills", new Object[0]);
        }
    }

    public void executeMobTimerSkills(ActiveMob am, long timer) {
        SkillMetadataImpl data = new SkillMetadataImpl(SkillTriggers.TIMER, am, null);
        data.setPower(am.getPower());
        for (SkillMechanic skill : am.getType().getTimerSkills()) {
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSkillNew(am.getType().getInternalName() + ":" + skill.line);
            if ((double)timer % ((double)skill.interval / (double)((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain()) == 0.0 && skill.isUsableFromCaster(data)) {
                skill.execute(data);
            }
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSkillComplete(am.getType().getInternalName() + ":" + skill.line);
        }
    }

    public ImmutableMap<String, Class<? extends SkillMechanic>> getMechanics() {
        return ImmutableMap.copyOf(MECHANICS);
    }

    private static void loadMechanics() {
    }

    @Override
    public SkillMechanic getMechanic(String skill) {
        return this.getMechanic(null, skill);
    }

    public SkillMechanic getMechanic(File file, String skill) {
        return this.getMechanic(null, file, null, skill);
    }

    public SkillMechanic getMechanic(Pack pack, File file, SkillHolder parent, String skill) {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Matching mechanic to string: {0}", skill);
        String[] s2 = skill.split(" ");
        String name = null;
        MythicLineConfigImpl mlc = file != null ? new MythicLineConfigImpl(file, s2[0]) : new MythicLineConfigImpl(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Matching MythicSkill type to {0}", name.toUpperCase());
        if (MECHANICS.containsKey(name.toUpperCase())) {
            Class<? extends SkillMechanic> clazz = MECHANICS.get(name.toUpperCase());
            try {
                SkillMechanic mechanic = clazz.getConstructor(SkillExecutor.class, File.class, String.class, MythicLineConfig.class).newInstance(this, file, skill, mlc);
                mechanic.setPack(pack);
                mechanic.setParent(parent);
                return mechanic;
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct mechanic {0}", skill);
                e.printStackTrace();
            }
        }
        try {
            if (name.toUpperCase().startsWith("SKILL:") || name.toUpperCase().startsWith("META:")) {
                String skillName = name.split(":")[1];
                MetaSkillMechanic mechanic = new MetaSkillMechanic(this, file, skill, skillName, mlc);
                mechanic.setPack(pack);
                mechanic.setParent(parent);
                return mechanic;
            }
            CustomMechanic mechanic = new CustomMechanic(this, file, name.toUpperCase(), skill, mlc);
            mechanic.setPack(pack);
            mechanic.setParent(parent);
            return mechanic;
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to load skill line due to bad syntax: {0} ", skill);
            MythicLogger.handleMinorError(ex);
            return null;
        }
    }

    public File getSchematic(String schematicName) {
        String[] externalSchematicFolders;
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            File schematicFolder = pack.getSchematicDirectory();
            File schematicFile = new File(schematicFolder, schematicName);
            if (!schematicFile.exists()) continue;
            return schematicFile;
        }
        File pluginsFolder = MythicBukkit.inst().getDataFolder().getParentFile();
        for (String externalFolder : externalSchematicFolders = new String[]{"FastAsyncWorldEdit", "WorldEdit"}) {
            File schematicFile = new File(pluginsFolder, externalFolder + "/schematics/" + schematicName);
            if (!schematicFile.exists()) continue;
            return schematicFile;
        }
        return null;
    }

    public ImmutableMap<String, Class<? extends SkillTargeter>> getTargeters() {
        return ImmutableMap.copyOf(TARGETERS);
    }

    @Override
    public SkillTargeter getTargeter(String search, MythicLineConfig mlc) {
        if (search == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicTargeter type to " + search, new Object[0]);
        ImmutableMap<String, Class<? extends SkillTargeter>> TARGETERS = ((MythicBukkit)this.getPlugin()).getSkillManager().getTargeters();
        if (TARGETERS.containsKey(search.toUpperCase())) {
            Class clazz = (Class)TARGETERS.get(search.toUpperCase());
            try {
                return (SkillTargeter)clazz.getConstructor(SkillExecutor.class, MythicLineConfig.class).newInstance(this, mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct targeter {0}", search);
                e.printStackTrace();
            }
        }
        switch (search.toUpperCase()) {
            case "LIVINGINWORLD": 
            case "ENTITIESINWORLD": 
            case "LIVINGENTITIESINWORLD": 
            case "ALLINWORLD": 
            case "EIW": {
                return new LivingInWorldTargeter(this, mlc);
            }
            case "LIVINGNEARTARGETLOCATION": 
            case "LNTL": 
            case "LIVINGENTITIESNEARTARGETLOCATION": {
                return new LivingNearTargetLocationTargeter(this, mlc);
            }
            case "LOCATION": 
            case "LOC": 
            case "L": {
                return new LocationTargeter(this, mlc);
            }
            case "MOBSINRADIUS": 
            case "MOBS": 
            case "MIR": {
                return new MobsInRadiusTargeter(this, mlc);
            }
            case "NEARESTPLAYER": {
                return new NearestPlayerTargeter(this, mlc);
            }
            case "PASSENGER": 
            case "RIDER": {
                return new PassengerTargeter(this, mlc);
            }
            case "PLAYERSNEARTARGETLOCATION": 
            case "PNTL": {
                return new PlayersNearTargetLocationsTargeter(this, mlc);
            }
            case "PLAYERLOCATIONSSINRADIUS": 
            case "LOCATIONRADIUS": 
            case "PLR": 
            case "PLIR": {
                return new PlayerLocationsInRadiusTargeter(this, mlc);
            }
            case "PLAYERSINRING": 
            case "PRING": {
                return new PlayersInRingTargeter(this, mlc);
            }
            case "PLAYERSINWORLD": 
            case "WORLD": {
                return new PlayersInWorldTargeter(this, mlc);
            }
            case "PLAYERSONSERVER": 
            case "SERVER": {
                return new PlayersOnServerTargeter(this, mlc);
            }
            case "THREATTABLE": 
            case "THREATTARGETS": 
            case "TT": {
                return new ThreatTableTargeter(this, mlc);
            }
            case "THREATTABLEPLAYERS": 
            case "PLAYERSINTHREATTABLE": 
            case "TTP": {
                return new ThreatTablePlayersTargeter(this, mlc);
            }
            case "THREATTABLERANDOMTARGET": 
            case "RANDOMTHREATTARGET": 
            case "RTT": {
                return new ThreatTableRandomTargeter(this, mlc);
            }
            case "PLAYERSNEARORIGIN": 
            case "PLAYERSNEARSOURCE": {
                return new PlayersNearOriginTargeter(this, mlc);
            }
            case "MOBSNEARORIGIN": 
            case "MOBSNEARSOURCE": {
                return new MobsNearOriginTargeter(this, mlc);
            }
            case "PARENTENTITIES": 
            case "PE": {
                return new MPEntity(this, mlc);
            }
            case "PARENTLOCATIONS": 
            case "PL": {
                return new MPLocation(this, mlc);
            }
            case "PARENTMETA": 
            case "PM": {
                return new MPMeta(this, mlc);
            }
            case "CONSOLE": 
            case "NONE": {
                return new ConsoleTargeter(this, mlc);
            }
        }
        if (search.substring(1, 2).equals("[")) {
            switch (search.substring(0, 1).toLowerCase()) {
                case "p": 
                case "r": 
                case "a": 
                case "e": {
                    return new VanillaTargeter(this, mlc, mlc.getLine());
                }
            }
        }
        return new CustomTargeter(this, search.toUpperCase(), mlc);
    }

    @Override
    public SkillTargeter getTargeter(String strTarget) {
        String search = strTarget.substring(1);
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(search);
        String name = search.contains("{") ? search.substring(0, search.indexOf("{")) : search;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTargeter {0}", search);
        return ((MythicBukkit)this.getPlugin()).getSkillManager().getTargeter(name, mlc);
    }

    @Override
    public AbstractLocation getLocationTarget(SkillTargeter targeter, SkillMetadata data) {
        IEntityTargeter entityTargeter;
        AbstractEntity[] entities;
        Collection<AbstractLocation> locations;
        if (targeter instanceof CustomTargeter && ((CustomTargeter)targeter).getTargeter().isPresent()) {
            targeter = ((CustomTargeter)targeter).getTargeter().get();
        }
        AbstractLocation newOrigin = targeter instanceof ILocationSelector ? (!(locations = ((ILocationSelector)targeter).getLocations(data)).isEmpty() ? (AbstractLocation)locations.stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
            Collections.shuffle(collected);
            return collected.stream();
        })).findFirst().get() : data.getOrigin()) : (targeter instanceof TriggerLocationTargeter ? data.getTrigger().getLocation() : (targeter instanceof IEntityTargeter ? ((entities = (entityTargeter = (IEntityTargeter)((Object)targeter)).getEntities(data).toArray(new AbstractEntity[0])).length > 0 ? entities[0].getLocation() : data.getOrigin()) : data.getOrigin()));
        return newOrigin;
    }

    public ImmutableMap<String, Class<? extends SkillCondition>> getConditions() {
        return ImmutableMap.copyOf(CONDITIONS);
    }

    @Override
    public SkillCondition getCondition(String condition) {
        if (((String)condition).startsWith("(")) {
            try {
                return new CompositeCondition(this, (String)condition);
            }
            catch (Error | Exception ex) {
                MythicLogger.error("Failed to construct composite condition {0}", condition);
                ex.printStackTrace();
                return new InvalidCondition((String)condition);
            }
        }
        if (((String)(condition = MythicLineConfigImpl.unparseBlock((String)condition))).contains("}")) {
            String sp1 = ((String)condition).substring(0, ((String)condition).indexOf("}"));
            String sp2 = ((String)condition).substring(((String)condition).indexOf("}"));
            String ns = sp1.replace(" ", "") + sp2;
            condition = ns;
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, ": Normalized Condition string to: " + (String)condition, new Object[0]);
        }
        String[] s2 = ((String)condition).split(" ");
        String name = null;
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicCondition type to " + name, new Object[0]);
        ImmutableMap<String, Class<? extends SkillCondition>> CONDITIONS = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions();
        if (CONDITIONS.containsKey(name.toUpperCase())) {
            Class clazz = (Class)CONDITIONS.get(name.toUpperCase());
            try {
                return (SkillCondition)clazz.getConstructor(String.class, MythicLineConfig.class).newInstance(condition, mlc);
            }
            catch (Error | Exception ex) {
                MythicLogger.error("Failed to construct condition {0}", condition);
                ex.printStackTrace();
                return new InvalidCondition((String)condition);
            }
        }
        try {
            return new CustomCondition(name, (String)condition, mlc);
        }
        catch (Error | Exception ex) {
            MythicLogger.error("Failed to load condition '" + name + "'");
            ex.printStackTrace();
            return new InvalidCondition((String)condition);
        }
    }

    @Override
    public List<SkillCondition> getConditions(List<String> block) {
        ArrayList<SkillCondition> conditions = null;
        for (String s2 : block) {
            SkillCondition sc = this.getCondition(s2 = MythicLineConfigImpl.unparseBlock(s2));
            if (sc instanceof InvalidCondition) continue;
            if (conditions == null) {
                conditions = new ArrayList<SkillCondition>();
            }
            conditions.add(sc);
        }
        return conditions;
    }

    @Override
    public List<SkillCondition> getConditions(String block) {
        if (block.startsWith("[") && block.endsWith("]")) {
            block = block.substring(1, block.length() - 1);
            block = MythicLineConfigImpl.unparseBlock(block);
            String[] split = block.split("-");
            ArrayList<String> elements = new ArrayList<String>();
            for (String e : split) {
                if (e.trim().length() == 0) continue;
                elements.add(e.trim());
            }
            return this.getConditions(elements);
        }
        return null;
    }

    public ImmutableMap<String, Class<? extends SkillAudience>> getAudiences() {
        return ImmutableMap.copyOf(AUDIENCES);
    }

    @Override
    public SkillAudience getAudience(String line) {
        if (line == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching Audience type to " + line, new Object[0]);
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(line);
        if (line.startsWith("@")) {
            return new TargeterAudience(mlc, line);
        }
        String search = line.contains("{") ? line.substring(0, line.indexOf("{")) : line;
        ImmutableMap<String, Class<? extends SkillAudience>> AUDIENCES = ((MythicBukkit)this.getPlugin()).getSkillManager().getAudiences();
        if (AUDIENCES.containsKey(search.toUpperCase())) {
            Class clazz = (Class)AUDIENCES.get(search.toUpperCase());
            try {
                return (SkillAudience)clazz.getConstructor(MythicLineConfig.class).newInstance(mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct audience {0}", search);
                e.printStackTrace();
            }
        }
        return new CustomAudience(mlc);
    }

    private final void loadSkillComponents() {
        Collection<Class<?>> conditionsClasses = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.conditions.all", MythicCondition.class);
        for (Class<?> clazz : conditionsClasses) {
            try {
                String string = clazz.getAnnotation(MythicCondition.class).name();
                String[] stringArray = clazz.getAnnotation(MythicCondition.class).aliases();
                if (!SkillCondition.class.isAssignableFrom(clazz)) continue;
                CONDITIONS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    CONDITIONS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load condition {0}", clazz.getCanonicalName());
            }
        }
        Collection<Class<?>> mechanicsClasses = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.mechanics", MythicMechanic.class);
        for (Class<?> clazz : mechanicsClasses) {
            try {
                String string = clazz.getAnnotation(MythicMechanic.class).name();
                String[] aliases = clazz.getAnnotation(MythicMechanic.class).aliases();
                if (!SkillMechanic.class.isAssignableFrom(clazz)) continue;
                MECHANICS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    MECHANICS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load mechanic {0}", clazz.getCanonicalName());
            }
        }
        Collection<Class<?>> collection = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.targeters", MythicTargeter.class);
        for (Class<?> clazz : collection) {
            try {
                String name = clazz.getAnnotation(MythicTargeter.class).name();
                String[] aliases = clazz.getAnnotation(MythicTargeter.class).aliases();
                if (!SkillTargeter.class.isAssignableFrom(clazz)) continue;
                TARGETERS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    TARGETERS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load targeter {0}", clazz.getCanonicalName());
            }
        }
        Collection<Class<?>> collection2 = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.audience", MythicAudience.class);
        for (Class<?> clazz : collection2) {
            try {
                String name = clazz.getAnnotation(MythicAudience.class).name();
                String[] aliases = clazz.getAnnotation(MythicAudience.class).aliases();
                if (!SkillAudience.class.isAssignableFrom(clazz)) continue;
                AUDIENCES.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    AUDIENCES.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load audience {0}", clazz.getCanonicalName());
            }
        }
    }

    public AuraManager getAuraManager() {
        return this.auraManager;
    }

    public EventExecutor getEventBus() {
        return this.eventBus;
    }
}

