/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.mechanics.CancelSkill;
import io.lumine.mythic.core.skills.mechanics.DelaySkill;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MetaSkill
extends AbstractSkill
implements Skill {
    protected final File file;
    protected final String internalName;
    protected final MythicConfig config;
    protected final Collection<SkillHolder> parents = Lists.newArrayList();
    protected Map<String, SkillAction> actions = new HashMap<String, SkillAction>();
    protected SkillAction baseSkill = new SkillAction("Skill", new String[0]).register(this.actions);
    protected SkillAction failedConditionsSkill = new SkillAction("OnFailSkill", "FailedConditionsSkill").register(this.actions);
    protected SkillAction onCooldownSkill = new SkillAction("OnCooldownSkill", new String[0]).register(this.actions);
    protected boolean stopIfNoTargets = false;
    protected boolean inlineSkill = false;
    protected List<String> killMessages;

    public MetaSkill(SkillExecutor manager, Pack pack, File file, String name, MythicConfig mc) {
        super(manager, file);
        SkillCondition sc;
        String ns;
        int i;
        String[] split;
        this.pack = pack;
        this.file = file;
        this.internalName = name;
        this.config = mc;
        String cd2 = mc.getString("Cooldown", null);
        if (cd2 != null) {
            this.cooldown = PlaceholderDouble.of(cd2);
        }
        this.stopIfNoTargets = mc.getBoolean("CancelIfNoTargets", true);
        this.actions.forEach((id, action) -> {
            String maybeRedirect = mc.getString((String)id, null);
            if (maybeRedirect != null) {
                this.getManager().queueSecondPass(() -> action.setRedirect(this.getPlugin().getSkillManager().getSkill(file, this, maybeRedirect)));
            }
            mc.getStringList(id + "s").forEach(mechanic -> {
                mechanic = MythicLineConfigImpl.unparseBlock(mechanic);
                try {
                    SkillMechanic mechanicSkill = this.getPlugin().getSkillManager().getMechanic(pack, mc.getFile(), this, (String)mechanic);
                    if (mechanicSkill != null) {
                        mechanicSkill.setParent(this);
                        action.addMechanic(mechanicSkill);
                    }
                }
                catch (Error | Exception ex) {
                    MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + mechanic + "'");
                }
            });
        });
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TargetConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTarget == null) {
                this.conditionsTarget = new ArrayList();
            }
            this.conditionsTarget.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTrigger == null) {
                this.conditionsTrigger = new ArrayList();
            }
            this.conditionsTrigger.add(sc);
        }
    }

    public MetaSkill(SkillExecutor manager, File file, Collection<String> skillList) {
        super(manager, file);
        this.pack = ((MythicBukkit)manager.getPlugin()).getPackManager().getBasePack();
        this.file = null;
        this.internalName = "#\u03bb." + UUID.randomUUID().toString();
        this.config = null;
        this.cooldown = null;
        for (String s2 : skillList) {
            s2 = MythicLineConfigImpl.unparseBlock(s2);
            SkillMechanic ms = null;
            try {
                ms = MythicBukkit.inst().getSkillManager().getMechanic(s2);
                ms.setParent(this);
                ms.setPack(this.pack);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            catch (Error ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            if (ms == null) continue;
            this.baseSkill.addMechanic(ms);
        }
    }

    @Override
    public void addParent(SkillHolder parent) {
        this.parents.add(parent);
    }

    @Override
    public boolean isUsable(SkillMetadata data) {
        return this.isUsable(data, null);
    }

    @Override
    public boolean isUsable(SkillMetadata meta, SkillTrigger trigger) {
        SkillCaster skillCaster = meta.getCaster();
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Cooldown check failed.", new Object[0]);
            this.execute(this.onCooldownSkill, meta);
            return false;
        }
        if (this.conditionsTarget != null) {
            for (SkillCondition mc : this.conditionsTarget) {
                if (!mc.evaluateTargets(meta) && this.stopIfNoTargets) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    this.execute(this.failedConditionsSkill, meta);
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (!mc.evaluateTrigger(meta)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TriggerConditions failed.", new Object[0]);
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    this.execute(this.failedConditionsSkill, meta);
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (!mc.evaluateCaster(meta)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Conditions failed.", new Object[0]);
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    this.execute(this.failedConditionsSkill, meta);
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill usable!", new Object[0]);
        return true;
    }

    @Override
    public void execute(SkillTrigger basetrigger, SkillCaster caster, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadataImpl data = new SkillMetadataImpl(basetrigger, caster, trigger, origin, eTargets, lTargets, power);
        this.execute(data);
    }

    @Override
    public void execute(SkillMetadata data) {
        LinkedList skillqueue = (LinkedList)this.baseSkill.getMechanics().clone();
        try {
            this.baseSkill.executeRedirect(data);
            MetaSkill.execute(data, skillqueue);
        }
        catch (Exception ex) {
            MythicLogger.error("Couldn't execute skill '" + this.internalName + "': Enable debugging for a stack trace.");
            MythicLogger.handleMinorError(ex);
        }
        this.triggerCooldown(data);
    }

    public void execute(SkillAction action, SkillMetadata data) {
        LinkedList skillqueue = (LinkedList)action.getMechanics().clone();
        try {
            action.executeRedirect(data);
            MetaSkill.execute(data, skillqueue);
        }
        catch (Exception ex) {
            MythicLogger.error("Couldn't execute " + action.getId() + " '" + this.internalName + "': Enable debugging for a stack trace.");
            MythicLogger.handleMinorError(ex);
        }
        if (action == this.baseSkill) {
            this.triggerCooldown(data);
        }
    }

    public static void execute(SkillMetadata data, Queue<SkillMechanic> skillqueue) {
        while (skillqueue.size() > 0) {
            SkillMechanic mbs = skillqueue.poll();
            if (data.isTerminated()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Terminating SkillMechanic {0}.", mbs.getConfigLine());
                break;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Evaluating SkillMechanic {0}", mbs.getConfigLine());
            if (mbs instanceof CancelSkill && mbs.isUsableFromSkill(data)) break;
            if (mbs instanceof DelaySkill) {
                AbstractSkill.DelayedSkill ds = new AbstractSkill.DelayedSkill(data, skillqueue);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicBukkit.inst(), (Runnable)ds, (long)((DelaySkill)mbs).getTicks(data));
                break;
            }
            if (!mbs.isUsableFromSkill(data)) continue;
            mbs.execute(data.deepClone());
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public MythicConfig getConfig() {
        return this.config;
    }

    @Override
    public Collection<SkillHolder> getParents() {
        return this.parents;
    }

    @Override
    public boolean isInlineSkill() {
        return this.inlineSkill;
    }

    public void setInlineSkill(boolean inlineSkill) {
        this.inlineSkill = inlineSkill;
    }

    public static class SkillAction {
        private final String id;
        private final String[] aliases;
        private Optional<Skill> redirect = Optional.empty();
        private LinkedList<SkillMechanic> mechanics = new LinkedList();

        public SkillAction(String id, String ... aliases) {
            this.id = id;
            this.aliases = aliases;
        }

        public void executeRedirect(SkillMetadata meta) {
            this.redirect.ifPresent(skill -> skill.execute(meta));
        }

        public void addMechanic(SkillMechanic ms) {
            this.mechanics.add(ms);
        }

        public SkillAction register(Map<String, SkillAction> actions) {
            actions.put(this.id, this);
            for (String alias : this.aliases) {
                actions.put(alias, this);
            }
            return this;
        }

        public String getId() {
            return this.id;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public Optional<Skill> getRedirect() {
            return this.redirect;
        }

        public LinkedList<SkillMechanic> getMechanics() {
            return this.mechanics;
        }

        public void setRedirect(Optional<Skill> redirect) {
            this.redirect = redirect;
        }

        public void setMechanics(LinkedList<SkillMechanic> mechanics) {
            this.mechanics = mechanics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SkillAction)) {
                return false;
            }
            SkillAction other = (SkillAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAliases(), other.getAliases())) {
                return false;
            }
            Optional<Skill> this$redirect = this.getRedirect();
            Optional<Skill> other$redirect = other.getRedirect();
            if (this$redirect == null ? other$redirect != null : !((Object)this$redirect).equals(other$redirect)) {
                return false;
            }
            LinkedList<SkillMechanic> this$mechanics = this.getMechanics();
            LinkedList<SkillMechanic> other$mechanics = other.getMechanics();
            return !(this$mechanics == null ? other$mechanics != null : !((Object)this$mechanics).equals(other$mechanics));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SkillAction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAliases());
            Optional<Skill> $redirect = this.getRedirect();
            result = result * 59 + ($redirect == null ? 43 : ((Object)$redirect).hashCode());
            LinkedList<SkillMechanic> $mechanics = this.getMechanics();
            result = result * 59 + ($mechanics == null ? 43 : ((Object)$mechanics).hashCode());
            return result;
        }

        public String toString() {
            return "MetaSkill.SkillAction(id=" + this.getId() + ", aliases=" + Arrays.deepToString(this.getAliases()) + ", redirect=" + String.valueOf(this.getRedirect()) + ", mechanics=" + String.valueOf(this.getMechanics()) + ")";
        }
    }
}

