/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.api.skills.targeters.ISkillTargeter;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicDropLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicTargeterLoadEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicDrop;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomComponentRegistry {
    private final Map<String, Constructor<? extends IDrop>> drops = Maps.newConcurrentMap();
    private final Map<String, Constructor<? extends ISkillMechanic>> mechanics = Maps.newConcurrentMap();
    private final Map<String, Constructor<? extends ISkillCondition>> conditions = Maps.newConcurrentMap();
    private final Map<String, Constructor<? extends ISkillTargeter>> targeters = Maps.newConcurrentMap();

    public CustomComponentRegistry(JavaPlugin plugin, String packagePath) {
        this(plugin, Lists.newArrayList(), Lists.newArrayList((Object[])new String[]{packagePath}));
    }

    public CustomComponentRegistry(JavaPlugin plugin, Collection<String> packages) {
        this(plugin, Lists.newArrayList(), packages);
    }

    public CustomComponentRegistry(JavaPlugin plugin, Collection<String> namespaces, Collection<String> packages) {
        ArrayList toAppend = Lists.newArrayList();
        toAppend.add(plugin.getName().toUpperCase());
        for (String namespace : namespaces) {
            toAppend.add(namespace.toUpperCase());
        }
        for (String packagePath : packages) {
            Object clazz32;
            Collection<Class<?>> dropClasses = AnnotationUtil.getAnnotatedClasses(plugin, packagePath, MythicDrop.class);
            for (Class<?> clazz : dropClasses) {
                try {
                    String name = clazz.getAnnotation(MythicDrop.class).name();
                    String[] stringArray = clazz.getAnnotation(MythicDrop.class).aliases();
                    if (!IDrop.class.isAssignableFrom(clazz)) continue;
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz.getConstructor(plugin.getClass(), MythicDropLoadEvent.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz.getConstructor(MythicDropLoadEvent.class);
                    }
                    if (constructor == null) continue;
                    this.drops.put(name.toUpperCase(), constructor);
                    for (String alias : stringArray) {
                        this.drops.put(alias.toUpperCase(), constructor);
                    }
                    for (String append : toAppend) {
                        this.drops.put(name.toUpperCase(), constructor);
                        for (String alias : stringArray) {
                            this.drops.put(alias.toUpperCase(), constructor);
                        }
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error("Failed to register custom drop {0}", clazz.getCanonicalName());
                    ex.printStackTrace();
                }
            }
            Collection<Class<?>> mechanicsClasses = AnnotationUtil.getAnnotatedClasses(plugin, packagePath, MythicMechanic.class);
            for (Object clazz32 : mechanicsClasses) {
                try {
                    String string = ((Class)clazz32).getAnnotation(MythicMechanic.class).name();
                    String[] aliases = ((Class)clazz32).getAnnotation(MythicMechanic.class).aliases();
                    if (!ISkillMechanic.class.isAssignableFrom((Class<?>)clazz32)) continue;
                    Constructor constructor = null;
                    try {
                        constructor = ((Class)clazz32).getConstructor(plugin.getClass(), MythicMechanicLoadEvent.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = ((Class)clazz32).getConstructor(MythicMechanicLoadEvent.class);
                    }
                    if (constructor == null) continue;
                    this.mechanics.put(string.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.mechanics.put(alias.toUpperCase(), constructor);
                    }
                    for (String append : toAppend) {
                        this.mechanics.put(string.toUpperCase(), constructor);
                        for (String alias : aliases) {
                            this.mechanics.put(alias.toUpperCase(), constructor);
                        }
                    }
                }
                catch (Throwable throwable) {
                    MythicLogger.error("Failed to register custom mechanic {0}", ((Class)clazz32).getCanonicalName());
                    throwable.printStackTrace();
                }
            }
            Collection<Class<?>> collection = AnnotationUtil.getAnnotatedClasses(plugin, packagePath, MythicCondition.class);
            clazz32 = collection.iterator();
            while (clazz32.hasNext()) {
                Class clazz = (Class)clazz32.next();
                try {
                    String name = clazz.getAnnotation(MythicCondition.class).name();
                    String[] aliases = clazz.getAnnotation(MythicCondition.class).aliases();
                    if (!ISkillCondition.class.isAssignableFrom(clazz)) continue;
                    Constructor constructor = null;
                    try {
                        constructor = clazz.getConstructor(plugin.getClass(), MythicConditionLoadEvent.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz.getConstructor(MythicConditionLoadEvent.class);
                    }
                    if (constructor == null) continue;
                    this.conditions.put(name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.conditions.put(alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error("Failed to register custom condition {0}", clazz.getCanonicalName());
                    ex.printStackTrace();
                }
            }
            Collection<Class<?>> targeterClasses = AnnotationUtil.getAnnotatedClasses(plugin, packagePath, MythicTargeter.class);
            for (Class<?> clazz5 : targeterClasses) {
                try {
                    String name = clazz5.getAnnotation(MythicTargeter.class).name();
                    String[] aliases = clazz5.getAnnotation(MythicTargeter.class).aliases();
                    if (!ISkillTargeter.class.isAssignableFrom(clazz5)) continue;
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz5.getConstructor(plugin.getClass(), MythicTargeterLoadEvent.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz5.getConstructor(MythicTargeterLoadEvent.class);
                    }
                    if (constructor == null) continue;
                    this.targeters.put(name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.targeters.put(alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error("Failed to register custom targeter {0}", clazz5.getCanonicalName());
                    ex.printStackTrace();
                }
            }
        }
        Events.subscribe(MythicDropLoadEvent.class).handler(event -> {
            String name = event.getDropName().toUpperCase();
            if (this.drops.containsKey(name)) {
                Constructor<? extends IDrop> constructor = this.drops.get(name);
                try {
                    if (constructor.getParameterCount() == 2) {
                        event.register(constructor.newInstance(plugin, event));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("Failed to construct drop {0}", name);
                    e.printStackTrace();
                }
            }
        });
        Events.subscribe(MythicMechanicLoadEvent.class).handler(event -> {
            String name = event.getMechanicName().toUpperCase();
            if (this.mechanics.containsKey(name)) {
                Constructor<? extends ISkillMechanic> constructor = this.mechanics.get(name);
                try {
                    if (constructor.getParameterCount() == 2) {
                        event.register(constructor.newInstance(plugin, event));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("Failed to construct mechanic {0}", name);
                    e.printStackTrace();
                }
            }
        });
        Events.subscribe(MythicConditionLoadEvent.class).handler(event -> {
            String name = event.getConditionName().toUpperCase();
            if (this.conditions.containsKey(name)) {
                Constructor<? extends ISkillCondition> constructor = this.conditions.get(name);
                try {
                    if (constructor.getParameterCount() == 2) {
                        event.register(constructor.newInstance(plugin, event));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("Failed to construct condition {0}", name);
                    e.printStackTrace();
                }
            }
        });
        Events.subscribe(MythicTargeterLoadEvent.class).handler(event -> {
            String name = event.getTargeterName().toUpperCase();
            if (this.targeters.containsKey(name)) {
                Constructor<? extends ISkillTargeter> constructor = this.targeters.get(name);
                try {
                    if (constructor.getParameterCount() == 2) {
                        event.register(constructor.newInstance(plugin, event));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("Failed to construct targeter {0}", name);
                    e.printStackTrace();
                }
            }
        });
    }
}

