/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.players;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.storage.players.Profile;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;

public class PlayerData
implements Profile,
SkillCaster {
    private UUID uniqueId;
    private String name;
    private long timestamp = System.currentTimeMillis();
    private VariableRegistry variables = new VariableRegistry();
    private transient AbstractPlayer entity;
    private transient boolean usingDamageSkill = false;
    private transient StatRegistry statRegistry;
    private transient Collection<AbstractEntity> children = Sets.newConcurrentHashSet();
    private HashMap<String, Double> pity = new HashMap();

    public PlayerData() {
    }

    public PlayerData(UUID uniqueId, String name) {
        this.uniqueId = uniqueId;
        this.name = name;
    }

    public void initialize(AbstractPlayer player) {
        this.entity = player;
        this.statRegistry = new StatRegistry(MythicBukkit.inst().getStatManager(), this);
    }

    @Override
    public void addChild(AbstractEntity entity) {
        this.children.add(entity);
    }

    @Override
    public void removeChild(AbstractEntity entity) {
        this.children.remove(entity);
    }

    public void addPity(double amount, String category) {
        this.pity.put(category, this.getPity(category) + amount);
    }

    public void resetPity(String category) {
        this.pity.remove(category);
    }

    public void setPity(double amount, String category) {
        this.pity.put(category, amount);
    }

    public void removePity(double amount, String category) {
        this.pity.put(category, this.getPity(category) - amount);
    }

    public double getPity(String category) {
        return this.pity.getOrDefault(category, 0.0);
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public VariableRegistry getVariables() {
        return this.variables;
    }

    @Override
    public AbstractPlayer getEntity() {
        return this.entity;
    }

    @Override
    public boolean isUsingDamageSkill() {
        return this.usingDamageSkill;
    }

    @Override
    public void setUsingDamageSkill(boolean usingDamageSkill) {
        this.usingDamageSkill = usingDamageSkill;
    }

    @Override
    public StatRegistry getStatRegistry() {
        return this.statRegistry;
    }

    @Override
    public Collection<AbstractEntity> getChildren() {
        return this.children;
    }

    public HashMap<String, Double> getPity() {
        return this.pity;
    }
}

